/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.multires;

import bdv.ViewerImgLoader;
import bdv.ViewerSetupImgLoader;
import bdv.cache.CacheControl;
import bvv.core.multires.MultiResolutionStack3D;
import bvv.core.multires.ResolutionLevel3D;
import bvv.core.multires.Stacks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.BasicMultiResolutionSetupImgLoader;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.TimePoint;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.realtransform.AffineTransform3D;

public class SpimDataStacks
implements Stacks {
    private final AbstractSpimData<?> spimData;
    private final ViewRegistrations registrations;
    private final CacheControl cacheControl;
    private final List<? extends BasicViewSetup> setups;
    private final List<TimePoint> timepoints;

    public SpimDataStacks(AbstractSpimData<?> spimData) {
        this.spimData = spimData;
        this.registrations = spimData.getViewRegistrations();
        this.setups = spimData.getSequenceDescription().getViewSetupsOrdered();
        this.timepoints = spimData.getSequenceDescription().getTimePoints().getTimePointsOrdered();
        this.cacheControl = ((ViewerImgLoader)spimData.getSequenceDescription().getImgLoader()).getCacheControl();
    }

    @Override
    public int timepointId(int timepointIndex) {
        return this.timepoints.get(timepointIndex).getId();
    }

    @Override
    public int setupId(int setupIndex) {
        return this.setups.get(setupIndex).getId();
    }

    @Override
    public MultiResolutionStack3D<?> getStack(int timepointId, int setupId, boolean volatil) {
        int level;
        Object type;
        AffineTransform3D model = this.registrations.getViewRegistration(timepointId, setupId).getModel();
        BasicSetupImgLoader sil = this.spimData.getSequenceDescription().getImgLoader().getSetupImgLoader(setupId);
        int numMipmapLevels = 1;
        Object resolutions = new int[][]{{1, 1, 1}};
        if (sil instanceof BasicMultiResolutionSetupImgLoader) {
            BasicMultiResolutionSetupImgLoader msil = (BasicMultiResolutionSetupImgLoader)sil;
            numMipmapLevels = msil.numMipmapLevels();
            resolutions = new int[numMipmapLevels][3];
            for (int level2 = 0; level2 < numMipmapLevels; ++level2) {
                for (int d = 0; d < 3; ++d) {
                    resolutions[level2][d] = (int)msil.getMipmapResolutions()[level2][d];
                }
            }
        }
        RandomAccessibleInterval[] rais = new RandomAccessibleInterval[numMipmapLevels];
        if (sil instanceof ViewerSetupImgLoader) {
            ViewerSetupImgLoader vsil = (ViewerSetupImgLoader)sil;
            type = volatil ? vsil.getVolatileImageType() : vsil.getImageType();
            for (level = 0; level < numMipmapLevels; ++level) {
                rais[level] = vsil.getVolatileImage(timepointId, level, new ImgLoaderHint[0]);
            }
        } else {
            type = sil.getImageType();
            if (volatil && !(type instanceof Volatile)) {
                throw new IllegalArgumentException();
            }
            if (sil instanceof BasicMultiResolutionSetupImgLoader) {
                BasicMultiResolutionSetupImgLoader msil = (BasicMultiResolutionSetupImgLoader)sil;
                for (level = 0; level < numMipmapLevels; ++level) {
                    rais[level] = msil.getImage(timepointId, level, new ImgLoaderHint[0]);
                }
            } else {
                rais[0] = sil.getImage(timepointId, new ImgLoaderHint[0]);
            }
        }
        ResolutionLevel3DImp[] resolutionLevels = new ResolutionLevel3DImp[numMipmapLevels];
        for (level = 0; level < numMipmapLevels; ++level) {
            resolutionLevels[level] = new ResolutionLevel3DImp<Object>(level, timepointId, setupId, this.spimData, resolutions[level], rais[level], type);
        }
        return new MultiResolutionStack3DImp<Object>(timepointId, setupId, this.spimData, model, resolutionLevels, type);
    }

    @Override
    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    @Override
    public int getNumTimepoints() {
        return this.timepoints.size();
    }

    static class ResolutionLevel3DImp<T>
    implements ResolutionLevel3D<T> {
        private final int level;
        private final int timepointId;
        private final int setupId;
        private final AbstractSpimData<?> spimData;
        private final int[] resolution;
        private final RandomAccessibleInterval<T> rai;
        private final T type;
        private final double[] scale;
        private final AffineTransform3D levelt;

        public ResolutionLevel3DImp(int level, int timepointId, int setupId, AbstractSpimData<?> spimData, int[] resolution, RandomAccessibleInterval<T> rai, T type) {
            this.level = level;
            this.timepointId = timepointId;
            this.setupId = setupId;
            this.spimData = spimData;
            this.resolution = resolution;
            this.rai = rai;
            this.type = type;
            this.scale = new double[3];
            this.levelt = new AffineTransform3D();
            for (int d = 0; d < 3; ++d) {
                this.scale[d] = 1.0 / (double)resolution[d];
                this.levelt.set((double)resolution[d], d, d);
                this.levelt.set(0.5 * (double)(resolution[d] - 1), d, 3);
            }
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public int[] getR() {
            return this.resolution;
        }

        @Override
        public double[] getS() {
            return this.scale;
        }

        @Override
        public AffineTransform3D getLevelTransform() {
            return this.levelt;
        }

        @Override
        public RandomAccessibleInterval<T> getImage() {
            return this.rai;
        }

        @Override
        public T getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolutionLevel3DImp that = (ResolutionLevel3DImp)o;
            if (this.level != that.level) {
                return false;
            }
            if (this.timepointId != that.timepointId) {
                return false;
            }
            if (this.setupId != that.setupId) {
                return false;
            }
            return this.spimData.equals(that.spimData);
        }

        public int hashCode() {
            int result = this.level;
            result = 31 * result + this.timepointId;
            result = 31 * result + this.setupId;
            result = 31 * result + this.spimData.hashCode();
            return result;
        }
    }

    static class MultiResolutionStack3DImp<T>
    implements MultiResolutionStack3D<T> {
        private final int timepointId;
        private final int setupId;
        private final AbstractSpimData<?> spimData;
        private final AffineTransform3D sourceTransform;
        private final ArrayList<ResolutionLevel3DImp<T>> resolutions;
        private final T type;

        public MultiResolutionStack3DImp(int timepointId, int setupId, AbstractSpimData<?> spimData, AffineTransform3D sourceTransform, ResolutionLevel3DImp<T>[] resolutions, T type) {
            this.timepointId = timepointId;
            this.setupId = setupId;
            this.spimData = spimData;
            this.sourceTransform = sourceTransform;
            this.resolutions = new ArrayList<ResolutionLevel3DImp<T>>(Arrays.asList(resolutions));
            this.type = type;
        }

        @Override
        public AffineTransform3D getSourceTransform() {
            return this.sourceTransform;
        }

        @Override
        public List<ResolutionLevel3DImp<T>> resolutions() {
            return this.resolutions;
        }

        @Override
        public T getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiResolutionStack3DImp that = (MultiResolutionStack3DImp)o;
            if (this.timepointId != that.timepointId) {
                return false;
            }
            if (this.setupId != that.setupId) {
                return false;
            }
            return this.spimData.equals(that.spimData);
        }

        public int hashCode() {
            int result = this.timepointId;
            result = 31 * result + this.setupId;
            result = 31 * result + this.spimData.hashCode();
            return result;
        }
    }
}

