/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.offscreen;

import bvv.core.backend.jogl.JoglGpuContext;
import bvv.core.shadergen.DefaultShader;
import bvv.core.shadergen.generate.Segment;
import bvv.core.shadergen.generate.SegmentTemplate;
import com.jogamp.opengl.GL3;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.real.FloatType;

public class OffScreenFrameBuffer {
    private final boolean withDepthAndStencil;
    private final boolean flipY;
    private int vaoQuad;
    private final DefaultShader progQuad;
    private int framebuffer;
    private int texColorBuffer;
    private final int fbWidth;
    private final int fbHeight;
    private final int internalFormat;
    private int[] viewport = new int[4];
    private float[] rgb;
    private Img<FloatType> img;
    private boolean framebufferInitialized;
    private boolean quadInitialized;
    private boolean imgInitialized;
    private boolean imgValid;
    private int restoreFramebuffer;

    public OffScreenFrameBuffer(int fbWidth, int fbHeight) {
        this(fbWidth, fbHeight, 34837);
    }

    public OffScreenFrameBuffer(int fbWidth, int fbHeight, int internalFormat) {
        this(fbWidth, fbHeight, internalFormat, false, false);
    }

    public OffScreenFrameBuffer(int fbWidth, int fbHeight, int internalFormat, boolean withDepthAndStencil, boolean flipY) {
        this.fbWidth = fbWidth;
        this.fbHeight = fbHeight;
        this.internalFormat = internalFormat;
        this.withDepthAndStencil = withDepthAndStencil;
        this.flipY = flipY;
        Segment quadvp = new SegmentTemplate(OffScreenFrameBuffer.class, "osfbquad.vp", new String[0]).instantiate();
        Segment quadfp = new SegmentTemplate(OffScreenFrameBuffer.class, "osfbquad.fp", new String[0]).instantiate();
        this.progQuad = new DefaultShader(quadvp.getCode(), quadfp.getCode());
    }

    private void initFrameBuffer(GL3 gl) {
        if (this.framebufferInitialized) {
            return;
        }
        this.framebufferInitialized = true;
        int[] tmp = new int[1];
        gl.glGenFramebuffers(1, tmp, 0);
        this.framebuffer = tmp[0];
        gl.glGetIntegerv(36006, tmp, 0);
        this.restoreFramebuffer = tmp[0];
        gl.glBindFramebuffer(36160, this.framebuffer);
        gl.glGenTextures(1, tmp, 0);
        this.texColorBuffer = tmp[0];
        gl.glBindTexture(3553, this.texColorBuffer);
        gl.glTexStorage2D(3553, 1, this.internalFormat, this.fbWidth, this.fbHeight);
        gl.glBindTexture(3553, 0);
        gl.glFramebufferTexture2D(36160, 36064, 3553, this.texColorBuffer, 0);
        if (this.withDepthAndStencil) {
            gl.glGenRenderbuffers(1, tmp, 0);
            int rbo = tmp[0];
            gl.glBindRenderbuffer(36161, rbo);
            gl.glRenderbufferStorage(36161, 35056, this.fbWidth, this.fbHeight);
            gl.glBindRenderbuffer(36161, 0);
            gl.glFramebufferRenderbuffer(36160, 33306, 36161, rbo);
        }
        if (gl.glCheckFramebufferStatus(36160) != 36053) {
            System.err.println("ERROR::FRAMEBUFFER:: Framebuffer is not complete!");
        }
        gl.glBindFramebuffer(36160, this.restoreFramebuffer);
    }

    private void initQuad(GL3 gl) {
        if (this.quadInitialized) {
            return;
        }
        this.quadInitialized = true;
        float[] verticesQuad = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        float[] verticesQuadFlipY = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
        int[] tmp = new int[1];
        gl.glGenBuffers(1, tmp, 0);
        int vboQuad = tmp[0];
        gl.glBindBuffer(34962, vboQuad);
        gl.glBufferData(34962, (long)(verticesQuad.length * 4), (Buffer)FloatBuffer.wrap(this.flipY ? verticesQuadFlipY : verticesQuad), 35044);
        gl.glBindBuffer(34962, 0);
        int[] indices = new int[]{0, 3, 1, 1, 3, 2};
        gl.glGenBuffers(1, tmp, 0);
        int eboQuad = tmp[0];
        gl.glBindBuffer(34963, eboQuad);
        gl.glBufferData(34963, (long)(indices.length * 4), (Buffer)IntBuffer.wrap(indices), 35044);
        gl.glBindBuffer(34963, 0);
        gl.glGenVertexArrays(1, tmp, 0);
        this.vaoQuad = tmp[0];
        gl.glBindVertexArray(this.vaoQuad);
        gl.glBindBuffer(34962, vboQuad);
        gl.glVertexAttribPointer(0, 3, 5126, false, 20, 0L);
        gl.glEnableVertexAttribArray(0);
        gl.glVertexAttribPointer(1, 2, 5126, false, 20, 12L);
        gl.glEnableVertexAttribArray(1);
        gl.glBindBuffer(34963, eboQuad);
        gl.glBindVertexArray(0);
    }

    private void initImg() {
        if (this.imgInitialized) {
            return;
        }
        this.imgInitialized = true;
        this.rgb = new float[this.fbWidth * this.fbHeight * 3];
        this.img = ArrayImgs.floats((float[])this.rgb, (long[])new long[]{3L, this.fbWidth, this.fbHeight});
    }

    public Img<FloatType> getImg() {
        return this.img;
    }

    public int getTexColorBuffer() {
        return this.texColorBuffer;
    }

    public void bind(GL3 gl) {
        this.bind(gl, true);
    }

    public void unbind(GL3 gl) {
        this.unbind(gl, true);
    }

    public float get(int c, int x, int y) {
        if (!this.imgValid) {
            System.err.println("Img not valid. Call getTexture() first.");
        }
        RandomAccess a = this.img.randomAccess();
        a.setPosition(new long[]{c, x, y});
        return ((FloatType)a.get()).get();
    }

    public void bind(GL3 gl, boolean clear) {
        this.initFrameBuffer(gl);
        int[] tmp = new int[1];
        gl.glGetIntegerv(36006, tmp, 0);
        this.restoreFramebuffer = tmp[0];
        gl.glBindFramebuffer(36160, this.framebuffer);
        gl.glGetIntegerv(2978, this.viewport, 0);
        gl.glViewport(0, 0, this.fbWidth, this.fbHeight);
        if (clear) {
            gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gl.glClear(16640);
        }
    }

    public void unbind(GL3 gl, boolean getTexture) {
        gl.glBindFramebuffer(36160, this.restoreFramebuffer);
        gl.glViewport(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3]);
        this.imgValid = false;
        if (getTexture) {
            this.getTexture(gl);
        }
    }

    public void drawQuad(GL3 gl) {
        this.drawQuad(gl, 9729, 9729);
    }

    public void drawQuad(GL3 gl, int minFilter, int magFilter) {
        this.initQuad(gl);
        this.progQuad.use(JoglGpuContext.get(gl));
        gl.glActiveTexture(33984);
        gl.glBindTexture(3553, this.texColorBuffer);
        gl.glTexParameteri(3553, 10241, minFilter);
        gl.glTexParameteri(3553, 10240, magFilter);
        gl.glTexParameteri(3553, 10242, 33071);
        gl.glTexParameteri(3553, 10243, 33071);
        gl.glBindVertexArray(this.vaoQuad);
        gl.glDrawElements(4, 6, 5125, 0L);
        gl.glBindVertexArray(0);
        gl.glBindTexture(3553, 0);
    }

    public void getTexture(GL3 gl) {
        if (this.imgValid) {
            return;
        }
        this.imgValid = true;
        this.initImg();
        gl.glBindTexture(3553, this.texColorBuffer);
        gl.glGetTexImage(3553, 0, 6407, 5126, (Buffer)FloatBuffer.wrap(this.rgb));
        gl.glBindTexture(3553, 0);
    }

    public int getWidth() {
        return this.fbWidth;
    }

    public int getHeight() {
        return this.fbHeight;
    }
}

