/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.render;

import bvv.core.backend.GpuContext;
import bvv.core.backend.Texture3D;
import bvv.core.multires.SimpleStack3D;
import bvv.core.render.SimpleStackManager;
import bvv.core.render.SimpleVolume;
import bvv.core.render.VolumeTextureRGBA8;
import bvv.core.render.VolumeTextureU16;
import bvv.core.render.VolumeTextureU8;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.joml.Vector3f;

public class DefaultSimpleStackManager
implements SimpleStackManager {
    private final HashMap<SimpleStack3D<?>, VolumeTextureU16> texturesU16 = new HashMap();
    private final HashMap<SimpleStack3D<?>, VolumeTextureU8> texturesU8 = new HashMap();
    private final HashMap<SimpleStack3D<?>, VolumeTextureRGBA8> texturesRGBA8 = new HashMap();
    private final HashMap<Texture3D, Integer> timestamps = new HashMap();
    private int currentTimestamp = 0;

    @Override
    public synchronized SimpleVolume getSimpleVolume(GpuContext context, SimpleStack3D<?> stack) {
        Vector3f sourceMin;
        Vector3f sourceMax;
        Texture3D texture;
        RandomAccessibleInterval<?> image = stack.getImage();
        Object type = stack.getType();
        if (type instanceof UnsignedShortType) {
            texture = this.texturesU16.computeIfAbsent(stack, s -> DefaultSimpleStackManager.uploadToTextureU16(context, (RandomAccessibleInterval<UnsignedShortType>)image));
            sourceMax = new Vector3f((float)image.max(0), (float)image.max(1), (float)image.max(2));
            sourceMin = new Vector3f((float)image.min(0), (float)image.min(1), (float)image.min(2));
        } else if (type instanceof UnsignedByteType) {
            texture = this.texturesU8.computeIfAbsent(stack, s -> DefaultSimpleStackManager.uploadToTextureU8(context, (RandomAccessibleInterval<UnsignedByteType>)image));
            sourceMax = new Vector3f((float)image.max(0), (float)image.max(1), (float)image.max(2));
            sourceMin = new Vector3f((float)image.min(0), (float)image.min(1), (float)image.min(2));
        } else if (type instanceof ARGBType) {
            texture = this.texturesRGBA8.computeIfAbsent(stack, s -> DefaultSimpleStackManager.uploadToTextureRGBA8(context, (RandomAccessibleInterval<ARGBType>)image));
            sourceMax = new Vector3f((float)image.max(0), (float)image.max(1), (float)image.max(2));
            sourceMin = new Vector3f((float)image.min(0), (float)image.min(1), (float)image.min(2));
        } else {
            throw new IllegalArgumentException();
        }
        this.timestamps.put(texture, this.currentTimestamp);
        return new SimpleVolume(texture, stack.getSourceTransform(), sourceMin, sourceMax);
    }

    @Override
    public synchronized void freeUnusedSimpleVolumes(GpuContext context) {
        Iterator<Map.Entry<Texture3D, Integer>> it = this.timestamps.entrySet().iterator();
        this.texturesU16.entrySet().removeIf(entry -> this.timestamps.get(entry.getValue()) < this.currentTimestamp);
        this.texturesU8.entrySet().removeIf(entry -> this.timestamps.get(entry.getValue()) < this.currentTimestamp);
        this.texturesRGBA8.entrySet().removeIf(entry -> this.timestamps.get(entry.getValue()) < this.currentTimestamp);
        while (it.hasNext()) {
            Map.Entry<Texture3D, Integer> entry2 = it.next();
            if (entry2.getValue() >= this.currentTimestamp) continue;
            context.delete(entry2.getKey());
            it.remove();
        }
        ++this.currentTimestamp;
    }

    @Override
    public void freeSimpleVolumes(GpuContext context) {
        this.texturesU16.clear();
        this.texturesU8.clear();
        this.texturesRGBA8.clear();
        this.timestamps.keySet().forEach(context::delete);
        this.timestamps.clear();
    }

    private static VolumeTextureU16 uploadToTextureU16(GpuContext context, RandomAccessibleInterval<UnsignedShortType> rai) {
        VolumeTextureU16 texture = new VolumeTextureU16();
        texture.init(Intervals.dimensionsAsIntArray(rai));
        int numBytes = (int)(2L * Intervals.numElements(rai));
        ByteBuffer data = ByteBuffer.allocateDirect(numBytes);
        data.order(ByteOrder.nativeOrder());
        DefaultSimpleStackManager.copyToBufferU16(rai, data);
        texture.upload(context, data);
        return texture;
    }

    private static void copyToBufferU16(RandomAccessibleInterval<UnsignedShortType> rai, ByteBuffer buffer) {
        Cursor cursor = Views.flatIterable(rai).cursor();
        ShortBuffer sdata = buffer.asShortBuffer();
        int i = 0;
        while (cursor.hasNext()) {
            sdata.put(i++, ((UnsignedShortType)cursor.next()).getShort());
        }
    }

    private static VolumeTextureU8 uploadToTextureU8(GpuContext context, RandomAccessibleInterval<UnsignedByteType> rai) {
        VolumeTextureU8 texture = new VolumeTextureU8();
        texture.init(Intervals.dimensionsAsIntArray(rai));
        int numBytes = (int)Intervals.numElements(rai);
        ByteBuffer data = ByteBuffer.allocateDirect(numBytes);
        data.order(ByteOrder.nativeOrder());
        DefaultSimpleStackManager.copyToBufferU8(rai, data);
        texture.upload(context, data);
        return texture;
    }

    private static void copyToBufferU8(RandomAccessibleInterval<UnsignedByteType> rai, ByteBuffer buffer) {
        Cursor cursor = Views.flatIterable(rai).cursor();
        int i = 0;
        while (cursor.hasNext()) {
            buffer.put(i++, ((UnsignedByteType)cursor.next()).getByte());
        }
    }

    private static VolumeTextureRGBA8 uploadToTextureRGBA8(GpuContext context, RandomAccessibleInterval<ARGBType> rai) {
        VolumeTextureRGBA8 texture = new VolumeTextureRGBA8();
        texture.init(Intervals.dimensionsAsIntArray(rai));
        int numBytes = (int)(4L * Intervals.numElements(rai));
        ByteBuffer data = ByteBuffer.allocateDirect(numBytes);
        data.order(ByteOrder.nativeOrder());
        DefaultSimpleStackManager.copyToBufferRGBA8(rai, data);
        texture.upload(context, data);
        return texture;
    }

    private static void copyToBufferRGBA8(RandomAccessibleInterval<ARGBType> rai, ByteBuffer buffer) {
        Cursor cursor = Views.flatIterable(rai).cursor();
        IntBuffer sdata = buffer.asIntBuffer();
        int i = 0;
        while (cursor.hasNext()) {
            sdata.put(i++, DefaultSimpleStackManager.toRGBA(((ARGBType)cursor.next()).get()));
        }
    }

    private static int toRGBA(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return a << 24 | b << 16 | g << 8 | r;
    }
}

