/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.render;

import bvv.core.backend.GpuContext;
import bvv.core.backend.Texture;
import bvv.core.backend.Texture3D;
import bvv.core.blocks.ByteUtils;
import bvv.core.cache.TextureCache;
import java.nio.ByteBuffer;
import net.imglib2.util.IntervalIndexer;
import org.joml.Vector3f;

public class LookupTextureARGB
implements Texture3D {
    private final int[] size = new int[3];
    private final int[] offset = new int[3];
    private final int[] pad = new int[]{1, 1, 1};
    private int baseLevel;
    private ByteBuffer data;

    public void init(int[] rmin, int[] rmax, int baseLevel) {
        this.baseLevel = baseLevel;
        this.size[0] = rmax[0] - rmin[0] + 1 + 2 * this.pad[0];
        this.size[1] = rmax[1] - rmin[1] + 1 + 2 * this.pad[1];
        this.size[2] = rmax[2] - rmin[2] + 1 + 2 * this.pad[2];
        this.offset[0] = rmin[0] - this.pad[0];
        this.offset[1] = rmin[1] - this.pad[1];
        this.offset[2] = rmin[2] - this.pad[2];
        int numBytes = 4 * this.size[0] * this.size[1] * this.size[2];
        if (this.data == null || this.data.capacity() < numBytes) {
            this.data = ByteBuffer.allocateDirect(3 * numBytes / 2);
        }
        ByteUtils.setBytes((byte)0, ByteUtils.addressOf(this.data), numBytes);
    }

    public void putTile(int[] g0, TextureCache.Tile tile, int level) {
        int i = IntervalIndexer.positionWithOffsetToIndex((int[])g0, (int[])this.size, (int[])this.offset);
        this.data.put(i * 4, (byte)tile.x());
        this.data.put(i * 4 + 1, (byte)tile.y());
        this.data.put(i * 4 + 2, (byte)tile.z());
        this.data.put(i * 4 + 3, (byte)(level - this.baseLevel + 1));
    }

    public void upload(GpuContext context) {
        context.delete(this);
        context.texSubImage3D(this, 0, 0, 0, this.texWidth(), this.texHeight(), this.texDepth(), this.data);
    }

    public Vector3f getOffset3f() {
        return new Vector3f((float)this.offset[0], (float)this.offset[1], (float)this.offset[2]);
    }

    public Vector3f getSize3f() {
        return new Vector3f((float)this.size[0], (float)this.size[1], (float)this.size[2]);
    }

    @Override
    public Texture.InternalFormat texInternalFormat() {
        return Texture.InternalFormat.RGBA8UI;
    }

    @Override
    public int texWidth() {
        return this.size[0];
    }

    @Override
    public int texHeight() {
        return this.size[1];
    }

    @Override
    public int texDepth() {
        return this.size[2];
    }

    @Override
    public Texture.MinFilter texMinFilter() {
        return Texture.MinFilter.NEAREST;
    }

    @Override
    public Texture.MagFilter texMagFilter() {
        return Texture.MagFilter.NEAREST;
    }

    @Override
    public Texture.Wrap texWrap() {
        return Texture.Wrap.CLAMP_TO_EDGE;
    }
}

