/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.shadergen.generate;

import bvv.core.shadergen.generate.Segment;
import bvv.core.shadergen.generate.StringTemplateUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.stringtemplate.v4.ST;

public class SegmentTemplate {
    private final ST st;
    private final List<String> keys;
    private static final AtomicInteger idGen = new AtomicInteger();

    public SegmentTemplate(String resourceName, String ... keys) {
        this(SegmentTemplate.tryGetContext(), resourceName, Arrays.asList(keys));
    }

    public SegmentTemplate(String resourceName, List<String> keys) {
        this(SegmentTemplate.tryGetContext(), resourceName, keys);
    }

    public SegmentTemplate(Class<?> resourceContext, String resourceName, String ... keys) {
        this(resourceContext, resourceName, Arrays.asList(keys));
    }

    public SegmentTemplate(Class<?> resourceContext, String resourceName, List<String> keys) {
        try {
            this.st = StringTemplateUtils.loadAndPatchSnippet(resourceContext, resourceName, keys);
            this.keys = keys;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Segment instantiate() {
        return this.instantiate(this.proposeKeyToIdentifierMap());
    }

    private Segment instantiate(Map<String, Identifier> keyToIdentifier) {
        return new Segment(this, keyToIdentifier);
    }

    private Map<String, Identifier> proposeKeyToIdentifierMap() {
        HashMap<String, Identifier> keyToIdentifier = new HashMap<String, Identifier>();
        int baseId = idGen.getAndAdd(this.keys.size());
        for (String key : this.keys) {
            String instance = String.format("%s_x_%d_x_", key, baseId++);
            keyToIdentifier.put(key, new Identifier(instance));
        }
        return keyToIdentifier;
    }

    static Identifier proposeIdentifiers(String key, int num) {
        Identifier identifier = new Identifier();
        int baseId = idGen.getAndAdd(num);
        for (int i = 0; i < num; ++i) {
            String instance = String.format("%s_x_%d_x_", key, baseId++);
            identifier.put(i, instance);
        }
        return identifier;
    }

    String render(Map<String, Identifier> keyToIdentifier) {
        StringTemplateUtils.clearAttributes(this.st);
        this.keys.forEach(key -> this.st.add(key, ((Identifier)keyToIdentifier.get(key)).value()));
        return this.st.render();
    }

    private static Class<?> tryGetContext() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        try {
            Class<?> klass = SegmentTemplate.class.getClassLoader().loadClass(stackTrace[3].getClassName());
            return klass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static class Identifier {
        private final boolean isList;
        private ArrayList<String> values = new ArrayList();

        public Identifier(String identifier) {
            this.isList = false;
            this.values.add(identifier);
        }

        public Identifier() {
            this.isList = true;
        }

        public void put(int index, String identifier) {
            while (index >= this.values.size()) {
                this.values.add("");
            }
            this.values.set(index, identifier);
        }

        public Object value() {
            return this.isList ? this.values : this.values.get(0);
        }

        public boolean isList() {
            return this.isList;
        }
    }
}

