/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.shadergen.generate;

import bvv.core.backend.Texture;
import bvv.core.shadergen.AbstractShader;
import bvv.core.shadergen.Uniform1f;
import bvv.core.shadergen.Uniform1fv;
import bvv.core.shadergen.Uniform1i;
import bvv.core.shadergen.Uniform1iv;
import bvv.core.shadergen.Uniform2f;
import bvv.core.shadergen.Uniform2fv;
import bvv.core.shadergen.Uniform2i;
import bvv.core.shadergen.Uniform2iv;
import bvv.core.shadergen.Uniform3f;
import bvv.core.shadergen.Uniform3fv;
import bvv.core.shadergen.Uniform3i;
import bvv.core.shadergen.Uniform3iv;
import bvv.core.shadergen.Uniform4f;
import bvv.core.shadergen.Uniform4fv;
import bvv.core.shadergen.Uniform4i;
import bvv.core.shadergen.Uniform4iv;
import bvv.core.shadergen.UniformMatrix3f;
import bvv.core.shadergen.UniformMatrix4f;
import bvv.core.shadergen.UniformSampler;
import bvv.core.shadergen.generate.Segment;
import bvv.core.shadergen.generate.SegmentedShaderBuilder;
import java.util.Map;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.joml.Vector4i;
import org.joml.Vector4ic;

public class SegmentedShader
extends AbstractShader {
    private final Map<String, Object> uniforms;

    SegmentedShader(StringBuilder vpCode, StringBuilder fpCode, Map<String, Object> uniforms) {
        super(vpCode, fpCode);
        this.uniforms = uniforms;
    }

    @Override
    protected String getUniqueName(String key) {
        Object o = this.uniforms.get(key);
        if (o == SegmentedShaderBuilder.NOT_UNIQUE) {
            throw new IllegalArgumentException("uniform name '" + key + "' is not unique across segments.");
        }
        if (o == null) {
            return key;
        }
        return (String)o;
    }

    public Uniform1i getUniform1i(Segment segment, String key) {
        return this.getUniform1i(segment.getSingleIdentifier(key));
    }

    public Uniform2i getUniform2i(Segment segment, String key) {
        return this.getUniform2i(segment.getSingleIdentifier(key));
    }

    public Uniform3i getUniform3i(Segment segment, String key) {
        return this.getUniform3i(segment.getSingleIdentifier(key));
    }

    public Uniform4i getUniform4i(Segment segment, String key) {
        return this.getUniform4i(segment.getSingleIdentifier(key));
    }

    public Uniform1iv getUniform1iv(Segment segment, String key) {
        return this.getUniform1iv(segment.getSingleIdentifier(key));
    }

    public Uniform2iv getUniform2iv(Segment segment, String key) {
        return this.getUniform2iv(segment.getSingleIdentifier(key));
    }

    public Uniform3iv getUniform3iv(Segment segment, String key) {
        return this.getUniform3iv(segment.getSingleIdentifier(key));
    }

    public Uniform4iv getUniform4iv(Segment segment, String key) {
        return this.getUniform4iv(segment.getSingleIdentifier(key));
    }

    public Uniform1f getUniform1f(Segment segment, String key) {
        return this.getUniform1f(segment.getSingleIdentifier(key));
    }

    public Uniform2f getUniform2f(Segment segment, String key) {
        return this.getUniform2f(segment.getSingleIdentifier(key));
    }

    public Uniform3f getUniform3f(Segment segment, String key) {
        return this.getUniform3f(segment.getSingleIdentifier(key));
    }

    public Uniform4f getUniform4f(Segment segment, String key) {
        return this.getUniform4f(segment.getSingleIdentifier(key));
    }

    public Uniform1fv getUniform1fv(Segment segment, String key) {
        return this.getUniform1fv(segment.getSingleIdentifier(key));
    }

    public Uniform2fv getUniform2fv(Segment segment, String key) {
        return this.getUniform2fv(segment.getSingleIdentifier(key));
    }

    public Uniform3fv getUniform3fv(Segment segment, String key) {
        return this.getUniform3fv(segment.getSingleIdentifier(key));
    }

    public Uniform4fv getUniform4fv(Segment segment, String key) {
        return this.getUniform4fv(segment.getSingleIdentifier(key));
    }

    public UniformMatrix3f getUniformMatrix3f(Segment segment, String key) {
        return this.getUniformMatrix3f(segment.getSingleIdentifier(key));
    }

    public UniformMatrix4f getUniformMatrix4f(Segment segment, String key) {
        return this.getUniformMatrix4f(segment.getSingleIdentifier(key));
    }

    public UniformSampler getUniformSampler(Segment segment, String key) {
        return this.getUniformSampler(segment.getSingleIdentifier(key));
    }

    public void setUniformValueByType(Segment segment, String key, int elementSize, Object value) {
        if (value instanceof float[]) {
            float[] array = (float[])value;
            switch (elementSize) {
                case 1: {
                    this.getUniform1fv(segment, key).set(array);
                    break;
                }
                case 2: {
                    this.getUniform2fv(segment, key).set(array);
                    break;
                }
                case 3: {
                    this.getUniform3fv(segment, key).set(array);
                    break;
                }
                case 4: {
                    this.getUniform4fv(segment, key).set(array);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Uniform array element size not supported: " + elementSize);
                }
            }
        } else if (value instanceof int[]) {
            int[] array = (int[])value;
            switch (elementSize) {
                case 1: {
                    this.getUniform1iv(segment, key).set(array);
                    break;
                }
                case 2: {
                    this.getUniform2iv(segment, key).set(array);
                    break;
                }
                case 3: {
                    this.getUniform3iv(segment, key).set(array);
                    break;
                }
                case 4: {
                    this.getUniform4iv(segment, key).set(array);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Uniform array element size not supported: " + elementSize);
                }
            }
        } else {
            throw new IllegalArgumentException("Object type " + value.getClass().getCanonicalName() + " is not usable for uniforms.");
        }
    }

    public void setUniformValueByType(Segment segment, String key, Object value) {
        if (value instanceof Integer) {
            this.getUniform1i(segment, key).set((Integer)value);
        } else if (value instanceof Float) {
            this.getUniform1f(segment, key).set(((Float)value).floatValue());
        } else if (value instanceof Vector2f) {
            this.getUniform2f(segment, key).set((Vector2fc)((Vector2f)value));
        } else if (value instanceof Vector3f) {
            this.getUniform3f(segment, key).set((Vector3fc)((Vector3f)value));
        } else if (value instanceof Vector4f) {
            this.getUniform4f(segment, key).set((Vector4fc)((Vector4f)value));
        } else if (value instanceof Vector2i) {
            this.getUniform2i(segment, key).set((Vector2ic)((Vector2i)value));
        } else if (value instanceof Vector3i) {
            this.getUniform3i(segment, key).set((Vector3ic)((Vector3i)value));
        } else if (value instanceof Vector4i) {
            this.getUniform4i(segment, key).set((Vector4ic)((Vector4i)value));
        } else if (value instanceof Matrix3f) {
            this.getUniformMatrix3f(segment, key).set((Matrix3fc)((Matrix3f)value));
        } else if (value instanceof Matrix4f) {
            this.getUniformMatrix4f(segment, key).set((Matrix4fc)((Matrix4f)value));
        } else if (value instanceof Texture) {
            this.getUniformSampler(segment, key).set((Texture)value);
        } else {
            throw new IllegalArgumentException("Object type " + value.getClass().getCanonicalName() + " is not usable for uniforms.");
        }
    }
}

