/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.util;

import net.imglib2.algorithm.kdtree.HyperPlane;
import net.imglib2.realtransform.AffineTransform3D;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class MatrixMath {
    public static Vector4f homogPlane(HyperPlane plane) {
        assert (plane.numDimensions() == 3);
        float x = (float)plane.getNormal()[0];
        float y = (float)plane.getNormal()[1];
        float z = (float)plane.getNormal()[2];
        float w = (float)(-plane.getDistance());
        return new Vector4f(x, y, z, w);
    }

    public static HyperPlane hyperPlane(Vector4f plane) {
        return new HyperPlane(new double[]{plane.x(), plane.y(), plane.z(), -plane.w()});
    }

    public static Matrix4f screenPerspective(double dCam, double dClip, double screenWidth, double screenHeight, double screenPadding, Matrix4f matrix) {
        return MatrixMath.screenPerspective(dCam, dClip, dClip, screenWidth, screenHeight, screenPadding, matrix);
    }

    public static Matrix4f screenPerspective(double dCam, double dClipNear, double dClipFar, double screenWidth, double screenHeight, double screenPadding, Matrix4f matrix) {
        double r0 = (screenWidth + screenPadding) / 2.0;
        double t0 = (screenHeight + screenPadding) / 2.0;
        double p = (dCam - dClipNear) / dCam;
        float t = (float)(t0 * p);
        float r = (float)(r0 * p);
        float b = -t;
        float l = -r;
        float n = (float)(dCam - dClipNear);
        float f = (float)(dCam + dClipFar);
        matrix.setFrustum(l, r, b, t, n, f).scale(1.0f, -1.0f, -1.0f).translate((float)(-(screenWidth - 1.0) / 2.0), (float)(-(screenHeight - 1.0) / 2.0), (float)dCam);
        return matrix;
    }

    public static Matrix4f screen(double dCam, double screenWidth, double screenHeight, Matrix4f matrix) {
        return matrix.translation((float)(-(screenWidth - 1.0) / 2.0), (float)(-(screenHeight - 1.0) / 2.0), (float)dCam);
    }

    public static Matrix4f perspective(double dCam, double dClipNear, double dClipFar, double screenWidth, double screenHeight, double screenPadding, Matrix4f matrix) {
        double r0 = (screenWidth + screenPadding) / 2.0;
        double t0 = (screenHeight + screenPadding) / 2.0;
        double p = (dCam - dClipNear) / dCam;
        float t = (float)(t0 * p);
        float r = (float)(r0 * p);
        float b = -t;
        float l = -r;
        float n = (float)(dCam - dClipNear);
        float f = (float)(dCam + dClipFar);
        matrix.setFrustum(l, r, b, t, n, f).scale(1.0f, -1.0f, -1.0f);
        return matrix;
    }

    public static Matrix4f affine(AffineTransform3D affine, Matrix4f matrix) {
        float[] m = new float[16];
        for (int c = 0; c < 4; ++c) {
            for (int r = 0; r < 3; ++r) {
                m[c * 4 + r] = (float)affine.get(r, c);
            }
        }
        m[3] = 0.0f;
        m[7] = 0.0f;
        m[11] = 0.0f;
        m[15] = 1.0f;
        if ((matrix.properties() & 4) != 0) {
            matrix.set(m);
        } else if ((matrix.properties() & 2) != 0) {
            matrix.mulAffine((Matrix4fc)new Matrix4f().set(m));
        } else {
            matrix.mul((Matrix4fc)new Matrix4f().set(m));
        }
        return matrix;
    }

    private MatrixMath() {
    }
}

