/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.util;

import com.jogamp.opengl.GL3;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.imglib2.Interval;

class WireframeBox {
    private final float[] vertices = new float[24];
    private final int[] indices = new int[]{0, 1, 0, 2, 0, 4, 1, 3, 3, 2, 1, 5, 2, 6, 3, 7, 4, 5, 5, 7, 7, 6, 6, 4};
    private boolean initialized;
    private int vbo;
    private int vao;

    public void init(GL3 gl) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        int[] tmp = new int[2];
        gl.glGenVertexArrays(1, tmp, 0);
        this.vao = tmp[0];
        gl.glGenBuffers(2, tmp, 0);
        this.vbo = tmp[0];
        int ebo = tmp[1];
        gl.glBindBuffer(34963, ebo);
        gl.glBufferData(34963, (long)(this.indices.length * 4), (Buffer)IntBuffer.wrap(this.indices), 35044);
        gl.glBindBuffer(34963, 0);
        gl.glBindVertexArray(this.vao);
        gl.glBindBuffer(34962, this.vbo);
        gl.glVertexAttribPointer(0, 3, 5126, false, 12, 0L);
        gl.glEnableVertexAttribArray(0);
        gl.glBindBuffer(34963, ebo);
        gl.glBindVertexArray(0);
    }

    public void updateVertices(GL3 gl, Interval interval) {
        assert (interval.numDimensions() == 3);
        if (!this.initialized) {
            this.init(gl);
        }
        int numSourceDims = 3;
        int numCorners = 8;
        for (int i = 0; i < 8; ++i) {
            int d = 0;
            int b = 1;
            while (d < 3) {
                this.vertices[i * 3 + d] = (float)((i & b) == 0 ? interval.realMin(d) : interval.realMax(d));
                ++d;
                b <<= 1;
            }
        }
        gl.glBindBuffer(34962, this.vbo);
        gl.glBufferData(34962, (long)(this.vertices.length * 4), (Buffer)FloatBuffer.wrap(this.vertices), 35044);
        gl.glBindBuffer(34962, 0);
    }

    public void draw(GL3 gl) {
        if (!this.initialized) {
            return;
        }
        gl.glBindVertexArray(this.vao);
        gl.glDrawElements(1, 24, 5125, 0L);
        gl.glBindVertexArray(0);
    }
}

