/*
 * Decompiled with CFR 0.152.
 */
package bvv.vistools;

import bdv.util.AxisOrder;
import bvv.core.VolumeViewerOptions;
import bvv.vistools.Bvv;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ui.behaviour.io.InputTriggerConfig;

public class BvvOptions {
    public final Values values = new Values();

    public static BvvOptions options() {
        return new BvvOptions();
    }

    public BvvOptions preferredSize(int w, int h) {
        this.values.width = w;
        this.values.height = h;
        return this;
    }

    public BvvOptions renderWidth(int w) {
        this.values.renderWidth = w;
        return this;
    }

    public BvvOptions renderHeight(int h) {
        this.values.renderHeight = h;
        return this;
    }

    public BvvOptions maxRenderMillis(int t) {
        this.values.maxRenderMillis = t;
        return this;
    }

    public BvvOptions ditherWidth(int w) {
        this.values.ditherWidth = w;
        return this;
    }

    public BvvOptions numDitherSamples(int n) {
        this.values.numDitherSamples = n;
        return this;
    }

    public BvvOptions cacheBlockSize(int[] s) {
        assert (s.length == 3);
        ((Values)this.values).cacheBlockSize[0] = s[0];
        ((Values)this.values).cacheBlockSize[1] = s[1];
        ((Values)this.values).cacheBlockSize[2] = s[2];
        return this;
    }

    public BvvOptions cacheBlockSize(int s) {
        ((Values)this.values).cacheBlockSize[0] = s;
        ((Values)this.values).cacheBlockSize[1] = s;
        ((Values)this.values).cacheBlockSize[2] = s;
        return this;
    }

    public BvvOptions maxCacheSizeInMB(int s) {
        this.values.maxCacheSizeInMB = s;
        return this;
    }

    public BvvOptions dCam(double d) {
        this.values.dCam = d;
        return this;
    }

    public BvvOptions dClipNear(double d) {
        this.values.dClipNear = d;
        return this;
    }

    public BvvOptions dClipFar(double d) {
        this.values.dClipFar = d;
        return this;
    }

    public BvvOptions dClip(double d) {
        this.values.dClipNear = d;
        this.values.dClipFar = d;
        return this;
    }

    public BvvOptions maxAllowedStepInVoxels(double s) {
        this.values.maxAllowedStepInVoxels = s;
        return this;
    }

    public BvvOptions numSourceGroups(int n) {
        this.values.numSourceGroups = n;
        return this;
    }

    public BvvOptions inputTriggerConfig(InputTriggerConfig c) {
        this.values.inputTriggerConfig = c;
        return this;
    }

    public BvvOptions sourceTransform(AffineTransform3D t) {
        this.values.sourceTransform.set(t);
        return this;
    }

    public BvvOptions frameTitle(String title) {
        this.values.frameTitle = title;
        return this;
    }

    public BvvOptions sourceTransform(double ... calibration) {
        double sx = calibration.length >= 1 ? calibration[0] : 1.0;
        double sy = calibration.length >= 2 ? calibration[1] : 1.0;
        double sz = calibration.length >= 3 ? calibration[2] : 1.0;
        this.values.sourceTransform.set(sx, 0.0, 0.0, 0.0, 0.0, sy, 0.0, 0.0, 0.0, 0.0, sz, 0.0);
        return this;
    }

    public BvvOptions axisOrder(AxisOrder axisOrder) {
        this.values.axisOrder = axisOrder;
        return this;
    }

    public BvvOptions addTo(Bvv bvv) {
        this.values.addTo = bvv;
        return this;
    }

    public static class Values {
        private int width = -1;
        private int height = -1;
        private String frameTitle = "BigVolumeViewer";
        private int maxRenderMillis = 30;
        private int renderWidth = 512;
        private int renderHeight = 512;
        private int ditherWidth = 3;
        private int numDitherSamples = 8;
        private final int[] cacheBlockSize = new int[]{32, 32, 32};
        private int maxCacheSizeInMB = 300;
        private double dCam = 2000.0;
        private double dClipNear = 1000.0;
        private double dClipFar = 1000.0;
        private double maxAllowedStepInVoxels = 1.0;
        private int numSourceGroups = 10;
        private InputTriggerConfig inputTriggerConfig = null;
        private final AffineTransform3D sourceTransform = new AffineTransform3D();
        private AxisOrder axisOrder = AxisOrder.DEFAULT;
        private Bvv addTo = null;

        Values() {
            this.sourceTransform.identity();
        }

        public BvvOptions optionsFromValues() {
            BvvOptions o = new BvvOptions().preferredSize(this.width, this.height).renderWidth(this.renderWidth).renderHeight(this.renderHeight).maxRenderMillis(this.maxRenderMillis).ditherWidth(this.ditherWidth).numDitherSamples(this.numDitherSamples).maxCacheSizeInMB(this.maxCacheSizeInMB).dCam(this.dCam).dClipFar(this.dClipFar).dClipNear(this.dClipNear).maxAllowedStepInVoxels(this.maxAllowedStepInVoxels).numSourceGroups(this.numSourceGroups).inputTriggerConfig(this.inputTriggerConfig).sourceTransform(this.sourceTransform).frameTitle(this.frameTitle).axisOrder(this.axisOrder).addTo(this.addTo);
            return o;
        }

        public VolumeViewerOptions getVolumeViewerOptions() {
            VolumeViewerOptions o = VolumeViewerOptions.options().renderWidth(this.renderWidth).renderHeight(this.renderHeight).maxRenderMillis(this.maxRenderMillis).ditherWidth(this.ditherWidth).numDitherSamples(this.numDitherSamples).maxCacheSizeInMB(this.maxCacheSizeInMB).dCam(this.dCam).dClipFar(this.dClipFar).dClipNear(this.dClipNear).maxAllowedStepInVoxels(this.maxAllowedStepInVoxels).numSourceGroups(this.numSourceGroups).inputTriggerConfig(this.inputTriggerConfig);
            if (this.hasPreferredSize()) {
                o.width(this.width).height(this.height);
            }
            return o;
        }

        public AffineTransform3D getSourceTransform() {
            return this.sourceTransform;
        }

        public String getFrameTitle() {
            return this.frameTitle;
        }

        public boolean hasPreferredSize() {
            return this.width > 0 && this.height > 0;
        }

        public AxisOrder axisOrder() {
            return this.axisOrder;
        }

        public InputTriggerConfig getInputTriggerConfig() {
            return this.inputTriggerConfig;
        }

        public Bvv addTo() {
            return this.addTo;
        }
    }
}

