/*
 * Decompiled with CFR 0.152.
 */
package bvv.vistools;

import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.MinMaxGroup;
import bdv.tools.brightness.SetupAssignments;
import bdv.util.Bounds;
import bdv.viewer.ConverterSetupBounds;
import bdv.viewer.SourceAndConverter;
import bvv.core.multires.SourceStacks;
import bvv.vistools.BvvHandle;
import bvv.vistools.BvvSource;
import java.util.HashSet;
import java.util.List;
import net.imglib2.type.numeric.ARGBType;

public class BvvStackSource<T>
extends BvvSource {
    private final T type;
    private final List<ConverterSetup> converterSetups;
    private final List<SourceAndConverter<T>> sources;

    protected BvvStackSource(BvvHandle bvv, int numTimepoints, T type, List<ConverterSetup> converterSetups, List<SourceAndConverter<T>> sources) {
        super(bvv, numTimepoints);
        this.type = type;
        this.converterSetups = converterSetups;
        this.sources = sources;
    }

    @Override
    public void removeFromBdv() {
        this.getBvvHandle().remove(this.converterSetups, this.sources, null, null, null);
        this.getBvvHandle().removeBvvSource(this);
        this.setBdvHandle(null);
    }

    @Override
    protected boolean isPlaceHolderSource() {
        return false;
    }

    @Override
    public void setColor(ARGBType color) {
        for (ConverterSetup setup : this.converterSetups) {
            setup.setColor(color);
        }
    }

    @Override
    public void setDisplayRange(double min, double max) {
        for (ConverterSetup setup : this.converterSetups) {
            setup.setDisplayRange(min, max);
        }
    }

    @Override
    public void setDisplayRangeBounds(double min, double max) {
        ConverterSetupBounds bounds = this.getBvvHandle().getConverterSetups().getBounds();
        for (ConverterSetup setup : this.converterSetups) {
            bounds.setBounds(setup, new Bounds(min, max));
        }
        HashSet<MinMaxGroup> groups = new HashSet<MinMaxGroup>();
        SetupAssignments sa = this.getBvvHandle().getSetupAssignments();
        for (ConverterSetup setup : this.converterSetups) {
            groups.add(sa.getMinMaxGroup(setup));
        }
        for (MinMaxGroup group : groups) {
            group.setRange(min, max);
        }
    }

    @Override
    public void setCurrent() {
        this.getBvvHandle().getViewerPanel().getVisibilityAndGrouping().setCurrentSource(this.sources.get(0).getSpimSource());
    }

    @Override
    public boolean isCurrent() {
        return this.sources.contains(this.getBvvHandle().getViewerPanel().state().getCurrentSource());
    }

    @Override
    public void setActive(boolean isActive) {
        this.getBvvHandle().getViewerPanel().state().setSourcesActive(this.sources, isActive);
    }

    public List<ConverterSetup> getConverterSetups() {
        return this.converterSetups;
    }

    public List<SourceAndConverter<T>> getSources() {
        return this.sources;
    }

    public void invalidate() {
        for (SourceAndConverter<T> source : this.sources) {
            SourceStacks.invalidate(source.getSpimSource());
        }
        BvvHandle bvv = this.getBvvHandle();
        if (bvv != null) {
            bvv.getViewerPanel().requestRepaint();
        }
    }
}

