/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.groovy;

import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Field;
import java.security.CodeSource;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.jsr223.GroovyCompiledScript;
import org.codehaus.groovy.jsr223.GroovyScriptEngineFactory;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.scijava.plugin.Plugin;
import org.scijava.plugins.scripting.groovy.ImportRetainer;
import org.scijava.script.AdaptedScriptLanguage;
import org.scijava.script.ScriptLanguage;
import org.scijava.util.ClassUtils;
import org.scijava.util.Types;

@Plugin(type=ScriptLanguage.class, name="Groovy", priority=100.0)
public class GroovyScriptLanguage
extends AdaptedScriptLanguage {
    private static final ThreadLocal<CompileUnit> asts = new ThreadLocal();

    public GroovyScriptLanguage() {
        super((ScriptEngineFactory)new GroovyScriptEngineFactory());
    }

    public ScriptEngine getScriptEngine() {
        CompilerConfiguration compilerConfig = new CompilerConfiguration();
        final ImportRetainer importRetainer = new ImportRetainer();
        compilerConfig.addCompilationCustomizers(new CompilationCustomizer[]{importRetainer});
        GroovyScriptEngineImpl engine = new GroovyScriptEngineImpl(){

            private void saveImports() {
                CompileUnit ast = (CompileUnit)asts.get();
                if (ast == null) {
                    return;
                }
                asts.remove();
                for (ModuleNode m : ast.getModules()) {
                    m.getImports().forEach(ipt -> importRetainer.retainImport((ImportNode)ipt));
                    m.getStarImports().forEach(ipt -> importRetainer.retainStarImport((ImportNode)ipt));
                    m.getStaticImports().values().forEach(ipt -> importRetainer.retainStaticImport((ImportNode)ipt));
                    m.getStaticStarImports().values().forEach(ipt -> importRetainer.retainStaticStarImport((ImportNode)ipt));
                }
            }

            public Object eval(String script, ScriptContext scriptContext) throws ScriptException {
                Object result = super.eval(script, scriptContext);
                this.saveImports();
                return result;
            }

            public CompiledScript compile(String scriptSource) throws ScriptException {
                GroovyCompiledScript cs = (GroovyCompiledScript)super.compile(scriptSource);
                Class clasz = (Class)ClassUtils.getValue((Field)Types.field(GroovyCompiledScript.class, (String)"clasz"), (Object)cs);
                return new GroovyCompiledScript(this, clasz){

                    public Object eval(ScriptContext scriptContext) throws ScriptException {
                        Object result = super.eval(scriptContext);
                        this.saveImports();
                        return result;
                    }
                };
            }
        };
        GroovyClassLoader classLoader = new GroovyClassLoader((ClassLoader)engine.getClassLoader(), compilerConfig, false){

            protected CompilationUnit createCompilationUnit(CompilerConfiguration config, CodeSource source) {
                CompilationUnit unit = super.createCompilationUnit(config, source);
                CompileUnit ast = unit.getAST();
                asts.set(ast);
                return unit;
            }
        };
        engine.setClassLoader(classLoader);
        return engine;
    }
}

