/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply.util;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.smurn.jply.Element;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ElementType;
import org.smurn.jply.Property;

class TriangulatingFaceReader
implements ElementReader {
    private final ElementReader reader;
    private final List<Element> elementQueue = new LinkedList<Element>();
    private boolean closed = false;

    TriangulatingFaceReader(ElementReader reader) {
        if (reader == null) {
            throw new NullPointerException("reader must not be null.");
        }
        if (!"face".equals(reader.getElementType().getName())) {
            throw new IllegalArgumentException("This class can only be used on face readers.");
        }
        boolean found = false;
        for (Property p : reader.getElementType().getProperties()) {
            if (!"vertex_index".equals(p.getName())) continue;
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Face element as no vertex_index property.");
        }
        this.reader = reader;
    }

    @Override
    public ElementType getElementType() {
        return this.reader.getElementType();
    }

    @Override
    public int getCount() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Element readElement() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Reader is closed.");
        }
        if (this.elementQueue.isEmpty()) {
            Element element = this.reader.readElement();
            if (element == null) {
                return null;
            }
            int[] indices = element.getIntList("vertex_index");
            if (indices.length == 3) {
                return element;
            }
            if (indices.length < 3) {
                throw new IOException("face with less than three vertices.");
            }
            int i = 0;
            while (i < indices.length - 2) {
                Element triangle = element.clone();
                triangle.setIntList("vertex_index", new int[]{indices[0], indices[i + 1], indices[i + 2]});
                this.elementQueue.add(triangle);
                ++i;
            }
        }
        return this.elementQueue.remove(0);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

