/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Vector;
import org.jogamp.java3d.BranchGroupRetained;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.CompressedGeometry;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.Morph;
import org.jogamp.java3d.MorphRetained;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Shape3DCompileRetained;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.SharedGroupRetained;
import org.jogamp.java3d.Text3DRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point4d;

public class PickInfo {
    static final int PICK_ALL = 1;
    static final int PICK_ANY = 2;
    private SceneGraphPath sgp;
    private Node node;
    private Transform3D l2vw;
    private Point3d closestIntersectionPoint;
    private double closestDistance;
    private IntersectionInfo[] intersectionInfoArr;
    private ArrayList<IntersectionInfo> intersectionInfoList = new ArrayList();
    private boolean intersectionInfoListSorted = false;
    private Transform3D l2vwRef;
    private Node nodeRef;
    public static final int PICK_BOUNDS = 1;
    public static final int PICK_GEOMETRY = 2;
    public static final int SCENEGRAPHPATH = 1;
    public static final int NODE = 2;
    public static final int LOCAL_TO_VWORLD = 4;
    public static final int CLOSEST_INTERSECTION_POINT = 8;
    public static final int CLOSEST_DISTANCE = 16;
    public static final int CLOSEST_GEOM_INFO = 32;
    public static final int ALL_GEOM_INFO = 64;

    PickInfo() {
    }

    void setSceneGraphPath(SceneGraphPath sgp) {
        this.sgp = sgp;
    }

    void setNode(Node node) {
        this.node = node;
    }

    void setLocalToVWorld(Transform3D l2vw) {
        this.l2vw = l2vw;
    }

    void setClosestIntersectionPoint(Point3d cIPt) {
        this.closestIntersectionPoint = cIPt;
    }

    void setClosestDistance(double cDist) {
        this.closestDistance = cDist;
    }

    void setLocalToVWorldRef(Transform3D l2vwRef) {
        this.l2vwRef = l2vwRef;
    }

    void setNodeRef(Node nodeRef) {
        this.nodeRef = nodeRef;
    }

    IntersectionInfo createIntersectionInfo() {
        return new IntersectionInfo();
    }

    void insertIntersectionInfo(IntersectionInfo iInfo) {
        this.intersectionInfoList.add(iInfo);
        this.intersectionInfoListSorted = false;
    }

    void sortIntersectionInfoArray(IntersectionInfo[] iInfoArr) {
        class Sort {
            IntersectionInfo[] iInfoArr;

            Sort(IntersectionInfo[] iInfoArr) {
                this.iInfoArr = iInfoArr;
            }

            void sorting() {
                if (this.iInfoArr.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.iInfoArr.length - 1);
                }
            }

            final void insertSort() {
                for (int i = 0; i < this.iInfoArr.length; ++i) {
                    for (int j = i; j > 0 && this.iInfoArr[j - 1].distance > this.iInfoArr[j].distance; --j) {
                        IntersectionInfo iInfo = this.iInfoArr[j];
                        this.iInfoArr[j] = this.iInfoArr[j - 1];
                        this.iInfoArr[j - 1] = iInfo;
                    }
                }
            }

            final void quicksort(int l, int r) {
                int i = l;
                int j = r;
                double k = this.iInfoArr[(l + r) / 2].distance;
                while (true) {
                    if (this.iInfoArr[i].distance < k) {
                        ++i;
                        continue;
                    }
                    while (k < this.iInfoArr[j].distance) {
                        --j;
                    }
                    if (i <= j) {
                        IntersectionInfo iInfo = this.iInfoArr[i];
                        this.iInfoArr[i] = this.iInfoArr[j];
                        this.iInfoArr[j] = iInfo;
                        ++i;
                        --j;
                    }
                    if (i > j) break;
                }
                if (l < j) {
                    this.quicksort(l, j);
                }
                if (l < r) {
                    this.quicksort(i, r);
                }
            }
        }
        new Sort(iInfoArr).sorting();
        this.intersectionInfoListSorted = true;
    }

    static void sortPickInfoArray(PickInfo[] pickInfoArr) {
        class Sort {
            PickInfo[] pIArr;

            Sort(PickInfo[] pIArr) {
                this.pIArr = pIArr;
            }

            void sorting() {
                if (this.pIArr.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.pIArr.length - 1);
                }
            }

            final void insertSort() {
                for (int i = 0; i < this.pIArr.length; ++i) {
                    for (int j = i; j > 0 && this.pIArr[j - 1].closestDistance > this.pIArr[j].closestDistance; --j) {
                        PickInfo pI = this.pIArr[j];
                        this.pIArr[j] = this.pIArr[j - 1];
                        this.pIArr[j - 1] = pI;
                    }
                }
            }

            final void quicksort(int l, int r) {
                int i = l;
                int j = r;
                double k = this.pIArr[(l + r) / 2].closestDistance;
                while (true) {
                    if (this.pIArr[i].closestDistance < k) {
                        ++i;
                        continue;
                    }
                    while (k < this.pIArr[j].closestDistance) {
                        --j;
                    }
                    if (i <= j) {
                        PickInfo pI = this.pIArr[i];
                        this.pIArr[i] = this.pIArr[j];
                        this.pIArr[j] = pI;
                        ++i;
                        --j;
                    }
                    if (i > j) break;
                }
                if (l < j) {
                    this.quicksort(l, j);
                }
                if (l < r) {
                    this.quicksort(i, r);
                }
            }
        }
        new Sort(pickInfoArr).sorting();
    }

    public SceneGraphPath getSceneGraphPath() {
        return this.sgp;
    }

    public Node getNode() {
        return this.node;
    }

    public Transform3D getLocalToVWorld() {
        return this.l2vw;
    }

    public Point3d getClosestIntersectionPoint() {
        return this.closestIntersectionPoint;
    }

    public double getClosestDistance() {
        return this.closestDistance;
    }

    Transform3D getLocalToVWorldRef() {
        return this.l2vwRef;
    }

    Node getNodeRef() {
        return this.nodeRef;
    }

    public IntersectionInfo[] getIntersectionInfos() {
        if (!this.intersectionInfoListSorted) {
            this.intersectionInfoArr = new IntersectionInfo[this.intersectionInfoList.size()];
            this.intersectionInfoArr = this.intersectionInfoList.toArray(this.intersectionInfoArr);
            this.sortIntersectionInfoArray(this.intersectionInfoArr);
        }
        return this.intersectionInfoArr;
    }

    static ArrayList<NodeRetained> initSceneGraphPath(NodeRetained nodeR) {
        ArrayList<NodeRetained> path = new ArrayList<NodeRetained>(5);
        do {
            if (!nodeR.source.getCapability(1)) continue;
            path.add(nodeR);
        } while ((nodeR = nodeR.parent) != null);
        return path;
    }

    private static Node[] createPath(NodeRetained srcNode, BranchGroupRetained bgRetained, GeometryAtom geomAtom, ArrayList<NodeRetained> initpath) {
        ArrayList<NodeRetained> path = PickInfo.retrievePath(srcNode, bgRetained, geomAtom.source.key);
        assert (path != null);
        return PickInfo.mergePath(path, initpath);
    }

    private static boolean inside(BranchGroupRetained[] bgArr, BranchGroupRetained bg) {
        if (bg == null || bgArr == null) {
            return true;
        }
        for (int i = 0; i < bgArr.length; ++i) {
            if (bgArr[i] != bg) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<NodeRetained> retrievePath(NodeRetained startNode, NodeRetained endNode, HashKey key) {
        ArrayList<NodeRetained> path = new ArrayList<NodeRetained>(5);
        NodeRetained nodeR = startNode;
        if (nodeR.inSharedGroup) {
            key = new HashKey(key);
        }
        do {
            if (nodeR == endNode) {
                return path;
            }
            if (nodeR.source.getCapability(1)) {
                path.add(nodeR);
            }
            if (!(nodeR instanceof SharedGroupRetained)) continue;
            String nodeId = key.getLastNodeId();
            Vector<NodeRetained> parents = ((SharedGroupRetained)nodeR).parents;
            int sz = parents.size();
            NodeRetained prevNodeR = nodeR;
            for (int i = 0; i < sz; ++i) {
                NodeRetained linkR = parents.get(i);
                if (!linkR.nodeId.equals(nodeId)) continue;
                nodeR = linkR;
                path.add(nodeR);
                break;
            }
            if (nodeR != prevNodeR) continue;
            return null;
        } while ((nodeR = nodeR.parent) != null);
        if (endNode == null) {
            return path;
        }
        return null;
    }

    private static Node[] mergePath(ArrayList<NodeRetained> p1, ArrayList<NodeRetained> p2) {
        int i;
        int s = p1.size();
        int len = p2 == null ? s : s + p2.size();
        Node[] nodes = new Node[len];
        int l = len - 1;
        for (i = 0; i < s; ++i) {
            nodes[l - i] = (Node)p1.get((int)i).source;
        }
        int j = 0;
        while (i < len) {
            nodes[l - i] = (Node)p2.get((int)j).source;
            ++i;
            ++j;
        }
        return nodes;
    }

    static void sortGeomAtoms(GeometryAtom[] geomAtoms, PickShape shape) {
        double[] distance = new double[geomAtoms.length];
        Point4d pickPos = new Point4d();
        for (int i = 0; i < geomAtoms.length; ++i) {
            shape.intersect(geomAtoms[i].source.vwcBounds, pickPos);
            distance[i] = pickPos.w;
        }
        class Sort {
            GeometryAtom[] atoms;
            final /* synthetic */ double[] val$distance;

            Sort(GeometryAtom[] geometryAtomArray) {
                this.val$distance = (double[])geometryAtomArray;
                this.atoms = atoms;
            }

            void sorting() {
                if (this.atoms.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.atoms.length - 1);
                }
            }

            final void insertSort() {
                for (int i = 0; i < this.atoms.length; ++i) {
                    for (int j = i; j > 0 && this.val$distance[j - 1] > this.val$distance[j]; --j) {
                        double t = this.val$distance[j];
                        this.val$distance[j] = this.val$distance[j - 1];
                        this.val$distance[j - 1] = t;
                        GeometryAtom p = this.atoms[j];
                        this.atoms[j] = this.atoms[j - 1];
                        this.atoms[j - 1] = p;
                    }
                }
            }

            final void quicksort(int l, int r) {
                int i = l;
                int j = r;
                double k = this.val$distance[(l + r) / 2];
                while (true) {
                    if (this.val$distance[i] < k) {
                        ++i;
                        continue;
                    }
                    while (k < this.val$distance[j]) {
                        --j;
                    }
                    if (i <= j) {
                        double tmp = this.val$distance[i];
                        this.val$distance[i] = this.val$distance[j];
                        this.val$distance[j] = tmp;
                        GeometryAtom p = this.atoms[i];
                        this.atoms[i] = this.atoms[j];
                        this.atoms[j] = p;
                        ++i;
                        --j;
                    }
                    if (i > j) break;
                }
                if (l < j) {
                    this.quicksort(l, j);
                }
                if (l < r) {
                    this.quicksort(i, r);
                }
            }
        }
        new Sort(geomAtoms, distance).sorting();
    }

    static ArrayList<PickInfo> getPickInfos(ArrayList<NodeRetained> initpath, BranchGroupRetained bgRetained, GeometryAtom[] geomAtoms, Locale locale, int flags, int pickType) {
        ArrayList<PickInfo> pickInfoList = new ArrayList<PickInfo>(5);
        ArrayList<NodeRetained> text3dList = null;
        if (geomAtoms == null || geomAtoms.length == 0) {
            return null;
        }
        for (int i = 0; i < geomAtoms.length; ++i) {
            Transform3D l2vw;
            assert (geomAtoms[i] != null && geomAtoms[i].source != null);
            PickInfo pickInfo = null;
            Shape3DRetained shape = geomAtoms[i].source;
            NodeRetained srcNode = shape.sourceNode;
            if (!PickInfo.inside(shape.branchGroupPath, bgRetained) || srcNode == null) continue;
            if (srcNode instanceof Shape3DRetained) {
                Shape3DRetained s3dR = (Shape3DRetained)srcNode;
                GeometryRetained geomR = null;
                for (int cnt = 0; cnt < s3dR.geometryList.size() && (geomR = s3dR.geometryList.get(cnt)) == null; ++cnt) {
                }
                if (geomR == null) continue;
                if (geomR instanceof Text3DRetained) {
                    if (text3dList == null) {
                        text3dList = new ArrayList<NodeRetained>(3);
                    } else {
                        int size = text3dList.size();
                        boolean found = false;
                        for (int j = 0; j < size; ++j) {
                            if (text3dList.get(j) != srcNode) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                    }
                    text3dList.add(srcNode);
                }
            }
            if (srcNode instanceof Shape3DCompileRetained) {
                Shape3DCompileRetained s3dCR = (Shape3DCompileRetained)srcNode;
                Node[] mpath = null;
                boolean first = true;
                for (int n = 0; n < s3dCR.srcList.length; ++n) {
                    pickInfo = null;
                    if ((flags & 1) != 0) {
                        if (first) {
                            mpath = PickInfo.createPath(srcNode, bgRetained, geomAtoms[i], initpath);
                            first = false;
                        }
                        if (mpath != null) {
                            SceneGraphPath sgpath = new SceneGraphPath(locale, mpath, (Node)s3dCR.srcList[n]);
                            sgpath.setTransform(shape.getCurrentLocalToVworld(0));
                            if (pickInfo == null) {
                                pickInfo = new PickInfo();
                            }
                            pickInfo.setSceneGraphPath(sgpath);
                        }
                    }
                    if ((flags & 2) != 0) {
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setNode((Node)s3dCR.srcList[n]);
                    }
                    if ((flags & 4) != 0) {
                        Transform3D l2vw2 = geomAtoms[i].source.getCurrentLocalToVworld();
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setLocalToVWorld(new Transform3D(l2vw2));
                    }
                    if ((flags & 0x10) != 0 || (flags & 0x20) != 0 || (flags & 8) != 0 || (flags & 0x40) != 0) {
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setNodeRef((Node)s3dCR.srcList[n]);
                        Transform3D l2vw3 = geomAtoms[i].source.getCurrentLocalToVworld();
                        pickInfo.setLocalToVWorldRef(l2vw3);
                    }
                    if (pickInfo != null) {
                        pickInfoList.add(pickInfo);
                    }
                    if (pickType != 2) continue;
                    return pickInfoList;
                }
                continue;
            }
            Node[] mpath = null;
            if ((flags & 1) != 0 && (mpath = PickInfo.createPath(srcNode, bgRetained, geomAtoms[i], initpath)) != null) {
                SceneGraphPath sgpath = new SceneGraphPath(locale, mpath, (Node)srcNode.source);
                sgpath.setTransform(shape.getCurrentLocalToVworld(0));
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setSceneGraphPath(sgpath);
            }
            if ((flags & 2) != 0) {
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setNode((Node)srcNode.source);
            }
            if ((flags & 4) != 0) {
                l2vw = geomAtoms[i].source.getCurrentLocalToVworld();
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setLocalToVWorld(new Transform3D(l2vw));
            }
            if ((flags & 0x10) != 0 || (flags & 0x20) != 0 || (flags & 8) != 0 || (flags & 0x40) != 0) {
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setNodeRef((Node)srcNode.source);
                l2vw = geomAtoms[i].source.getCurrentLocalToVworld();
                pickInfo.setLocalToVWorldRef(l2vw);
            }
            if (pickInfo != null) {
                pickInfoList.add(pickInfo);
            }
            if (pickType != 2) continue;
            return pickInfoList;
        }
        return pickInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PickInfo[] pick(Object node, GeometryAtom[] geomAtoms, int mode, int flags, PickShape pickShape, int pickType) {
        int pickInfoListSize;
        PickInfo[] pickInfoArr = null;
        Locale locale = null;
        BranchGroupRetained bgRetained = null;
        ArrayList<PickInfo> pickInfoList = null;
        if (node instanceof Locale) {
            locale = (Locale)node;
        } else if (node instanceof BranchGroupRetained) {
            bgRetained = (BranchGroupRetained)node;
            locale = bgRetained.locale;
        }
        Object object = locale.universe.sceneGraphLock;
        synchronized (object) {
            ArrayList<NodeRetained> initPath = null;
            if (bgRetained != null) {
                initPath = PickInfo.initSceneGraphPath(bgRetained);
            }
            pickInfoList = PickInfo.getPickInfos(initPath, bgRetained, geomAtoms, locale, flags, pickType);
        }
        if (mode == 2 && pickInfoList != null && (pickInfoListSize = pickInfoList.size()) > 0) {
            Node pickNode = null;
            for (int i = pickInfoListSize - 1; i >= 0; --i) {
                PickInfo pickInfo = pickInfoList.get(i);
                pickNode = pickInfo.getNode();
                if (pickNode == null) {
                    pickNode = pickInfo.getNodeRef();
                }
                if (pickNode instanceof Shape3D) {
                    if (!pickNode.getCapability(12)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo0"));
                    }
                    for (int j = 0; j < ((Shape3D)pickNode).numGeometries(); ++j) {
                        Geometry geo = ((Shape3D)pickNode).getGeometry(j);
                        if (geo == null) continue;
                        if (!geo.getCapability(18)) {
                            throw new CapabilityNotSetException(J3dI18N.getString("PickInfo1"));
                        }
                        if (geo instanceof GeometryArray) {
                            if (!geo.getCapability(0)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo2"));
                            }
                            if (!geo.getCapability(8)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo3"));
                            }
                            if (!geo.getCapability(17)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo4"));
                            }
                            if (!(geo instanceof IndexedGeometryArray) || geo.getCapability(9)) continue;
                            throw new CapabilityNotSetException(J3dI18N.getString("PickInfo5"));
                        }
                        if (!(geo instanceof CompressedGeometry) || geo.getCapability(2)) continue;
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo0"));
                    }
                    if (!((Shape3DRetained)pickNode.retained).intersect(pickInfo, pickShape, flags)) {
                        pickInfoList.remove(i);
                        continue;
                    }
                    if (pickType != 2) continue;
                    pickInfoArr = new PickInfo[]{pickInfo};
                    return pickInfoArr;
                }
                if (!(pickNode instanceof Morph)) continue;
                if (!pickNode.getCapability(12)) {
                    throw new CapabilityNotSetException(J3dI18N.getString("PickInfo6"));
                }
                int numGeo = ((MorphRetained)pickNode.retained).getNumGeometryArrays();
                for (int j = 0; j < numGeo; ++j) {
                    GeometryArray geo = ((Morph)pickNode).getGeometryArray(j);
                    if (geo == null) continue;
                    if (!geo.getCapability(18)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo1"));
                    }
                    if (!geo.getCapability(0)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo2"));
                    }
                    if (!geo.getCapability(8)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo3"));
                    }
                    if (!geo.getCapability(17)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo4"));
                    }
                    if (!(geo instanceof IndexedGeometryArray) || geo.getCapability(9)) continue;
                    throw new CapabilityNotSetException(J3dI18N.getString("PickInfo5"));
                }
                if (!((MorphRetained)pickNode.retained).intersect(pickInfo, pickShape, flags)) {
                    pickInfoList.remove(i);
                    continue;
                }
                if (pickType != 2) continue;
                pickInfoArr = new PickInfo[]{pickInfo};
                return pickInfoArr;
            }
        }
        if (pickInfoList != null && pickInfoList.size() > 0) {
            pickInfoArr = new PickInfo[pickInfoList.size()];
            return pickInfoList.toArray(pickInfoArr);
        }
        return null;
    }

    public class IntersectionInfo {
        private int geomIndex;
        private Geometry geom;
        private Point3d intersectionPoint;
        private double distance;
        private int[] vertexIndices;

        IntersectionInfo() {
        }

        void setGeometryIndex(int geomIndex) {
            this.geomIndex = geomIndex;
        }

        void setGeometry(Geometry geom) {
            this.geom = geom;
        }

        void setIntersectionPoint(Point3d intersectionPoint) {
            assert (intersectionPoint != null);
            this.intersectionPoint = new Point3d(intersectionPoint);
        }

        void setDistance(double distance) {
            this.distance = distance;
        }

        void setVertexIndices(int[] vertexIndices) {
            assert (vertexIndices != null);
            this.vertexIndices = new int[vertexIndices.length];
            for (int i = 0; i < vertexIndices.length; ++i) {
                this.vertexIndices[i] = vertexIndices[i];
            }
        }

        public int getGeometryIndex() {
            return this.geomIndex;
        }

        public Geometry getGeometry() {
            return this.geom;
        }

        public Point3d getIntersectionPoint() {
            return this.intersectionPoint;
        }

        public double getDistance() {
            return this.distance;
        }

        public int[] getVertexIndices() {
            return this.vertexIndices;
        }
    }
}

