/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransformInterpolator;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnElapsedFrames;

public class ScaleInterpolator
extends TransformInterpolator {
    float minimumScale;
    float maximumScale;
    private Transform3D scale = new Transform3D();
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    ScaleInterpolator() {
    }

    public ScaleInterpolator(Alpha alpha, TransformGroup target) {
        super(alpha, target);
        this.minimumScale = 0.1f;
        this.maximumScale = 1.0f;
    }

    public ScaleInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, float minimumScale, float maximumScale) {
        super(alpha, target, axisOfTransform);
        this.minimumScale = minimumScale;
        this.maximumScale = maximumScale;
    }

    public void setMinimumScale(float scale) {
        this.minimumScale = scale;
    }

    public float getMinimumScale() {
        return this.minimumScale;
    }

    public void setMaximumScale(float scale) {
        this.maximumScale = scale;
    }

    public float getMaximumScale() {
        return this.maximumScale;
    }

    public void setAxisOfScale(Transform3D axisOfScale) {
        this.setTransformAxis(axisOfScale);
    }

    public Transform3D getAxisOfScale() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float alphaValue, Transform3D transform) {
        double val = (1.0 - (double)alphaValue) * (double)this.minimumScale + (double)(alphaValue * this.maximumScale);
        this.scale.set(val);
        transform.mul(this.axis, this.scale);
        transform.mul(transform, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        ScaleInterpolator si = new ScaleInterpolator();
        si.duplicateNode(this, forceDuplicate);
        return si;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        ScaleInterpolator si = (ScaleInterpolator)originalNode;
        this.setMinimumScale(si.getMinimumScale());
        this.setMaximumScale(si.getMaximumScale());
    }
}

