/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.InputDevice;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.SensorRead;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Point3d;

public class Sensor {
    public static final int PREDICT_NONE = 1;
    public static final int PREDICT_NEXT_FRAME_TIME = 2;
    public static final int NO_PREDICTOR = 16;
    public static final int HEAD_PREDICTOR = 32;
    public static final int HAND_PREDICTOR = 64;
    public static final int DEFAULT_SENSOR_READ_COUNT = 30;
    static final int SENSOR_READ_COUNT_BUFFER = 15;
    static int num_reads_so_far = 0;
    boolean demand_driven = false;
    int sensorReadCount;
    private int predictionPolicy = 16;
    private int predictorType = 1;
    InputDevice device;
    SensorRead[] readings;
    int currentIndex;
    int lastIndex;
    Point3d hotspot;
    int MaxSensorReadIndex;
    int sensorButtonCount;
    Matrix3d orig_rot = new Matrix3d();
    Matrix3d orig_rot_transpose = new Matrix3d();
    Matrix3d temp_rot = new Matrix3d();
    Matrix3d local_svd = new Matrix3d();

    public Sensor(InputDevice device) {
        this(device, 30, 0, new Point3d(0.0, 0.0, 0.0));
    }

    public Sensor(InputDevice device, int sensorReadCount) {
        this(device, sensorReadCount, 0, new Point3d(0.0, 0.0, 0.0));
    }

    public Sensor(InputDevice device, int sensorReadCount, int sensorButtonCount) {
        this(device, sensorReadCount, sensorButtonCount, new Point3d(0.0, 0.0, 0.0));
    }

    public Sensor(InputDevice device, Point3d hotspot) {
        this(device, 30, 0, hotspot);
    }

    public Sensor(InputDevice device, int sensorReadCount, Point3d hotspot) {
        this(device, sensorReadCount, 0, hotspot);
    }

    public Sensor(InputDevice device, int sensorReadCount, int sensorButtonCount, Point3d hotspot) {
        this.device = device;
        this.sensorReadCount = sensorReadCount;
        this.MaxSensorReadIndex = sensorReadCount + 15 - 1;
        this.sensorButtonCount = sensorButtonCount;
        this.readings = new SensorRead[this.MaxSensorReadIndex + 1];
        for (int i = 0; i < this.MaxSensorReadIndex + 1; ++i) {
            this.readings[i] = new SensorRead(sensorButtonCount);
        }
        this.currentIndex = 0;
        this.hotspot = new Point3d(hotspot);
    }

    int previousIndex(int k) {
        int temp = this.currentIndex - k;
        return temp >= 0 ? temp : this.MaxSensorReadIndex + temp + 1;
    }

    public void setPredictor(int predictor) {
        if (predictor != 1 && predictor != 2) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor0"));
        }
        this.predictorType = predictor;
    }

    public int getPredictor() {
        return this.predictorType;
    }

    public void setPredictionPolicy(int policy) {
        if (policy != 16 && policy != 32 && policy != 64) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor1"));
        }
        this.predictionPolicy = policy;
    }

    public int getPredictionPolicy() {
        return this.predictionPolicy;
    }

    public void setHotspot(Point3d hotspot) {
        this.hotspot.set(hotspot);
    }

    public void getHotspot(Point3d hotspot) {
        hotspot.set(this.hotspot);
    }

    public void setDevice(InputDevice device) {
        this.device = device;
    }

    public InputDevice getDevice() {
        return this.device;
    }

    public void getRead(Transform3D read) {
        if (this.demand_driven) {
            this.device.pollAndProcessInput();
        }
        read.set(this.readings[this.currentIndex].read);
    }

    public void getRead(Transform3D read, long deltaT) {
        this.getRead(read);
    }

    public void lastRead(Transform3D read) {
        read.set(this.readings[this.currentIndex].read);
    }

    public void lastRead(Transform3D read, int kth) {
        if (kth >= this.sensorReadCount) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor3"));
        }
        read.set(this.readings[this.previousIndex((int)kth)].read);
    }

    public long lastTime() {
        return this.readings[this.currentIndex].time;
    }

    public long lastTime(int k) {
        if (k >= this.sensorReadCount) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor4"));
        }
        return this.readings[this.previousIndex((int)k)].time;
    }

    public void lastButtons(int[] values) {
        System.arraycopy(this.readings[this.currentIndex].buttonValues, 0, values, 0, this.sensorButtonCount);
    }

    public void lastButtons(int k, int[] values) {
        if (k >= this.sensorReadCount) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor5"));
        }
        System.arraycopy(this.readings[this.previousIndex((int)k)].buttonValues, 0, values, 0, this.sensorButtonCount);
    }

    public int getSensorReadCount() {
        return this.sensorReadCount;
    }

    public void setSensorReadCount(int count) {
        this.sensorReadCount = count;
        this.MaxSensorReadIndex = this.sensorReadCount + 15 - 1;
        this.readings = new SensorRead[this.MaxSensorReadIndex + 1];
        for (int i = 0; i < this.MaxSensorReadIndex + 1; ++i) {
            this.readings[i] = new SensorRead(this.sensorButtonCount);
        }
        this.currentIndex = 0;
    }

    public int getSensorButtonCount() {
        return this.sensorButtonCount;
    }

    public SensorRead getCurrentSensorRead() {
        SensorRead read = new SensorRead(this.sensorButtonCount);
        read.set(this.readings[this.currentIndex]);
        return read;
    }

    public void setNextSensorRead(long time, Transform3D transform, int[] values) {
        int temp = this.currentIndex + 1;
        if (temp > this.MaxSensorReadIndex) {
            temp = 0;
        }
        this.readings[temp].setTime(time);
        this.readings[temp].set(transform);
        if (this.sensorButtonCount > 0) {
            this.readings[temp].setButtons(values);
        }
        this.currentIndex = temp;
    }

    public void setNextSensorRead(SensorRead read) {
        int temp = this.currentIndex + 1;
        if (temp > this.MaxSensorReadIndex) {
            temp = 0;
        }
        this.readings[temp].set(read);
        this.currentIndex = temp;
    }
}

