# The excessive comments are because this is supposed to be a helpful
# example :)

# This is the total angle between the two views that the 3D image is
# constructed from.  You probably want to tweak this to get the angle
# right for your presentation (e.g. depending on how large the screen
# is, and how far away people will be...)

degree_separation = 4

# Find the current image:

i = getImage

# Some preliminary checks:

if i.getStackSize == 1
  ij.IJ.error "This script only works on image stacks"
  return
end

unless i.getBitDepth == 8
  ij.IJ.error "This script only works on 8 bit image stacks"
  return
end

# Use the "3D Project..." (ij.plugin.filter.Projector) plugin to
# generate an image stack with two slices, each containing a view of
# the stack from a slightly different angle:

projection_options = "projection=[Brightest Point] axis=Y-Axis "
projection_options += "initial=-#{degree_separation / 2} "
projection_options += "total=#{degree_separation} "
projection_options += "rotation=#{degree_separation} "
projection_options += "interpolate"

run "3D Project...", projection_options

# Operate on the generated window:

# (It's an inelegance typical of writing macros such as these that one
# has to discover the particular method the algorithm used to generate
# the name of the new ImagePlus.)

projections_title = "Projections of " + i.getShortTitle
select_window projections_title

# Split the stack into separate images, so we can merge them as
# different colours:

run "Stack to Images"

# The images generated by that have predicatable names (see the
# similar note above).  Use "RGB Merge..." to merge them:

merge_options = "red=Projections-0001 "
merge_options += "green=Projections-0002 "
merge_options += "blue=Projections-0002 "
merge_options += "gray=*None*"

run "RGB Merge...", merge_options
