#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <input binary>\n", argv[0]);
        return 1;
    }

    const char *input_file = argv[1];
    const char *output_file = "htdocs.h";

    FILE *fin = fopen(input_file, "rb");
    if (!fin) {
        perror("Failed to open input file");
        return 1;
    }

    FILE *fout = fopen(output_file, "w");
    if (!fout) {
        perror("Failed to create output file");
        fclose(fin);
        return 1;
    }

    // ---- Write header ----
    fprintf(fout,
        "#ifndef _HTDOSC_H\n"
        "#define _HTDOSC_H\n\n"
        "static const unsigned char htdocs_data[] = {\n"
    );

    int c, count = 0;
    while ((c = fgetc(fin)) != EOF) {
        if (count % 12 == 0) {
            fprintf(fout, "    ");   // indent
        }
        fprintf(fout, "0x%02X,", (unsigned char)c);
        count++;

        if (count % 12 == 0)
            fprintf(fout, "\n");
        else
            fprintf(fout, " ");
    }

    if (count % 12 != 0)
        fprintf(fout, "\n");

    fprintf(fout,
        "};\n\n"
        "static const unsigned int htdocs_len = %d;\n\n"
        "#endif /* _HTDOSC_H */\n",
        count
    );

    fclose(fin);
    fclose(fout);

    printf("Generated: %s (length: %d bytes)\n", output_file, count);
    return 0;
}
