/**************************************************************************//**
 * @file     hal.h
 * @brief    The file include all HAL header files.
 * @version  V1.00
 * @date     2021-03-10
 *
 * @note
 *
 ******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ******************************************************************************/

#ifndef _HAL_H_
#define _HAL_H_

/**
 * @addtogroup 8735b_hal HAL
 * @{
 * @brief The HAL APIs of the AmebaZ2 platform.
 */

#include "hal_api.h"

#include "hal_sys_ctrl.h"
#include "hal_sys_ctrl_nsc.h"

#include "hal_cache.h"
#include "hal_irq.h"
#include "hal_wdt.h"
#include "hal_pinmux.h"

//#include "hal_crypto.h"
//#include "hal_efuse.h"
//#include "hal_efuse_nsc.h"
//#include "hal_flash.h"
#include "hal_gdma.h"
#include "hal_timer.h"
#include "hal_uart.h"
#include "hal_gpio.h"
#include "hal_ssi.h"

#include "hal_i2c.h"
//#include "hal_misc.h"
//#include "hal_pinmux.h"
//#include "hal_pwm.h"
//#include "hal_spic.h"
//#include "hal_ssi.h"

#include "hal_enc.h"
//#include "hal_video.h"

//#include "hal_sce.h"
#include "hal_audio.h"
#include "hal_sport.h"


/** @} */ /* End of group 8735b_hal */

#endif  // end of "#define _HAL_H_"

