/*
 * Copyright(c) 2007 - 2018 Realtek Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @file     rtl8735b_vendor.h
 * @brief    CMSIS HeaderFile
 * @version  1.0
 * @date     13. December 2018
 * @note     Generated by SVDConv V3.3.13 on Thursday, 13.12.2018 15:07:46
 *           from File 'rtl8735b_vendor.svd',
 *           last modified on Thursday, 13.12.2018 07:07:16
 */




/** @addtogroup hs_hal_vendor Vendor Function
  * @ingroup 8735b_hal
  * @{
  */


#ifndef RTL8735B_VENDOR_H
#define RTL8735B_VENDOR_H

#ifdef __cplusplus
extern "C" {
#endif


/// @cond DOXYGEN_VDR_REG_TYPE

/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
#pragma push
#pragma anon_unions
#elif defined (__ICCARM__)
#pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wc11-extensions"
#pragma clang diagnostic ignored "-Wreserved-id-macro"
#pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
#pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
/* anonymous unions are enabled by default */
#elif defined (__TMS470__)
/* anonymous unions are enabled by default */
#elif defined (__TASKING__)
#pragma warning 586
#elif defined (__CSMC__)
/* anonymous unions are enabled by default */
#else
#warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup vendor_peripherals Vendor Function Registers
  * @ingroup hs_hal_vendor
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            VDR                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Vendor Registers (VDR)
  */

typedef struct {                                /*!< (@ 0x40002800) VDR Structure                                              */

	union {
		__IOM uint32_t watch_dog_timer;             /*!< (@ 0x00000000) Watch Dog Timer Control Register                           */

		struct {
			__IOM uint32_t vndr_divfactor : 16;       /*!< [15..0] Dividing factor. Watch dog timer is count with 64KHz/(divfactor+1).
                                                     Minimum dividing factor is 1.                                             */
			__IOM uint32_t wdt_en_byte : 8;           /*!< [23..16] Set 0xA5 to enable watch dog timer                               */
			__OM  uint32_t wdt_clear  : 1;            /*!< [24..24] Write 1 to clear timer                                           */
			__IOM uint32_t cnt_limit  : 4;            /*!< [28..25] 0: 0x001 1: 0x003 2: 0x007 3: 0x00F 4: 0x01F 5: 0x03F
                                                     6: 0x07F 7: 0x0FF 8: 0x1FF 9: 0x3FF 10: 0x7FF 11~15: 0xFFF                */
			__IM  uint32_t            : 1;
			__IOM uint32_t wdt_mode   : 1;            /*!< [30..30] 1: Reset system, 0: Interrupt CPU                                */
			__IOM uint32_t wdt_to     : 1;            /*!< [31..31] Watch dog timer timeout. 1 cycle pulse, Write 1 to
                                                     clear.                                                                    */
		} watch_dog_timer_b;
	} ;

	union {
		__IOM uint32_t low_pri_int_mode;            /*!< (@ 0x00000004) Low Priority Interrupt Trigger Mode Control Register       */

		struct {
			__IOM uint32_t low_pri_int0_mode : 1;     /*!< [0..0] Each bit control corresponding interrupt mode. 1: Rising
                                                     edge trigger 0: High level active                                         */
			__IOM uint32_t low_pri_int1_mode : 1;     /*!< [1..1] Each bit control corresponding interrupt mode. 1: Rising
                                                     edge trigger 0: High level active                                         */
			__IOM uint32_t low_pri_int2_mode : 1;     /*!< [2..2] Each bit control corresponding interrupt mode. 1: Rising
                                                     edge trigger 0: High level active                                         */
			__IOM uint32_t low_pri_int13_mode : 1;    /*!< [3..3] Each bit control corresponding interrupt mode. 1: Rising
                                                     edge trigger 0: High level active                                         */
			__IOM uint32_t low_pri_int4_mode : 1;     /*!< [4..4] Each bit control corresponding interrupt mode. 1: Rising
                                                     edge trigger 0: High level active                                         */
		} low_pri_int_mode_b;
	} ;

	union {
		__IOM uint32_t low_pri_int_imr;             /*!< (@ 0x00000008) Low Priority Interrupt Mask Register                       */

		struct {
			__IOM uint32_t rxi_300_en : 1;            /*!< [0..0] Each bit enable corresponding interrupt. 1: Enable 0:
                                                     Disable                                                                   */
			__IOM uint32_t spic_int_en : 1;           /*!< [1..1] Each bit enable corresponding interrupt. 1: Enable 0:
                                                     Disable                                                                   */
			__IOM uint32_t psrm_cal_fail_int_en : 1;  /*!< [2..2] Each bit enable corresponding interrupt. 1: Enable 0:
                                                     Disable                                                                   */
			__IOM uint32_t psrm_time_out_int_en : 1;  /*!< [3..3] Each bit enable corresponding interrupt. 1: Enable 0:
                                                     Disable                                                                   */
			__IOM uint32_t scorebord_int_en : 1;      /*!< [4..4] Each bit enable corresponding interrupt. 1: Enable 0:
                                                     Disable                                                                   */
		} low_pri_int_imr_b;
	} ;

	union {
		__IOM uint32_t low_pri_int_isr;             /*!< (@ 0x0000000C) Low Priority Interrupt Pending Status Register             */

		struct {
			__IOM uint32_t rxi_300_int : 1;           /*!< [0..0] RXI300 bus interrupt status. Write 1 clear.                        */
			__IOM uint32_t spic_int   : 1;            /*!< [1..1] SPIC interrupt status, Write 1 clear.                              */
			__IOM uint32_t psrm_cal_fail_int : 1;     /*!< [2..2] PSRAM calibration fail interrupt status. Write 1 clear.            */
			__IOM uint32_t psrm_time_out_int : 1;     /*!< [3..3] PSRAM calibration timeout interrupt status. Write 1 clear.         */
			__IM  uint32_t scoreboard_int : 1;        /*!< [4..4] Scoreboard interrupt status                                        */
		} low_pri_int_isr_b;
	} ;
	__IM  uint32_t  RESERVED[3];

	union {
		__IOM uint32_t anack_ctrl;                  /*!< (@ 0x0000001C) ANA Clock Control Register                                 */

		struct {
			__IOM uint32_t anack_rpt  : 16;           /*!< [15..0] The calculation value of ANA clock where the reference
                                                     clock is 40MHz.                                                           */
			__IM  uint32_t            : 8;
			__IOM uint32_t anack_sel  : 2;            /*!< [25..24] 00: Calculation of 4M for 32 cycles (for debug use)
                                                     01: Calculation of 128K for 8 cycles 10: Rsvd 11: Rsvd                    */
			__IM  uint32_t            : 5;
			__IOM uint32_t anack_cmd  : 1;            /*!< [31..31] 1: Enable ANACK calculation and indicate busy when
                                                     the calculation process is on-going. 0: Calculation is
                                                     done. Set as 0 by HW when calibration is done.                            */
		} anack_ctrl_b;
	} ;

	union {
		__IOM uint32_t data_fifo_swap_ctrl;         /*!< (@ 0x00000020) FIFO Data Swap Control Register                            */

		struct {
			__IOM uint32_t i2c0_tx_bit_swap_en : 1;   /*!< [0..0] I2C TX bits swap enable                                            */
			__IOM uint32_t i2c0_rx_bit_swap_en : 1;   /*!< [1..1] I2C RX bits swap enable                                            */
		} data_fifo_swap_ctrl_b;
	} ;
	__IM  uint32_t  RESERVED1[3];

	union {
		__IM  uint32_t gdma0_isr;            /*!< (@ 0x00000030) Non-Secure GDMA Interrupt Pending Status Register              */

		struct {
			__IM  uint32_t gdma0_ch0_isr : 1;         /*!< [0..0] Non-Secure GDMA 0 channel 0 interrupt pending status                     */
			__IM  uint32_t gdma0_ch1_isr : 1;         /*!< [1..1] Non-Secure GDMA 0 channel 1 interrupt pending status                     */
			__IM  uint32_t gdma0_ch2_isr : 1;         /*!< [2..2] Non-Secure GDMA 0 channel 2 interrupt pending status                     */
			__IM  uint32_t gdma0_ch3_isr : 1;         /*!< [3..3] Non-Secure GDMA 0 channel 3 interrupt pending status                     */
			__IM  uint32_t gdma0_ch4_isr : 1;         /*!< [4..4] Non-Secure GDMA 0 channel 4 interrupt pending status                     */
			__IM  uint32_t gdma0_ch5_isr : 1;         /*!< [5..5] Non-Secure GDMA 0 channel 5 interrupt pending status                     */
		} gdma0_isr_b;
	} ;

	union {
		__IM  uint32_t gdma1_isr;            /*!< (@ 0x00000034) Non-Secure GDMA Interrupt Pending Status Register              */

		struct {
			__IM  uint32_t gdma1_ch0_isr : 1;         /*!< [0..0] Non-Secure GDMA 1 channel 0 interrupt pending status                     */
			__IM  uint32_t gdma1_ch1_isr : 1;         /*!< [1..1] Non-Secure GDMA 1 channel 1 interrupt pending status                     */
			__IM  uint32_t gdma1_ch2_isr : 1;         /*!< [2..2] Non-Secure GDMA 1 channel 2 interrupt pending status                     */
			__IM  uint32_t gdma1_ch3_isr : 1;         /*!< [3..3] Non-Secure GDMA 1 channel 3 interrupt pending status                     */
			__IM  uint32_t gdma1_ch4_isr : 1;         /*!< [4..4] Non-Secure GDMA 1 channel 4 interrupt pending status                     */
			__IM  uint32_t gdma1_ch5_isr : 1;         /*!< [5..5] Non-Secure GDMA 1 channel 5 interrupt pending status                     */
		} gdma1_isr_b;
	} ;

	union {
		__IM  uint32_t wl_isr;                      /*!< (@ 0x00000038) WLAN Interrupt Pending Status Register                     */

		struct {
			__IM  uint32_t wlan_page0_int : 1;        /*!< [0..0] Wlan Page0 Interrupt pending status.                               */
			__IM  uint32_t ahb_local_int : 1;         /*!< [1..1] WL page3 interrupt pending status                                  */
		} wl_isr_b;
	} ;
	__IM  uint32_t  RESERVED2;

	union {
		__IOM uint32_t mbist_ctrl;                  /*!< (@ 0x00000040) MBIST Control Register                                     */

		struct {
			__IOM uint32_t mbist_clk_en : 1;          /*!< [0..0] bit mbist clock enable.                                            */
			__IOM uint32_t mbist_rstn : 1;            /*!< [1..1] mbist enable for each mbist group                                  */
			__IOM uint32_t mbist_msel : 2;            /*!< [3..2] mbist mode select, 2'b01, 2'b11---> nrml mode enalbe,
                                                     2'b10, 2'b11 -->drf mode enable                                           */
			__IOM uint32_t mbist_resume : 1;          /*!< [4..4] resume mbist drf test                                              */
			__IOM uint32_t mbist_dyn_rden : 1;        /*!< [5..5] dynamic vdd enable                                                 */
			__IOM uint32_t mbist_resume_ps : 1;       /*!< [6..6] resume mbist ps test                                               */
			__IM  uint32_t            : 1;
			__IOM uint32_t mbist_rom_rpt_sel0 : 3;    /*!< [10..8] select mbist rom report result                                    */
		} mbist_ctrl_b;
	} ;

	union {
		__IOM uint32_t mbist_func_en_ctrl;          /*!< (@ 0x00000044) MBIST Function Enable Control Register                     */

		struct {
			__IOM uint32_t mbist_fen_cpu_bt : 1;      /*!< [0..0] enable mbist for BT CPU                                            */
			__IOM uint32_t mbist_fen_128x12x4 : 1;    /*!< [1..1] enable mbist for 128x12x4                                          */
			__IOM uint32_t mbist_fen_512x16_bt : 1;   /*!< [2..2] enable mbist for 512x16 BT                                         */
			__IOM uint32_t mbist_fen_128x16_bt : 1;   /*!< [3..3] enable mbist for 128x16 BT                                         */
			__IOM uint32_t mbist_fen_288x32_bt : 1;   /*!< [4..4] enable mbist for 288x32 BT                                         */
			__IOM uint32_t mbist_fen_03 : 1;          /*!< [5..5] enable mbist 3                                                     */
			__IOM uint32_t mbist_fen_06 : 1;          /*!< [6..6] enable mbist 6                                                     */
			__IOM uint32_t mbist_fen_07 : 1;          /*!< [7..7] enable mbist for mbist_07, mbist_09                                */
			__IM  uint32_t            : 1;
			__IOM uint32_t mbist_fen_11 : 1;          /*!< [9..9] enable mbist for mbist_11, mbist_12                                */
			__IM  uint32_t            : 1;
			__IOM uint32_t mbist_fen_13 : 1;          /*!< [11..11] enable mbist for mbist_13, mbist_18, mbist_19                    */
			__IOM uint32_t mbist_fen_17 : 1;          /*!< [12..12] enable mbist 17                                                  */
			__IM  uint32_t            : 2;
			__IOM uint32_t mbist_fen_rx2_icache : 1;  /*!< [15..15] enable mbist for RX to I-Cache                                   */
			__IOM uint32_t mbist_fen_rx2_dcache : 1;  /*!< [16..16] enable mbist for RX to D-cache                                   */
			__IOM uint32_t mbist_fen_rx2_dtcm : 1;    /*!< [17..17] enable mbist for RX to DTCM                                      */
			__IOM uint32_t mbist_fen_wmac_e0_dc : 1;  /*!< [18..18] enable mbist for wmac_e0 DC                                      */
			__IOM uint32_t mbist_fen_wmac_e1_dc : 1;  /*!< [19..19] enable mbist for wmac_e1 DC                                      */
			__IOM uint32_t mbist_fen_wpon_e0_dc : 1;  /*!< [20..20] enable mbist for wpon_e0_dc                                      */
			__IOM uint32_t mbist_fen_wpon_e1_dc : 1;  /*!< [21..21] enable mbist for wpon_e1_dc                                      */
			__IOM uint32_t mbist_fen_sdio : 1;        /*!< [22..22] enable mbist for SDIO                                            */
			__IOM uint32_t mbiist_fen_share : 1;      /*!< [23..23] enable mbist for share                                           */
			__IOM uint32_t mbist_fen_rom32kx32 : 1;   /*!< [24..24] enable mbist for 32K x 32                                        */
			__IOM uint32_t mbist_fen_rx2_itcm : 1;    /*!< [25..25] enable mbist for rx to ITCM                                      */
			__IOM uint32_t mbist_fen_wmac_e2_dc : 1;  /*!< [26..26] enable mbist for wmac_e2_dc                                      */
		} mbist_func_en_ctrl_b;
	} ;

	union {
		__IM  uint32_t mbist_sta;                   /*!< (@ 0x00000048) MBIST Status Register                                      */

		struct {
			__IM  uint32_t mbist_drf_fail : 1;        /*!< [0..0] mbist test status :drf_fail                                        */
			__IM  uint32_t mbist_drf_done : 1;        /*!< [1..1] mbist test status: drf_done                                        */
			__IM  uint32_t mbist_nrml_fail : 1;       /*!< [2..2] mbist test status : normal failed                                  */
			__IM  uint32_t mbist_nrml_done : 1;       /*!< [3..3] mbist test status: normal done                                     */
			__IM  uint32_t mbist_start_pause : 1;     /*!< [4..4] mbist test status :start/pause                                     */
		} mbist_sta_b;
	} ;

	union {
		__IM  uint32_t mbist_done;                  /*!< (@ 0x0000004C) MBIST Done Output Register                                 */

		struct {
			__IM  uint32_t data       : 32;           /*!< [31..0] mbist_done                                                        */
		} mbist_done_b;
	} ;

	union {
		__IM  uint32_t mbist_fail_nrml0;            /*!< (@ 0x00000050) MBIST Fail Normal Output Register0                         */

		struct {
			__IM  uint32_t data       : 32;           /*!< [31..0] mbist_fail_nrml0                                                  */
		} mbist_fail_nrml0_b;
	} ;

	union {
		__IM  uint32_t mbist_fail_nrml1;            /*!< (@ 0x00000054) MBIST Fail Normal Output Register1                         */

		struct {
			__IM  uint32_t data       : 32;           /*!< [31..0] mbist_fail_nrml1                                                  */
		} mbist_fail_nrml1_b;
	} ;

	union {
		__IM  uint32_t mbist_fail_nrml2;            /*!< (@ 0x00000058) MBIST Fail Normal Output Register2                         */

		struct {
			__IM  uint32_t dara       : 32;           /*!< [31..0] mbist_fail_nrml2                                                  */
		} mbist_fail_nrml2_b;
	} ;

	union {
		__IM  uint32_t mbist_fail_drf0;             /*!< (@ 0x0000005C) MBIST Fail DRF Output Register0                            */

		struct {
			__IM  uint32_t data       : 32;           /*!< [31..0] mbist_fail_drf0                                                   */
		} mbist_fail_drf0_b;
	} ;

	union {
		__IM  uint32_t mbist_fail_drf1;             /*!< (@ 0x00000060) MBIST Fail DRF Output Register1                            */

		struct {
			__IM  uint32_t data       : 32;           /*!< [31..0] mbist_fail_drf1                                                   */
		} mbist_fail_drf1_b;
	} ;

	union {
		__IM  uint32_t mbist_fail_drf2;             /*!< (@ 0x00000064) MBIST Fail DRF Output Register2                            */

		struct {
			__IM  uint32_t data       : 32;           /*!< [31..0] mbist_fail_drf2                                                   */
		} mbist_fail_drf2_b;
	} ;

	union {
		__IM  uint32_t mbist_start_pause0;          /*!< (@ 0x00000068) MBIST Start Pause Output Register0                         */

		struct {
			__IM  uint32_t data       : 32;           /*!< [31..0] mbist_start_pause0                                                */
		} mbist_start_pause0_b;
	} ;

	union {
		__IM  uint32_t mbist_start_pause1;          /*!< (@ 0x0000006C) MBIST Start Pause Output Register1                         */

		struct {
			__IM  uint32_t data       : 32;           /*!< [31..0] mbist_start_pause1                                                */
		} mbist_start_pause1_b;
	} ;

	union {
		__IM  uint32_t mbist_start_pause2;          /*!< (@ 0x00000070) MBIST Start Pause Output Register2                         */

		struct {
			__IM  uint32_t data       : 32;           /*!< [31..0] mbist_start_pause2                                                */
		} mbist_start_pause2_b;
	} ;
	__IM  uint32_t  RESERVED3;

	union {
		__IM  uint32_t mbist_rom_misr_dout_l;       /*!< (@ 0x00000078) MBIST ROM MISR Data Output Low Register                    */

		struct {
			__IM  uint32_t data       : 32;           /*!< [31..0] rom_misr_dout[31:0] of memory misr                                */
		} mbist_rom_misr_dout_l_b;
	} ;

	union {
		__IM  uint32_t mbist_rom_misr_dout_h;       /*!< (@ 0x0000007C) MBIST ROM MISR Data Output High Register                   */

		struct {
			__IM  uint32_t data       : 32;           /*!< [31..0] rom_misr_dout[63:32] of memory misr                               */
		} mbist_rom_misr_dout_h_b;
	} ;
} VDR_Type;                                     /*!< Size = 128 (0x80)                                                         */



/* =========================================================================================================================== */
/* ================                                           VDR_S                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Vendor Registers (VDR_S)
  */

typedef struct {                                /*!< (@ 0x50002C00) VDR_S Structure                                            */

	union {
		__IOM uint32_t sec_low_pri_int_mode;        /*!< (@ 0x00000000) Secure Low Priority Interrupt Trigger Mode Control
                                                                    Register                                                   */

		struct {
			__IOM uint32_t sec_low_pri_int0_mode : 1; /*!< [0..0] Each bit control corresponding interrupt mode. 1: Rising
                                                     edge trigger 0: High level active                                         */
		} sec_low_pri_int_mode_b;
	} ;

	union {
		__IOM uint32_t sec_low_pri_int_imr;         /*!< (@ 0x00000004) Secure Low Priority Interrupt Mask Register                */

		struct {
			__IOM uint32_t rxi300_int_imr : 1;        /*!< [0..0] 1: Enable 0: Disable                                               */
		} sec_low_pri_int_imr_b;
	} ;

	union {
		__IOM uint32_t secure_low_pri_int_isr;      /*!< (@ 0x00000008) Secure Low Priority Interrupt Pending Status
                                                                    Register                                                   */

		struct {
			__IOM uint32_t rxi300_secure_bus_isr : 1; /*!< [0..0] RXI300 secure bus interrupt pending status. Wite 1 clear.          */
		} secure_low_pri_int_isr_b;
	} ;

	union {
		__IM  uint32_t gdma0_isr;            /*!< (@ 0x0000000C) Secure GDMA Interrupt Pending Status Register              */

		struct {
			__IM  uint32_t gdma0_ch0_isr : 1;         /*!< [0..0] Secure GDMA 0 channel 0 interrupt pending status                     */
			__IM  uint32_t gdma0_ch1_isr : 1;         /*!< [1..1] Secure GDMA 0 channel 1 interrupt pending status                     */
			__IM  uint32_t gdma0_ch2_isr : 1;         /*!< [2..2] Secure GDMA 0 channel 2 interrupt pending status                     */
			__IM  uint32_t gdma0_ch3_isr : 1;         /*!< [3..3] Secure GDMA 0 channel 3 interrupt pending status                     */
			__IM  uint32_t gdma0_ch4_isr : 1;         /*!< [4..4] Secure GDMA 0 channel 4 interrupt pending status                     */
			__IM  uint32_t gdma0_ch5_isr : 1;         /*!< [5..5] Secure GDMA 0 channel 5 interrupt pending status                     */
		} gdma0_isr_b;
	} ;

	union {
		__IM  uint32_t gdma1_isr;            /*!< (@ 0x00000010) Secure GDMA Interrupt Pending Status Register              */

		struct {
			__IM  uint32_t gdma1_ch0_isr : 1;         /*!< [0..0] Secure GDMA 1 channel 0 interrupt pending status                     */
			__IM  uint32_t gdma1_ch1_isr : 1;         /*!< [1..1] Secure GDMA 1 channel 1 interrupt pending status                     */
			__IM  uint32_t gdma1_ch2_isr : 1;         /*!< [2..2] Secure GDMA 1 channel 2 interrupt pending status                     */
			__IM  uint32_t gdma1_ch3_isr : 1;         /*!< [3..3] Secure GDMA 1 channel 3 interrupt pending status                     */
			__IM  uint32_t gdma1_ch4_isr : 1;         /*!< [4..4] Secure GDMA 1 channel 4 interrupt pending status                     */
			__IM  uint32_t gdma1_ch5_isr : 1;         /*!< [5..5] Secure GDMA 1 channel 5 interrupt pending status                     */
		} gdma1_isr_b;
	} ;
	__IM  uint32_t  RESERVED1[3];

	union {
		__OM  uint32_t super_sec_ef_ctrl;           /*!< (@ 0x00000020) Super Secure eFuse Control Register                        */

		struct {
			__OM  uint32_t sec_super_sec_ef_lock : 1; /*!< [0..0] When this bit is written to '1', this bit can not be
                                                     written to '0'. Beside the high speed platform is reset.
                                                     1: Super secure zone can not be accessed. 0: Super secure
                                                     zone just can be accessed by secure state. (AXI_PORT[1]
                                                     = 0)                                                                      */
		} super_sec_ef_ctrl_b;
	} ;
	__IM  uint32_t  RESERVED2[3];

	union {
		__OM  uint32_t non_fixed_secure_key0;       /*!< (@ 0x00000030) Non-Fixed Secure Key Register0                             */

		struct {
			__OM  uint32_t non_fixed_secure_key : 32; /*!< [31..0] Secure JTAG Key This register just can be written once.
                                                     After that, hardware need disable the writing function                    */
		} non_fixed_secure_key0_b;
	} ;

	union {
		__OM  uint32_t non_fixed_secure_key1;       /*!< (@ 0x00000034) Non-Fixed Secure Key Register1                             */

		struct {
			__OM  uint32_t non_fixed_secure_key : 32; /*!< [31..0] Secure JTAG Key This register just can be written once.
                                                     After that, hardware need disable the writing function                    */
		} non_fixed_secure_key1_b;
	} ;

	union {
		__OM  uint32_t non_fixed_secure_key2;       /*!< (@ 0x00000038) Non-Fixed Secure Key Register2                             */

		struct {
			__OM  uint32_t non_fixed_secure_key : 32; /*!< [31..0] Secure JTAG Key This register just can be written once.
                                                     After that, hardware need disable the writing function                    */
		} non_fixed_secure_key2_b;
	} ;

	union {
		__OM  uint32_t non_fixed_secure_key3;       /*!< (@ 0x0000003C) Non-Fixed Secure Key Register3                             */

		struct {
			__OM  uint32_t non_fixed_secure_key : 32; /*!< [31..0] Secure JTAG Key This register just can be written once.
                                                     After that, hardware need disable the writing function                    */
		} non_fixed_secure_key3_b;
	} ;

	union {
		__OM  uint32_t non_fixed_secure_key4;       /*!< (@ 0x00000040) Non-Fixed Secure Key Register4                             */

		struct {
			__OM  uint32_t non_fixed_secure_key : 32; /*!< [31..0] Secure JTAG Key This register just can be written once.
                                                     After that, hardware need disable the writing function                    */
		} non_fixed_secure_key4_b;
	} ;

	union {
		__OM  uint32_t non_fixed_secure_key5;       /*!< (@ 0x00000044) Non-Fixed Secure Key Register5                             */

		struct {
			__OM  uint32_t non_fixed_secure_key : 32; /*!< [31..0] Secure JTAG Key This register just can be written once.
                                                     After that, hardware need disable the writing function                    */
		} non_fixed_secure_key5_b;
	} ;

	union {
		__OM  uint32_t non_fixed_secure_key6;       /*!< (@ 0x00000048) Non-Fixed Secure Key Register6                             */

		struct {
			__OM  uint32_t non_fixed_secure_key : 32; /*!< [31..0] Secure JTAG Key This register just can be written once.
                                                     After that, hardware need disable the writing function                    */
		} non_fixed_secure_key6_b;
	} ;

	union {
		__OM  uint32_t non_fixed_secure_key7;       /*!< (@ 0x0000004C) Non-Fixed Secure Key Register7                             */

		struct {
			__OM  uint32_t non_fixed_secure_key : 32; /*!< [31..0] Secure JTAG Key This register just can be written once.
                                                     After that, hardware need disable the writing function                    */
		} non_fixed_secure_key7_b;
	} ;

	union {
		__OM  uint32_t non_fixed_non_secure_key0;   /*!< (@ 0x00000050) Non-Fixed Non-Secure Key Register0                         */

		struct {
			__OM  uint32_t non_fixed_non_secure_key : 32;/*!< [31..0] Non-Secure JTAG Key This register just can be written
                                                     once. After that, hardware need disable the writing function              */
		} non_fixed_non_secure_key0_b;
	} ;

	union {
		__OM  uint32_t non_fixed_non_secure_key1;   /*!< (@ 0x00000054) Non-Fixed Non-Secure Key Register1                         */

		struct {
			__OM  uint32_t non_fixed_non_secure_key : 32;/*!< [31..0] Non-Secure JTAG Key This register just can be written
                                                     once. After that, hardware need disable the writing function              */
		} non_fixed_non_secure_key1_b;
	} ;

	union {
		__OM  uint32_t non_fixed_non_secure_key2;   /*!< (@ 0x00000058) Non-Fixed Non-Secure Key Register2                         */

		struct {
			__OM  uint32_t non_fixed_non_secure_key : 32;/*!< [31..0] Non-Secure JTAG Key This register just can be written
                                                     once. After that, hardware need disable the writing function              */
		} non_fixed_non_secure_key2_b;
	} ;

	union {
		__OM  uint32_t non_fixed_non_secure_key3;   /*!< (@ 0x0000005C) Non-Fixed Non-Secure Key Register3                         */

		struct {
			__OM  uint32_t non_fixed_non_secure_key : 32;/*!< [31..0] Non-Secure JTAG Key This register just can be written
                                                     once. After that, hardware need disable the writing function              */
		} non_fixed_non_secure_key3_b;
	} ;

	union {
		__OM  uint32_t non_fixed_non_secure_key4;   /*!< (@ 0x00000060) Non-Fixed Non-Secure Key Register4                         */

		struct {
			__OM  uint32_t non_fixed_non_secure_key : 32;/*!< [31..0] Non-Secure JTAG Key This register just can be written
                                                     once. After that, hardware need disable the writing function              */
		} non_fixed_non_secure_key4_b;
	} ;

	union {
		__OM  uint32_t non_fixed_non_secure_key5;   /*!< (@ 0x00000064) Non-Fixed Non-Secure Key Register5                         */

		struct {
			__OM  uint32_t non_fixed_non_secure_key : 32;/*!< [31..0] Non-Secure JTAG Key This register just can be written
                                                     once. After that, hardware need disable the writing function              */
		} non_fixed_non_secure_key5_b;
	} ;

	union {
		__OM  uint32_t non_fixed_non_secure_key6;   /*!< (@ 0x00000068) Non-Fixed Non-Secure Key Register6                         */

		struct {
			__OM  uint32_t non_fixed_non_secure_key : 32;/*!< [31..0] Non-Secure JTAG Key This register just can be written
                                                     once. After that, hardware need disable the writing function              */
		} non_fixed_non_secure_key6_b;
	} ;

	union {
		__OM  uint32_t non_fixed_non_secure_key7;   /*!< (@ 0x0000006C) Non-Fixed Non-Secure Key Register7                         */

		struct {
			__OM  uint32_t non_fixed_non_secure_key : 32;/*!< [31..0] Non-Secure JTAG Key This register just can be written
                                                     once. After that, hardware need disable the writing function              */
		} non_fixed_non_secure_key7_b;
	} ;

	union {
		__IOM uint32_t secure_jtag_swd_ctrl;        /*!< (@ 0x00000070) Secure JTAG SWD Control Register                           */

		struct {
			__IOM uint32_t fw_ready_sc : 1;           /*!< [0..0] In Non-Fixed Key Mode, Secure JTAG/SWD wait this signal.
                                                     0: Secue JTAG/SWD cannot execute the procedure of the unlocking
                                                     JTAG/SWD. 1: Secue JTAG/SWD can execute the procedure of
                                                     the unlocking JTAG/SWD. This register just can be written
                                                     once. After that, hardware need disable the writing function              */
			__IOM uint32_t fw_ready_nonsc : 1;        /*!< [1..1] In Non-Fixed Key Mode, Non-Secure JTAG/SWD wait this
                                                     signal. 0: Secue JTAG/SWD cannot execute the procedure
                                                     of the unlocking JTAG/SWD. 1: Secue JTAG/SWD can execute
                                                     the procedure of the unlocking JTAG/SWD. This register
                                                     just can be written once. After that, hardware need disable
                                                     the writing function                                                      */
		} secure_jtag_swd_ctrl_b;
	} ;
} VDR_S_Type;                                   /*!< Size = 116 (0x74)                                                         */


/** @} */ /* End of group vendor_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup vendor_peripheralAddr Vendor Function Registers Base Address
  * @ingroup hs_hal_vendor
  * @{
  */

#define VDR_BASE                    0x40002800UL
#define VDR_S_BASE                  0x50002C00UL

/** @} */ /* End of group vendor_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup vendor_type_declaration Vendor Functions Device Type
  * @ingroup hs_hal_vendor
  * @{
  */

#define VDR                         ((VDR_Type*)               VDR_BASE)
#define VDR_S                       ((VDR_S_Type*)             VDR_S_BASE)

/** @} */ /* End of group vendor_type_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
#pragma pop
#elif defined (__ICCARM__)
/* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic pop
#elif defined (__GNUC__)
/* anonymous unions are enabled by default */
#elif defined (__TMS470__)
/* anonymous unions are enabled by default */
#elif defined (__TASKING__)
#pragma warning restore
#elif defined (__CSMC__)
/* anonymous unions are enabled by default */
#endif

#include "rtl8735b_vdr_type.h"
#include "rtl8735b_vdr_s_type.h"

/// @endcond /* End of condition DOXYGEN_VDR_REG_TYPE */


#ifdef __cplusplus
}
#endif

#endif /* RTL8710C_VENDOR_H */



/** @} */ /* End of group rtl8735b_vendor */

/** @} */ /* End of group Realtek Semiconductor Corp. */
