#include "hal_video.h"
#include "gpio_api.h"

extern hal_status_t hal_voe_i2c_write(uint16_t addr, uint16_t data);
extern hal_status_t hal_voe_i2c_read(uint16_t addr, uint16_t *data);
extern void hclk_set_rate(uint32_t rate);

int user_load_sensor_boot(void)
{
	return 1;//1:LOAD SENSOR, 0:Don't care
}

#define ORIENTATION 0

static struct rts_isp_i2c_reg g_ps5270_HDR_i2c_init_regs_asic[] = {
	//PNS308B03_25fps_ImgSyn_2110x1630_1536x1536_Pclk86M_0301_RAW12_600Mbps_B05a.asc
	{0xEF, 0x05},
	{0x0F, 0x00},
	{0x42, 0x00},
	{0x43, 0x06},
	{0xED, 0x01},
	{0xEF, 0x01},
	{0xF5, 0x01},
	{0x09, 0x01},
	{0xEF, 0x00},
	{0x10, 0x20},
	{0x11, 0x80},
	{0x3A, 0x02},
	{0x3C, 0x07},
	{0x5F, 0x2C},
	{0x60, 0xC2},
	{0x61, 0xFD},
	{0x69, 0x40},
	{0x6A, 0x80},
	{0x6E, 0x80},
	{0x6F, 0x5A},
	{0x71, 0x2D},
	{0x7F, 0x28},
	{0x85, 0x1E},
	{0x87, 0x27},
	{0x90, 0x02},
	{0x9B, 0x0B},
	{0x9E, 0x42},
	{0xA0, 0x05},
	{0xA1, 0x00},
	{0xA2, 0x0A},
	{0xA3, 0x04},
	{0xA4, 0xFE},
	{0xBE, 0x05},
	{0xE1, 0x03},
	{0xE2, 0x02},
	{0xE5, 0x03},
	{0xE6, 0x02},
	{0xED, 0x01},
	{0xEF, 0x01},
	{0x05, 0x0B},
	{0x0A, 0x06},
	{0x0B, 0x5D},
	{0x0C, 0x00},
	{0x0D, 0x04},
	{0x0E, 0x01},
	{0x0F, 0xF4},
	{0x10, 0xB0},//B05A
	{0x11, 0x5A},//B05A
	{0x19, 0x3F},
	{0x1E, 0x04},
	{0x20, 0x06},
	{0x27, 0x10},
	{0x28, 0x7C},
	{0x29, 0x0A},
	{0x2A, 0x0A},
	{0x2F, 0x02},
	{0x37, 0x18},
	{0x38, 0x03},
	{0x39, 0x22},
	{0x3B, 0x70},
	{0x3E, 0x10},
	{0x3F, 0x7C},
	{0x41, 0x13},
	{0x42, 0xF4},
	{0x44, 0x00},
	{0x56, 0x02},
	{0x60, 0x64},
	{0x67, 0x11},
	{0x68, 0x4A},
	{0x69, 0x4A},
	{0x74, 0x0E},
	{0x75, 0x4C},
	{0x7A, 0x03},
	{0x7B, 0xB1},
	{0x7C, 0x06},
	{0x7D, 0x77},
	{0x8F, 0x07},
	{0x92, 0x00},
	{0x96, 0x80},
	{0x9B, 0x0A},
	{0x9F, 0x01},
	{0xA1, 0x40},
	{0xA2, 0x40},
	{0xA4, 0x0A},
	{0xA5, 0x06},
	{0xA6, 0x04},
	{0xA8, 0x02},
	{0xA9, 0x06},
	{0xAA, 0x04},
	{0xAB, 0x01},
	{0xB0, 0x00},
	{0xB4, 0x00},
	{0xBC, 0x01},
	{0xBD, 0x09},
	{0xD7, 0x0E},
	{0xE2, 0x4F},
	{0xE3, 0x01},
	{0xE4, 0x00},
	{0xE6, 0x01},
	{0xEA, 0xBB},
	{0xF5, 0x00},
	{0xF0, 0x03},
	{0xF1, 0x19},
	{0xF2, 0x29},
	{0xF5, 0x10},
	{0xF8, 0x08},
	{0xFA, 0x75},
	{0xFC, 0x04},
	{0xFD, 0x20},
	{0x09, 0x01},
	{0xEF, 0x02},
	{0x33, 0x85},
	{0x4E, 0x02},
	{0x4F, 0x05},
	{0xED, 0x01},
	{0xEF, 0x05},
	{0x06, 0x05},
	{0x09, 0x09},
	{0x0A, 0x05},
	{0x0C, 0x04},
	{0x0D, 0x5E},
	{0x0E, 0x01},
	{0x0F, 0x00},
	{0x10, 0x02},
	{0x11, 0x01},
	{0x15, 0x07},
	{0x17, 0x05},
	{0x18, 0x02},
	{0x1B, 0x03},
	{0x1C, 0x04},
	{0x25, 0x01},
	{0x38, 0x0E},
	{0x3B, 0x01},
	{0x42, 0x00},
	{0x3F, 0x00},
	{0x40, 0x19},
	{0x41, 0x3A},//B05A
	{0x43, 0x0E},//B05A
	{0x47, 0x05},
	{0x54, 0x0F},//B05A
	{0x56, 0x0F},//B05A
	{0x58, 0x01},
	{0x42, 0x01},
	{0x5B, 0x10},
	{0xB0, 0x01},	//Short package off
	{0x5C, 0x00},
	{0x94, 0x00},//B05A
	{0xB1, 0x00},
	{0xED, 0x01},
	{0xEF, 0x06},
	{0x00, 0x0C},
	{0x02, 0x13},
	{0x03, 0x8D},
	{0x04, 0x05},
	{0x05, 0x01},
	{0x07, 0x02},
	{0x08, 0x02},
	{0x09, 0x01},
	{0x0A, 0x01},
	{0x0B, 0x82},
	{0x0C, 0xFA},
	{0x0D, 0xDB},
	{0x0F, 0x02},
	{0x10, 0x58},
	{0x11, 0x02},
	{0x12, 0x58},
	{0x17, 0x02},
	{0x18, 0x58},
	{0x19, 0x02},
	{0x1A, 0x58},
	{0x28, 0x02},
	{0x2A, 0xF0},
	{0x2B, 0xB2},
	{0x5E, 0x90},
	{0xBF, 0xC8},
	{0xED, 0x01},
	{0xEF, 0x03},
	{0x00, 0xEF},
	{0x01, 0x01},
	{0x02, 0x31},
	{0x03, 0x00},
	{0x04, 0x32},
	{0x05, 0x00},
	{0x06, 0x33},
	{0x07, 0x00},
	{0x08, 0x3B},
	{0x09, 0x4C},
	{0x0A, 0x3E},
	{0x0B, 0x30},
	{0x0C, 0x3F},
	{0x0D, 0xFF},
	{0x0E, 0x42},
	{0x0F, 0xFF},
	{0x10, 0x43},
	{0x11, 0xFF},
	{0x12, 0x44},
	{0x13, 0xFF},
	{0x14, 0x47},
	{0x15, 0x08},
	{0x16, 0x4B},
	{0x17, 0x08},
	{0x18, 0x4E},
	{0x19, 0x00},
	{0x1a, 0x52},
	{0x1b, 0x00},
	{0x1c, 0x53},
	{0x1d, 0x00},
	{0x1e, 0x58},
	{0x1f, 0x00},
	{0x20, 0x59},
	{0x21, 0x00},
	{0x22, 0x5A},
	{0x23, 0x16},
	{0x24, 0x64},
	{0x25, 0x00},
	{0x26, 0x65},
	{0x27, 0x00},
	{0x28, 0x66},
	{0x29, 0x00},
	{0x2a, 0x67},
	{0x2b, 0x00},
	{0x2c, 0x68},
	{0x2d, 0x00},
	{0x2e, 0x69},
	{0x2f, 0x00},
	{0x30, 0x74},
	{0x31, 0x0B},
	{0x32, 0x75},
	{0x33, 0xB8},
	{0x34, 0x7A},
	{0x35, 0x00},
	{0x36, 0x7B},
	{0x37, 0x96},
	{0x38, 0x7C},
	{0x39, 0x0B},
	{0x3a, 0x7D},
	{0x3b, 0xB8},
	{0x3c, 0xBC},
	{0x3d, 0x81},
	{0x3e, 0x38},
	{0x3f, 0x04},
	{0xef, 0x01},
	{0x9f, 0x03},
	{0xef, 0x03},
	{0x00, 0xef},
	{0x01, 0x01},
	{0x02, 0x31},
	{0x03, 0x03},
	{0x04, 0x32},
	{0x05, 0xFF},
	{0x06, 0x33},
	{0x07, 0x70},
	{0x08, 0x3B},
	{0x09, 0x70},
	{0x0A, 0x3E},
	{0x0B, 0x10},
	{0x0C, 0x3F},
	{0x0D, 0x7C},
	{0x0E, 0x42},
	{0x0F, 0xF4},
	{0x10, 0x43},
	{0x11, 0x70},
	{0x12, 0x44},
	{0x13, 0x00},
	{0x14, 0x47},
	{0x15, 0x00},
	{0x16, 0x4B},
	{0x17, 0x00},
	{0x18, 0x4E},
	{0x19, 0x08},
	{0x1a, 0x52},
	{0x1b, 0x02},
	{0x1c, 0x53},
	{0x1d, 0x08},
	{0x1e, 0x58},
	{0x1f, 0x02},
	{0x20, 0x59},
	{0x21, 0x08},
	{0x22, 0x5A},
	{0x23, 0x02},
	{0x24, 0x64},
	{0x25, 0x03},
	{0x26, 0x65},
	{0x27, 0xFF},
	{0x28, 0x66},
	{0x29, 0x70},
	{0x2a, 0x67},
	{0x2b, 0x11},
	{0x2c, 0x68},
	{0x2d, 0x4A},
	{0x2e, 0x69},
	{0x2f, 0x4A},
	{0x30, 0x74},
	{0x31, 0x0E},
	{0x32, 0x75},
	{0x33, 0x4C},
	{0x34, 0x7A},
	{0x35, 0x03},
	{0x36, 0x7B},
	{0x37, 0xB1},
	{0x38, 0x7C},
	{0x39, 0x06},
	{0x3a, 0x7D},
	{0x3b, 0x77},
	{0x3c, 0xBC},
	{0x3d, 0x01},
	{0x3e, 0x38},
	{0x3f, 0x03},
	{0xEF, 0x01},
	{0x9f, 0x00},
	{0xEF, 0x00},
	{0x11, 0x00},
	{0xEF, 0x05},
	{0x3B, 0x00},
	{0xED, 0x01},
	{0xEF, 0x01},
	{0x02, 0x73},
	{0x09, 0x01},
	{0xEF, 0x05},
	{0x0F, 0x01},
#if (ORIENTATION == 1)
	{0x1B, 0x86},//Rotate
	{0x1D, 0x86},
#endif
	{0xED, 0x01},
};

static struct rts_isp_i2c_reg g_ps5270_i2c_init_regs_asic2[] = {
	//{0xDL, 0x500
	{0xEF, 0x05},
	{0x25, 0x00},
	{0xED, 0x01},
};

int sensor_power_on_sequence(int on)
{
	int ret = 0;
	static hal_gpio_adapter_t gpio_rstp;
	gpio_rstp.pin_name = PIN_E0;
	if (on) {
		hclk_set_rate(0);
		hal_gpio_deinit(&gpio_rstp);
		hal_gpio_init(&gpio_rstp, PIN_E0);
		hal_gpio_set_dir(&gpio_rstp, GPIO_OUT);
		hal_gpio_write(&gpio_rstp, 0);
		hal_delay_us(1000);

		hal_gpio_write(&gpio_rstp, 1);
		hal_delay_us(2000);
		hal_gpio_write(&gpio_rstp, 0);
		hal_delay_us(2000);
		hal_gpio_write(&gpio_rstp, 1);
		hal_delay_us(3000);
		hclk_set_rate(27000000);
		hal_delay_us(5000);
	} else {
		hal_gpio_write(&gpio_rstp, 0);
		hclk_set_rate(0);
		hal_gpio_deinit(&gpio_rstp);
		hal_delay_us(3000);
	}

	return ret;
}

int video_boot_init_sensor_config(void)
{
	int ret = 0;
	int retry = 5;
	int id = 0xFFFF;
	uint16_t data;

	sensor_power_on_sequence(1);
	do {
		id = 0xFFFF;
		if (retry != 5) {
			dbg_printf("%s/%d retry %d\r\n", __FUNCTION__, __LINE__, retry);
			hal_delay_us(10000 * (5 - retry));
		}
		retry = retry - 1;
		ret = hal_voe_i2c_write(0xEF, 0x00);
		if (ret != 0) {
			continue;
		}
		ret = hal_voe_i2c_read(0x00, &data);
		if (ret != 0) {
			continue;
		}
		id = data << 8;
		ret = hal_voe_i2c_read(0x01, &data);
		if (ret != 0) {
			continue;
		}
		id |= data;
		break;
	} while (retry >= 0);
	dbg_printf("[Test]check: SensorID=0x%x\r\n", id);

	if (id == 0x5270) {
		for (int i = 0; i < (sizeof(g_ps5270_HDR_i2c_init_regs_asic) / sizeof(g_ps5270_HDR_i2c_init_regs_asic[0])); i++) {
			hal_voe_i2c_write(g_ps5270_HDR_i2c_init_regs_asic[i].addr, g_ps5270_HDR_i2c_init_regs_asic[i].data);
		}

		for (int i = 0; i < 3; i++) {
			hal_voe_i2c_write(g_ps5270_i2c_init_regs_asic2[i].addr, g_ps5270_i2c_init_regs_asic2[i].data);
		}
	} else {
		sensor_power_on_sequence(0);
		return -22;
	}

	return ret;
}

