#include "hal_video.h"
#include "gpio_api.h"

extern hal_status_t hal_voe_i2c_write(uint16_t addr, uint16_t data);
extern hal_status_t hal_voe_i2c_read(uint16_t addr, uint16_t *data);
extern void hclk_set_rate(uint32_t rate);

int user_load_sensor_boot(void)
{
	return 1;//1:LOAD SENSOR, 0:Don't care
}

#define ORIENTATION 0

static struct rts_isp_i2c_reg g_ps5420_i2c_init_regs_asic[] = {
	//PS313B01_5420_1944x1944x30fps_2Lane_RAW10_840Mbps_noImgSyn_20190408_B04A.asc
	{0xEF, 0x05},
	{0x0F, 0x00},
	{0x43, 0x02},
	{0x44, 0x00},//T_pll_enh=0
	{0xED, 0x01},
	{0xEF, 0x01},
	{0xF5, 0x01},
	{0x09, 0x01},
	{0xEF, 0x00},
	{0x10, 0x80},//Cmd_BYTECLK_InvSel=0 for PS308
	{0x11, 0x80},//GatedAllClk enable
	{0x35, 0x01},
	{0x36, 0x1E},
	{0x37, 0x1E},
	{0x38, 0xE0},
	{0x60, 0x58},
	{0x61, 0xE4},
	{0x62, 0x39},
	{0x69, 0x10},
	{0x6A, 0x40},
	{0x85, 0xB0},
	{0x98, 0x02},
	{0x9E, 0x00},
	{0xA0, 0x02},
	{0xA2, 0x0A},
	{0xD8, 0x10},
	{0xDF, 0x24},
	{0xE2, 0x05},
	{0xE3, 0x24},
	{0xE6, 0x05},
	{0xF3, 0xB0},//B04A: Version
	{0xF8, 0x4A},//B04A: Version
	{0xED, 0x01},
	{0xEF, 0x01},
	{0x05, 0x0B},
	{0x0D, 0x02},//NY min=2
#if (ORIENTATION == 1)
	{0x1B, 0x8A},//Rotate
	{0x1C, 0x2F},
	{0x1D, 0x87},
#endif
	{0x2A, 0x74},
	{0x37, 0xBA},
	{0x39, 0xC2},
	{0x3E, 0x21},
	{0x3F, 0x32},
	{0x40, 0xC2},//B03A: F4->C2
	{0x41, 0x14},//B03A: 13->14
	{0x42, 0xF4},
	{0x43, 0x2E},//B03A: FC->2E
	{0x51, 0x28},
	{0x5C, 0x1E},
	{0x5D, 0x0A},
	{0x68, 0x00},
	{0x69, 0x00},
	{0x75, 0x74},
	{0x8F, 0x08},
	{0xA3, 0x00},//Cmd_WOI_VOffset=22
	{0xA4, 0x16},//Cmd_WOI_VOffset=22
	{0xA5, 0x07},//Cmd_WOI_VSize=1944
	{0xA6, 0x9C},//Cmd_WOI_VSize=1948
	{0xA7, 0x01},//Cmd_WOI_HOffset=332
	{0xA8, 0x4C},//Cmd_WOI_HOffset=332
	{0xA9, 0x07},//Cmd_WOI_HSize=1944
	{0xAA, 0xA0},//Cmd_WOI_HSize=1952
	{0xAB, 0x01},
	{0xAE, 0x50},
	{0xB0, 0x50},
	{0xB3, 0x07},
	{0xC6, 0x10},
	{0xC9, 0x55},
	{0xCE, 0x30},
	{0xD0, 0x02},
	{0xD1, 0x60},
	{0xD3, 0x01},
	{0xD4, 0x04},
	{0xD5, 0x61},
	{0xD8, 0xA0},
	{0xDD, 0x42},
	{0xE2, 0x0A},
	{0xF0, 0x9D},
	{0xF1, 0x19}, //16
	{0xF2, 0x26}, //26
	{0xF3, 0x0C},
	{0xF5, 0x19},
	{0x09, 0x01},
	{0xEF, 0x02},
	{0x2E, 0x04},
	{0x33, 0x84},
	{0x3C, 0xFA},
	{0x4E, 0x02},
	{0xED, 0x01},
	{0xEF, 0x05},
	{0x06, 0x64},//RAW10
	{0x09, 0x09},
	{0x0A, 0x05},
	{0x0D, 0x5E},
	{0x0E, 0x01},
	{0x0F, 0x00},//MIPI CSI disable
	{0x10, 0x02},//2Lane
	{0x11, 0x01},
	{0x15, 0x07},
	{0x17, 0x06},//Update from James.Yang 2023.01.17
	{0x18, 0x05},
	{0x3B, 0x00},
	{0x40, 0x19},//16
	{0x41, 0x28},//1D
	{0x43, 0x02},
	//{0x43, 0x0A},
	{0x44, 0x01},
	{0x49, 0x01},
	{0x4F, 0x01},
	{0x5B, 0x10},//00, B04A, Reset_by_Vsync_En=1
	{0x94, 0x04},
	//{0xB0, 0x01},
	{0xB0, 0x00},
	{0xED, 0x01},
	{0xEF, 0x06},
	{0x00, 0x0C},
	{0x02, 0x13},
	{0x06, 0x02},
	{0x09, 0x02},
	{0x0A, 0x15},
	{0x0B, 0x90},
	{0x0C, 0x90},
	{0x0D, 0x90},
	{0x0F, 0x1B},
	{0x10, 0x20},
	{0x11, 0x1B},
	{0x12, 0x20},
	{0x18, 0x40},
	{0x1A, 0x40},
	{0x28, 0x03},
	{0x2B, 0x20},
	{0x2D, 0x00},
	{0x2E, 0x20},
	{0x2F, 0x20},
	{0x4A, 0x40},
	{0x4B, 0x40},
	{0x98, 0x06}, //LTM bypass, LTM_EnH=0
	{0x99, 0x23},
	{0x9E, 0x42},
	{0x9F, 0x44}, // Cmd_LTM_LThd[4:0]=8
	{0xF1, 0x01},
	{0xEF, 0x05},
	{0x3B, 0x00},//R_Cmd_Gated_MIPI_Clk=0
	{0xED, 0x01},
	{0xEF, 0x01},
	{0x02, 0xFB},//ResetTG
	{0x09, 0x01},
	{0xEF, 0x00},
	{0x11, 0x00},//GatedAllClk disable, this command move to before MIPI CSI enable(avoid LTM on display abnormal)
	//{0xDL, 0x2 ],
	//{0xEF, 0x05],
	//{0x0F, 0x01],//MIPI CSI enable
	//{0xED, 0x01],
};

static struct rts_isp_i2c_reg g_ps5420_i2c_init_regs2_asic[] = {
	{0xEF, 0x05},
	{0x0F, 0x01},//MIPI CSI enable
	{0xED, 0x01},
};

int sensor_power_on_sequence(int on)
{
	int ret = 0;
	static hal_gpio_adapter_t gpio_rstp;
	gpio_rstp.pin_name = PIN_E0;
	if (on) {
		hclk_set_rate(0);
		hal_gpio_deinit(&gpio_rstp);
		hal_gpio_init(&gpio_rstp, PIN_E0);
		hal_gpio_set_dir(&gpio_rstp, GPIO_OUT);
		hal_gpio_write(&gpio_rstp, 0);
		hal_delay_us(1000);

		hal_gpio_write(&gpio_rstp, 1);
		hal_delay_us(2000);
		hal_gpio_write(&gpio_rstp, 0);
		hal_delay_us(2000);
		hal_gpio_write(&gpio_rstp, 1);
		hal_delay_us(3000);
		hclk_set_rate(27000000);
		hal_delay_us(5000);
	} else {
		hal_gpio_write(&gpio_rstp, 0);
		hclk_set_rate(0);
		hal_gpio_deinit(&gpio_rstp);
		hal_delay_us(3000);
	}

	return ret;
}

int video_boot_init_sensor_config(void)
{
	int ret = 0;
	int retry = 5;
	int id = 0xFFFF;
	uint16_t data;

	sensor_power_on_sequence(1);
	do {
		id = 0xFFFF;
		if (retry != 5) {
			dbg_printf("%s/%d retry %d\r\n", __FUNCTION__, __LINE__, retry);
			hal_delay_us(10000 * (5 - retry));
		}
		retry = retry - 1;
		ret = hal_voe_i2c_write(0xEF, 0x00);
		if (ret != 0) {
			continue;
		}
		ret = hal_voe_i2c_read(0x00, &data);
		if (ret != 0) {
			continue;
		}
		id = data << 8;
		ret = hal_voe_i2c_read(0x01, &data);
		if (ret != 0) {
			continue;
		}
		id |= data;
		break;
	} while (retry >= 0);
	dbg_printf("[Test]check: SensorID=0x%x\r\n", id);

	if (id == 0x5520) {
		for (int i = 0; i < (sizeof(g_ps5420_i2c_init_regs_asic) / sizeof(g_ps5420_i2c_init_regs_asic[0])); i++) {
			hal_voe_i2c_write(g_ps5420_i2c_init_regs_asic[i].addr, g_ps5420_i2c_init_regs_asic[i].data);
		}

		for (int i = 0; i < 3; i++) {
			hal_voe_i2c_write(g_ps5420_i2c_init_regs2_asic[i].addr, g_ps5420_i2c_init_regs2_asic[i].data);
		}
	} else {
		sensor_power_on_sequence(0);
		return -22;
	}

	return ret;
}

