/**
  ******************************************************************************
  * @file   rtw_opt_rf_para_rtl8710c.c
  * @author
  * @version V1.0.0
  * @date    2020-10-23
  * @brief   This file provides an option to reduce code size if you are sure of supply voltage or cut version
  ******************************************************************************
  * @attention
  *
  * This module is a confidential and proprietary property of RealTek and
  * possession or use of this module requires written permission of RealTek.
  *
  * Copyright(c) 2015, Realtek Semiconductor Corporation. All rights reserved.
  ******************************************************************************
  */
#include <basic_types.h>

/******************************************************************************
 *                           phy_reg_pg.TXT
 ******************************************************************************/

// The power by rate index on the table is in hexadecimal, so it needs to be converted to decimal.
// Because a unit is 0.5dbm, we need to divide the decimal value by 2 to get the power.
// Example: power by rate index = power*2
// => ex: if power = 19dBm, set power bt rate index = 26
const u32 array_mp_8735b_phy_reg_pg[] = {
	//2.4G
	0, 0, 0, 0x00000c20, 0xffffffff, 0x262b2b2b, // {11M 5.5M 2M 1M}			(19 21.5 21.5 21.5 dBm)
	0, 0, 0, 0x00000c24, 0xffffffff, 0x27272727, // {18M 12M 9M 6M}				(19.5 19.5 19.5 19.5 dBm)
	0, 0, 0, 0x00000c28, 0xffffffff, 0x22272727, // {54M 48M 36M 24M}			(17 19.5 19.5 19.5 dBm)
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x26262626, // HT {MCS3 MCS2 MCS1 MCS0}	(19 19 19 19 dBm)
	0, 0, 0, 0x00000c30, 0xffffffff, 0x20222426, // HT {MCS7 MCS6 MCS5 MCS4}	(16 17 18 19 dBm)
	//5G
	1, 0, 0, 0x00000c24, 0xffffffff, 0x27272727, // {8M 12M 9M 6M}				(19.5 19.5 19.5 19.5 dBm)
	1, 0, 0, 0x00000c28, 0xffffffff, 0x22272727, // {54M 48M 36M 24M}			(17 19.5 19.5 19.5 dBm)
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x26262626, // HT {MCS3 MCS2 MCS1 MCS0}	(19 19 19 19 dBm)
	1, 0, 0, 0x00000c30, 0xffffffff, 0x20222426  // HT {MCS7 MCS6 MCS5 MCS4}	(16 17 18 19 dBm)
};

/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

struct txpwr_lmt_t_8735b {
	u8			reg;
	u8			band: 1;
	u8			bw: 3;
	u8			rs: 2;
	u8			ntx: 2;
	u8			ch;
	s8			val;
};

enum odm_pw_lmt_regulation_type {
	PW_LMT_REGU_FCC = 0,
	PW_LMT_REGU_ETSI = 1,
	PW_LMT_REGU_MKK = 2,
	PW_LMT_REGU_WW13 = 3,
	PW_LMT_REGU_IC = 4,
	PW_LMT_REGU_KCC = 5,
	PW_LMT_REGU_ACMA = 6,
	PW_LMT_REGU_CHILE = 7,
	PW_LMT_REGU_UKRAINE = 8,
	PW_LMT_REGU_MEXICO = 9,
	PW_LMT_REGU_CN = 10,
	PW_LMT_REGU_QATAR = 11,
	PW_LMT_REGU_UK = 12,
	PW_LMT_REGU_NCC = 13,
	PW_LMT_REGU_MAX_NUM = 14
};

typedef enum _ODM_PW_LMT_BAND_TYPE {
	PW_LMT_BAND_2_4G = 0,
	PW_LMT_BAND_5G = 1
} ODM_PW_LMT_BAND_TYPE;

typedef enum _ODM_PW_LMT_BANDWIDTH_TYPE {
	PW_LMT_BW_20M = 0,
	PW_LMT_BW_40M = 1,
	PW_LMT_BW_80M = 2
} ODM_PW_LMT_BANDWIDTH_TYPE;

typedef enum _ODM_PW_LMT_RATESECTION_TYPE {
	PW_LMT_RS_CCK = 0,
	PW_LMT_RS_OFDM = 1,
	PW_LMT_RS_HT = 2,
	PW_LMT_RS_VHT = 3
} ODM_PW_LMT_RATESECTION_TYPE;

typedef enum _ODM_PW_LMT_RFPATH_TYPE {
	PW_LMT_PH_1T = 0,
	PW_LMT_PH_2T = 1,
	PW_LMT_PH_3T = 2,
	PW_LMT_PH_4T = 3
} ODM_PW_LMT_RFPATH_TYPE;

//The power limit index of the limit table is in decimal.
//Because a unit is 0.5dbm, we need to divide the decimal value by 2 to get the power.
//Example: power index = power*2
// => ex: if power = 18dBm, set power index = 36
const struct txpwr_lmt_t_8735b array_mp_8735b_txpwr_lmt[] = {
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 30},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 24},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 20},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 26},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 10},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 20},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 26},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 10},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 34},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 20},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 63},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 63},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 63},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 63},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 28},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 30},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 28},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 28},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 30},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 28},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 30},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 30},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 30},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 28},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 30},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 28},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 28},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 30},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 28},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 24},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 30},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 24},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 20},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 30},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 30},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 20},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 63},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 63},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 63},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 63},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 63},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 40, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 40, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 40, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 40, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 44, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 44, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 44, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 44, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 48, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 48, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 48, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 48, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 52, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 52, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 52, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 52, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 56, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 56, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 56, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 56, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 60, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 60, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 60, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 60, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 64, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 64, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 64, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 64, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 100, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 100, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 100, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 100, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 104, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 104, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 104, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 104, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 108, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 108, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 108, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 108, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 112, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 112, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 112, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 112, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 116, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 116, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 116, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 116, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 120, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 120, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 120, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 120, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 124, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 124, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 124, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 124, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 128, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 128, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 128, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 128, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 132, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 132, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 132, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 132, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 136, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 136, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 136, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 136, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 140, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 140, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 140, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 140, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 144, 30},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 144, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 144, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 144, 30},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 149, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 149, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 149, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 149, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 153, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 153, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 153, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 153, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 157, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 157, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 157, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 157, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 161, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 161, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 161, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 161, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 165, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 165, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 165, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 165, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 36, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 36, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 36, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 36, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 40, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 40, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 40, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 40, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 44, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 44, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 44, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 44, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 48, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 48, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 48, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 48, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 52, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 52, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 52, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 52, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 56, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 56, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 56, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 56, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 60, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 60, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 60, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 60, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 64, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 64, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 64, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 64, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 100, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 100, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 100, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 100, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 104, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 104, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 104, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 104, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 108, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 108, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 108, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 108, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 112, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 112, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 112, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 112, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 116, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 116, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 116, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 116, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 120, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 120, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 120, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 120, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 124, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 124, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 124, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 124, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 128, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 128, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 128, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 128, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 132, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 132, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 132, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 132, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 136, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 136, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 136, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 136, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 140, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 140, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 140, 33},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 140, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 144, 30},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 144, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 144, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 144, 30},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 149, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 149, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 149, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 149, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 153, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 153, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 153, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 153, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 157, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 157, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 157, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 157, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 161, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 161, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 161, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 161, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 165, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 165, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 165, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 165, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 38, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 38, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 38, 32},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 38, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 46, 34},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 46, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 46, 32},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 46, 34},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 54, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 54, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 54, 32},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 54, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 62, 32},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 62, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 62, 32},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 62, 32},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 102, 31},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 102, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 102, 32},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 102, 31},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 110, 31},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 110, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 110, 32},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 110, 31},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 118, 31},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 118, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 118, 32},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 118, 31},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 126, 31},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 126, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 126, 32},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 126, 31},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 134, 31},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 134, 32},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 134, 32},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 134, 31},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 142, 31},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 142, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 142, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 142, 31},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 151, 28},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 151, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 151, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 151, 28},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 159, 28},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 159, 63},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 159, 63},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 159, 28}
};

u32 array_mp_8735b_txpwr_lmt_len = sizeof(array_mp_8735b_txpwr_lmt) / sizeof(struct txpwr_lmt_t_8735b);

/******************************************************************************
 *                           txxtaltrack.TXT
 ******************************************************************************/
const s8 delta_swing_xtal_mp_n_txxtaltrack_8735b[]    = {
	0, -4, -12, -15, -17, -18, -20, -18, -17, -8, -5, -1, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
const s8 delta_swing_xtal_mp_p_txxtaltrack_8735b[]    = {
	0, 4, 7, 10, 13, 15, 16, 17, 16, 15, 10, 5, -6, -14, -16,
	-16, -16, -16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};