/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.core.comms;

import com.moppy.core.comms.MoppyMessage;
import com.moppy.core.comms.NetworkReceivedMessage;

public class MoppyMessageFactory {
    public static MoppyMessage systemPong(byte deviceAddress, byte minSubAddress, byte maxSubAddress) {
        return new MoppyMessage(new byte[]{77, 0, 0, 4, MoppyMessage.CommandByte.SYS_PONG, deviceAddress, minSubAddress, maxSubAddress});
    }

    public static MoppyMessage deviceReset(byte deviceAddress) {
        return new MoppyMessage(new byte[]{77, deviceAddress, 0, 1, MoppyMessage.CommandByte.DEV_RESET});
    }

    public static MoppyMessage devicePlayNote(byte deviceAddress, byte subAddress, byte noteNumber, byte noteVelocity) {
        return new MoppyMessage(new byte[]{77, deviceAddress, subAddress, 3, MoppyMessage.CommandByte.DEV_PLAYNOTE, noteNumber, noteVelocity});
    }

    public static MoppyMessage deviceStopNote(byte deviceAddress, byte subAddress, byte noteNumber) {
        return new MoppyMessage(new byte[]{77, deviceAddress, subAddress, 2, MoppyMessage.CommandByte.DEV_STOPNOTE, noteNumber});
    }

    public static MoppyMessage devicePitchBend(byte deviceAddress, byte subAddress, short bendAmount) {
        return new MoppyMessage(new byte[]{77, deviceAddress, subAddress, 3, MoppyMessage.CommandByte.DEV_BENDPITCH, (byte)(bendAmount >> 8 & 0xFF), (byte)(bendAmount & 0xFF)});
    }

    public static MoppyMessage fromBytes(byte[] bytes) {
        return new MoppyMessage(bytes);
    }

    public static NetworkReceivedMessage networkReceivedFromBytes(byte[] bytes, String networkType, String networkIdentifier, String remoteIdentifier) {
        return new NetworkReceivedMessage(bytes, networkType, networkIdentifier, remoteIdentifier);
    }
}

