/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.core.comms.bridge;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortTimeoutException;
import com.moppy.core.comms.MoppyMessage;
import com.moppy.core.comms.MoppyMessageFactory;
import com.moppy.core.comms.NetworkMessageConsumer;
import com.moppy.core.comms.bridge.NetworkBridge;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class BridgeSerial
extends NetworkBridge<Integer> {
    private static final List<Integer> SUPPORTED_BAUDS = Arrays.asList(9600, 14400, 19200, 28800, 38400, 57600, 115200);
    private final SerialPort serialPort;
    private Thread listenerThread = null;

    public BridgeSerial(String serialPortName) {
        this.serialPort = SerialPort.getCommPort((String)serialPortName);
        this.serialPort.setBaudRate(57600);
    }

    public static List<String> getAvailableSerials() {
        return Arrays.stream(SerialPort.getCommPorts()).map(SerialPort::getSystemPortName).collect(Collectors.toList());
    }

    @Override
    public void connect(Integer newBaudRate) throws IOException {
        this.serialPort.setBaudRate(newBaudRate.intValue());
        if (!this.serialPort.openPort()) {
            throw new IOException("Failed to open serialPort!");
        }
        this.serialPort.setComPortTimeouts(1, 3200, 0);
        SerialListener listener = new SerialListener(this.serialPort, this);
        this.listenerThread = new Thread(listener);
        this.listenerThread.start();
    }

    @Override
    public void connect() throws IOException {
        this.connect(57600);
    }

    @Override
    public void sendMessage(MoppyMessage messageToSend) throws IOException {
        if (this.serialPort.isOpen()) {
            this.serialPort.writeBytes(messageToSend.getMessageBytes(), (long)messageToSend.getMessageBytes().length);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.sendMessage(MoppyMessage.SYS_STOP);
        }
        finally {
            this.serialPort.closePort();
            this.listenerThread.interrupt();
            this.listenerThread = null;
        }
    }

    @Override
    public String getNetworkIdentifier() {
        return this.serialPort.getSystemPortName();
    }

    @Override
    public boolean isConnected() {
        return this.serialPort.isOpen();
    }

    @Override
    public List<Integer> getConnectionOptions() {
        return SUPPORTED_BAUDS;
    }

    @Override
    public Integer currentConnectionOption() {
        return this.serialPort.getBaudRate();
    }

    private static class SerialListener
    implements Runnable {
        private final SerialPort serialPort;
        private final NetworkMessageConsumer messageConsumer;

        public SerialListener(SerialPort serialPort, NetworkMessageConsumer messageConsumer) {
            this.serialPort = serialPort;
            this.messageConsumer = messageConsumer;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] buffer = new byte[259];
            buffer[0] = 77;
            try (InputStream serialIn = this.serialPort.getInputStream();){
                while (this.serialPort.isOpen()) {
                    if (Thread.interrupted()) return;
                    try {
                        if (serialIn.read() != 77) continue;
                        buffer[1] = (byte)serialIn.read();
                        buffer[2] = (byte)serialIn.read();
                        buffer[3] = (byte)serialIn.read();
                        serialIn.read(buffer, 4, buffer[3]);
                        int totalMessageLength = 4 + buffer[3];
                        try {
                            this.messageConsumer.acceptNetworkMessage(MoppyMessageFactory.networkReceivedFromBytes(Arrays.copyOf(buffer, totalMessageLength), BridgeSerial.class.getName(), this.serialPort.getSystemPortName(), "Serial Device"));
                        }
                        catch (IllegalArgumentException ex) {
                            Logger.getLogger(BridgeSerial.class.getName()).log(Level.WARNING, "Exception reading network message", ex);
                        }
                    }
                    catch (SerialPortTimeoutException serialPortTimeoutException) {}
                }
                return;
            }
            catch (IOException ex) {
                Logger.getLogger(BridgeSerial.class.getName()).log(Level.WARNING, null, ex);
            }
        }
    }
}

