/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.core.comms.bridge;

import com.moppy.core.comms.MoppyMessage;
import com.moppy.core.comms.bridge.NetworkBridge;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MultiBridge
extends NetworkBridge<Object> {
    private Set<NetworkBridge> bridges = new HashSet<NetworkBridge>();

    public void addBridge(NetworkBridge bridgeToAdd) {
        bridgeToAdd.registerMessageReceiver(this);
        this.bridges.add(bridgeToAdd);
    }

    public void removeBridge(NetworkBridge bridgeToAdd) {
        bridgeToAdd.deregisterMessageReceiver(this);
        this.bridges.remove(bridgeToAdd);
    }

    @Override
    public void connect() throws IOException {
        ArrayList connectionExceptions = new ArrayList();
        this.bridges.forEach(b -> {
            try {
                b.connect();
            }
            catch (IOException ex) {
                connectionExceptions.add(ex);
                Logger.getLogger(MultiBridge.class.getName()).log(Level.WARNING, null, ex);
            }
        });
        if (connectionExceptions.size() > 0) {
            throw new IOException(String.format("%s exceptions thrown during network connection:\n%s", connectionExceptions.size(), connectionExceptions.stream().map(ex -> ex.getMessage()).collect(Collectors.joining("\n"))));
        }
    }

    @Override
    public void connect(Object connectionOption) throws IOException {
        this.connect();
    }

    @Override
    public void sendMessage(MoppyMessage messageToSend) throws IOException {
        this.bridges.forEach(b -> {
            try {
                b.sendMessage(messageToSend);
            }
            catch (IOException ex) {
                Logger.getLogger(MultiBridge.class.getName()).log(Level.WARNING, null, ex);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.bridges.forEach(b -> {
            try {
                b.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MultiBridge.class.getName()).log(Level.WARNING, null, ex);
            }
        });
    }

    @Override
    public String getNetworkIdentifier() {
        throw new UnsupportedOperationException("MultiBridge doesn't have a network ID");
    }

    @Override
    public boolean isConnected() {
        throw new UnsupportedOperationException("MultiBridge cannot report connected-ness");
    }

    @Override
    public List<Object> getConnectionOptions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Object currentConnectionOption() {
        return null;
    }
}

