/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.core.events.mapper;

import com.moppy.core.comms.MoppyMessage;
import com.moppy.core.comms.MoppyMessageFactory;
import com.moppy.core.events.mapper.EventMapper;
import java.util.Arrays;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public abstract class MIDIEventMapper
implements EventMapper<MidiMessage> {
    public static MIDIEventMapper defaultMapper(final byte deviceAddress) {
        return new MIDIEventMapper(){
            private final byte targetAddress;
            {
                this.targetAddress = deviceAddress;
            }

            @Override
            public MoppyMessage mapEvent(MidiMessage event) {
                SysexMessage sysexMessage;
                if (event instanceof ShortMessage) {
                    ShortMessage midiMessage = (ShortMessage)event;
                    switch (midiMessage.getCommand()) {
                        case 144: {
                            if (midiMessage.getData2() == 0) {
                                return MoppyMessageFactory.deviceStopNote(this.targetAddress, (byte)(midiMessage.getChannel() + 1), (byte)midiMessage.getData1());
                            }
                            return MoppyMessageFactory.devicePlayNote(this.targetAddress, (byte)(midiMessage.getChannel() + 1), (byte)midiMessage.getData1(), (byte)midiMessage.getData2());
                        }
                        case 128: {
                            return MoppyMessageFactory.deviceStopNote(this.targetAddress, (byte)(midiMessage.getChannel() + 1), (byte)midiMessage.getData1());
                        }
                        case 224: {
                            short pitchBend = (short)((((midiMessage.getData2() & 0xFF) << 7) + midiMessage.getData1() & 0xFF) - 8192);
                            return MoppyMessageFactory.devicePitchBend(this.targetAddress, (byte)(midiMessage.getChannel() + 1), pitchBend);
                        }
                    }
                } else if (event instanceof SysexMessage && (sysexMessage = (SysexMessage)event).getData()[0] == 77) {
                    return MoppyMessageFactory.fromBytes(Arrays.copyOf(sysexMessage.getData(), sysexMessage.getData().length - 1));
                }
                return null;
            }
        };
    }
}

