/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.core.midi;

import com.moppy.core.comms.MoppyMessage;
import com.moppy.core.comms.bridge.NetworkBridge;
import com.moppy.core.events.mapper.MapperCollection;
import com.moppy.core.events.postprocessor.MessagePostProcessor;
import com.moppy.core.status.StatusSender;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;

public class MoppyMIDIReceiverSender
extends StatusSender
implements Receiver {
    private final MapperCollection<MidiMessage> mappers;
    private final MessagePostProcessor postProcessor;
    private Optional<Receiver> midiThru = Optional.empty();

    public MoppyMIDIReceiverSender(MapperCollection<MidiMessage> mapperCollection, MessagePostProcessor postProcessor, NetworkBridge netBridge) throws IOException {
        super(netBridge);
        this.mappers = mapperCollection;
        this.postProcessor = postProcessor;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        Set<MoppyMessage> messagesToSend = this.mappers.mapEvent(message);
        messagesToSend = messagesToSend.stream().map(this.postProcessor::postProcess).collect(Collectors.toSet());
        messagesToSend.forEach(messageToSend -> {
            try {
                this.networkBridge.sendMessage((MoppyMessage)messageToSend);
            }
            catch (IOException ex) {
                Logger.getLogger(MoppyMIDIReceiverSender.class.getName()).log(Level.WARNING, null, ex);
            }
        });
        if (this.midiThru.isPresent()) {
            this.midiThru.get().send(message, timeStamp);
        }
    }

    @Override
    public void close() {
    }

    public void setMidiThru(Receiver midiThru) {
        this.midiThru = midiThru != null ? Optional.of(midiThru) : Optional.empty();
    }
}

