/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.core.status;

import com.moppy.core.status.StatusType;
import java.util.Optional;
import javax.sound.midi.Sequence;

public class StatusUpdate {
    private final StatusType type;
    private final Optional<Object> data;
    public static StatusUpdate SEQUENCE_START = new StatusUpdate(StatusType.SEQUENCE_START, Optional.empty());
    public static StatusUpdate SEQUENCE_PAUSE = new StatusUpdate(StatusType.SEQUENCE_PAUSE, Optional.empty());
    public static StatusUpdate SEQUENCE_STOPPED = new StatusUpdate(StatusType.SEQUENCE_STOPPED, Optional.of(true));
    public static StatusUpdate NET_STATUS_CHANGED = new StatusUpdate(StatusType.NET_STATUS_CHANGED, Optional.empty());
    public static StatusUpdate NET_DEVICES_CHANGED = new StatusUpdate(StatusType.NET_DEVICES_CHANGED, Optional.empty());

    private StatusUpdate(StatusType type, Optional<Object> data) {
        this.type = type;
        this.data = data;
    }

    public StatusType getType() {
        return this.type;
    }

    public Optional<Object> getData() {
        return this.data;
    }

    public static StatusUpdate sequenceEnd(boolean doReset) {
        return new StatusUpdate(StatusType.SEQUENCE_END, Optional.of(doReset));
    }

    public static StatusUpdate tempoChange(float tempo) {
        return new StatusUpdate(StatusType.SEQUENCE_TEMPO_CHANGE, Optional.of(Float.valueOf(tempo)));
    }

    public static StatusUpdate sequenceLoaded(Sequence sequence) {
        return new StatusUpdate(StatusType.SEQUENCE_LOAD, Optional.of(sequence));
    }
}

