/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.control;

import com.moppy.control.GUIControlledPostProcessor;
import com.moppy.control.NetworkManager;
import com.moppy.control.gui.MainWindow;
import com.moppy.core.events.mapper.MapperCollection;
import com.moppy.core.events.postprocessor.MessagePostProcessor;
import com.moppy.core.midi.MoppyMIDIReceiverSender;
import com.moppy.core.midi.MoppyMIDISequencer;
import com.moppy.core.status.StatusBus;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MoppyControlGUI {
    public static void main(String[] args) throws IOException, MidiUnavailableException {
        FileHandler logFileHandler = new FileHandler("moppy_control_gui.log", 5000000, 3, true);
        logFileHandler.setFormatter(new SimpleFormatter());
        LogManager.getLogManager().getLogger("").addHandler(logFileHandler);
        final StatusBus statusBus = new StatusBus();
        final NetworkManager netManager = new NetworkManager(statusBus);
        netManager.start();
        final MapperCollection mappers = new MapperCollection();
        final GUIControlledPostProcessor postProcessor = new GUIControlledPostProcessor();
        final MoppyMIDIReceiverSender receiverSender = new MoppyMIDIReceiverSender(mappers, (MessagePostProcessor)postProcessor, netManager.getPrimaryBridge());
        final MoppyMIDISequencer midiSequencer = new MoppyMIDISequencer(statusBus, receiverSender);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    midiSequencer.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(MoppyControlGUI.class.getName()).log(Level.WARNING, null, ex);
                }
                receiverSender.close();
                try {
                    netManager.getPrimaryBridge().close();
                }
                catch (IOException ex) {
                    Logger.getLogger(MoppyControlGUI.class.getName()).log(Level.WARNING, null, ex);
                }
            }
        });
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MoppyControlGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainWindow(statusBus, receiverSender, midiSequencer, netManager, (MapperCollection<MidiMessage>)mappers, postProcessor).setVisible(true);
            }
        });
    }
}

