/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.control;

import com.moppy.core.comms.MoppyMessage;
import com.moppy.core.comms.NetworkMessageConsumer;
import com.moppy.core.comms.NetworkReceivedMessage;
import com.moppy.core.comms.bridge.BridgeSerial;
import com.moppy.core.comms.bridge.BridgeUDP;
import com.moppy.core.comms.bridge.MultiBridge;
import com.moppy.core.comms.bridge.NetworkBridge;
import com.moppy.core.device.DeviceDescriptor;
import com.moppy.core.status.StatusBus;
import com.moppy.core.status.StatusUpdate;
import java.io.IOException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class NetworkManager
implements NetworkMessageConsumer {
    private final StatusBus statusBus;
    private final MultiBridge multiBridge = new MultiBridge();
    private final HashMap<String, NetworkBridge> networkBridges = new HashMap();
    private final ConcurrentHashMap<DeviceDescriptor, Instant> recentlySeenDevices = new ConcurrentHashMap();
    private Thread pingerThread;

    public NetworkManager(StatusBus statusBus) {
        this.statusBus = statusBus;
        this.multiBridge.registerMessageReceiver((NetworkMessageConsumer)this);
        try {
            BridgeUDP udpBridge = new BridgeUDP();
            this.networkBridges.put(udpBridge.getNetworkIdentifier(), (NetworkBridge)udpBridge);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(NetworkManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        BridgeSerial.getAvailableSerials().forEach(serial -> {
            BridgeSerial serialBridge = new BridgeSerial(serial);
            this.networkBridges.put(serialBridge.getNetworkIdentifier(), (NetworkBridge)serialBridge);
        });
    }

    public void start() {
        NetworkPinger listener = new NetworkPinger((NetworkBridge)this.multiBridge, this.recentlySeenDevices, this.statusBus);
        this.pingerThread = new Thread(listener);
        this.pingerThread.start();
    }

    public NetworkBridge getPrimaryBridge() {
        return this.multiBridge;
    }

    public void acceptNetworkMessage(NetworkReceivedMessage networkMessage) {
        DeviceDescriptor dd;
        Instant lastSeen;
        if (networkMessage.isSystemMessage() && networkMessage.getMessageCommandByte() == MoppyMessage.CommandByte.SYS_PONG && (lastSeen = this.recentlySeenDevices.put(dd = DeviceDescriptor.builder().networkAddress(String.format("%s - %s", networkMessage.getNetworkIdentifier(), networkMessage.getRemoteIdentifier())).deviceAddress(networkMessage.getMessageCommandPayload()[0]).minSubAddress(networkMessage.getMessageCommandPayload()[1]).maxSubAddress(networkMessage.getMessageCommandPayload()[2]).build(), Instant.now())) == null) {
            this.statusBus.receiveUpdate(StatusUpdate.NET_DEVICES_CHANGED);
        }
    }

    public Map<String, NetworkBridge> getAvailableNetworkBridges() {
        return this.networkBridges.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (NetworkBridge)entry.getValue()));
    }

    public Set<DeviceDescriptor> getRecentlySeenDevices() {
        return this.recentlySeenDevices.keySet();
    }

    public void connectBridge(String bridgeIdentifier, Object connectionOption) throws IOException {
        try {
            this.networkBridges.get(bridgeIdentifier).connect(connectionOption);
            this.networkBridges.get(bridgeIdentifier).registerMessageReceiver((NetworkMessageConsumer)this.multiBridge);
            this.multiBridge.addBridge(this.networkBridges.get(bridgeIdentifier));
        }
        finally {
            this.statusBus.receiveUpdate(StatusUpdate.NET_STATUS_CHANGED);
        }
    }

    public void closeBridge(String bridgeIdentifier) throws IOException {
        try {
            this.multiBridge.removeBridge(this.networkBridges.get(bridgeIdentifier));
            this.networkBridges.get(bridgeIdentifier).deregisterMessageReceiver((NetworkMessageConsumer)this.multiBridge);
            this.networkBridges.get(bridgeIdentifier).close();
        }
        finally {
            this.statusBus.receiveUpdate(StatusUpdate.NET_STATUS_CHANGED);
        }
    }

    private static class NetworkPinger
    implements Runnable {
        private final NetworkBridge bridgeToPing;
        private final ConcurrentHashMap<DeviceDescriptor, Instant> recentlySeenDevices;
        private final StatusBus statusBus;

        public NetworkPinger(NetworkBridge bridgeToPing, ConcurrentHashMap<DeviceDescriptor, Instant> recentlySeenDevices, StatusBus statusBus) {
            this.bridgeToPing = bridgeToPing;
            this.recentlySeenDevices = recentlySeenDevices;
            this.statusBus = statusBus;
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    this.bridgeToPing.sendMessage(MoppyMessage.SYS_PING);
                }
                catch (IOException ex) {
                    Logger.getLogger(NetworkManager.class.getName()).log(Level.WARNING, null, ex);
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    break;
                }
                boolean devicesCulled = this.recentlySeenDevices.values().removeIf(lastSeen -> Duration.ofSeconds(7L).minus(Duration.between(lastSeen, Instant.now())).isNegative());
                if (!devicesCulled) continue;
                this.statusBus.receiveUpdate(StatusUpdate.NET_DEVICES_CHANGED);
            }
        }
    }
}

