/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.control.gui;

import com.moppy.control.GUIControlledPostProcessor;
import com.moppy.control.MoppyPreferences;
import com.moppy.control.NetworkManager;
import com.moppy.control.gui.SequencerPanel;
import com.moppy.control.gui.mapperpanel.MapperCollectionPanel;
import com.moppy.control.gui.netpanel.NetworkPanel;
import com.moppy.core.events.mapper.MapperCollection;
import com.moppy.core.midi.MoppyMIDIReceiverSender;
import com.moppy.core.midi.MoppyMIDISequencer;
import com.moppy.core.status.StatusBus;
import com.moppy.core.status.StatusConsumer;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.sound.midi.MidiMessage;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class MainWindow
extends JFrame {
    private final StatusBus statusBus;
    private final MoppyMIDIReceiverSender receiverSender;
    private final MoppyMIDISequencer midiSequencer;
    private final NetworkManager netManager;
    private final MapperCollection<MidiMessage> mappers;
    private final GUIControlledPostProcessor postProc;
    private JScrollPane bottomPanel;
    private JSplitPane jSplitPane1;
    private MapperCollectionPanel mapperCollectionPanel;
    private NetworkPanel networkPanel;
    private SequencerPanel sequencerPanel;
    private JPanel topPanel;

    public MainWindow(StatusBus statusBus, MoppyMIDIReceiverSender receiverSender, MoppyMIDISequencer midiSequencer, NetworkManager netManager, MapperCollection<MidiMessage> mappers, GUIControlledPostProcessor postProc) {
        this.statusBus = statusBus;
        this.receiverSender = receiverSender;
        this.midiSequencer = midiSequencer;
        this.netManager = netManager;
        this.mappers = mappers;
        this.postProc = postProc;
        this.initComponents();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.topPanel = new JPanel();
        this.sequencerPanel = new SequencerPanel();
        this.sequencerPanel.setReceiverSender(this.receiverSender);
        this.sequencerPanel.setMidiSequencer(this.midiSequencer);
        this.sequencerPanel.setPostProcessor(this.postProc);
        this.statusBus.registerConsumer((StatusConsumer)this.sequencerPanel);
        this.networkPanel = new NetworkPanel();
        this.networkPanel.setNetworkManager(this.netManager);
        this.statusBus.registerConsumer((StatusConsumer)this.networkPanel);
        this.bottomPanel = new JScrollPane();
        this.mapperCollectionPanel = new MapperCollectionPanel();
        this.mapperCollectionPanel.initMapperCollectionPanel(this.mappers);
        this.statusBus.registerConsumer((StatusConsumer)this.mapperCollectionPanel);
        this.setDefaultCloseOperation(3);
        this.setTitle("Moppy Control");
        this.setMinimumSize(new Dimension(1024, 600));
        this.setPreferredSize(MoppyPreferences.getConfiguration().getMainWindowSize());
        this.setSize(MoppyPreferences.getConfiguration().getMainWindowSize());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MainWindow.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainWindow.this.formWindowClosing(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(MoppyPreferences.getConfiguration().getMainWindowDividerPosition());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MainWindow.this.jSplitPane1PropertyChange(evt);
            }
        });
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 2));
        this.sequencerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.sequencerPanel.setMinimumSize(new Dimension(400, 230));
        this.topPanel.add(this.sequencerPanel);
        this.networkPanel.setBorder(BorderFactory.createEtchedBorder());
        this.topPanel.add(this.networkPanel);
        this.jSplitPane1.setTopComponent(this.topPanel);
        this.bottomPanel.setHorizontalScrollBarPolicy(31);
        this.bottomPanel.setVerticalScrollBarPolicy(22);
        this.bottomPanel.setMinimumSize(new Dimension(23, 180));
        this.bottomPanel.setViewportView(this.mapperCollectionPanel);
        this.jSplitPane1.setBottomComponent(this.bottomPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING, -1, 1021, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.mapperCollectionPanel.saveMappersToConfig();
    }

    private void formComponentResized(ComponentEvent evt) {
        MoppyPreferences.getConfiguration().setMainWindowSize(this.getSize());
    }

    private void jSplitPane1PropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dividerLocation")) {
            MoppyPreferences.getConfiguration().setMainWindowDividerPosition(this.jSplitPane1.getDividerLocation());
        }
    }
}

