/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.control.gui;

import com.moppy.control.GUIControlledPostProcessor;
import com.moppy.control.MoppyPreferences;
import com.moppy.core.midi.MoppyMIDIReceiverSender;
import com.moppy.core.midi.MoppyMIDISequencer;
import com.moppy.core.status.StatusConsumer;
import com.moppy.core.status.StatusUpdate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SequencerPanel
extends JPanel
implements StatusConsumer,
ActionListener {
    private static final String TIME_CODE_FORMAT = "%d:%02d";
    private static final String SEQUENCE_PROGRESS = "SeqProgCmd";
    private static final String BTN_PLAY = "\u23f5";
    private static final String BTN_PAUSE = "\u23f8";
    private MoppyMIDIReceiverSender receiverSender;
    private MoppyMIDISequencer midiSequencer;
    private GUIControlledPostProcessor postProc;
    private final Timer sequenceProgressUpdateTimer;
    private Map<String, MidiDevice.Info> midiInDevices = new HashMap<String, MidiDevice.Info>();
    private Map<String, MidiDevice.Info> midiOutDevices = new HashMap<String, MidiDevice.Info>();
    private MidiDevice currentMidiInDevice = null;
    private MidiDevice currentMidiOutDevice = null;
    private final DefaultListModel<File> playlistFilesModel = new DefaultListModel();
    private int loadedIndex = -1;
    private JCheckBox autoResetCB;
    private JPanel controlsPane;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton loadFileButton;
    private JComboBox<String> midiInCB;
    private JLabel midiInLabel;
    private JComboBox<String> midiOutCB;
    private JLabel midiOutLabel;
    private JButton playButton;
    private JList<File> playlistFilesList;
    private JButton removeFileButton;
    private JCheckBox repeatCheckbox;
    private JLabel sequenceCurrentTimeLabel;
    private JFileChooser sequenceFileChooser;
    private JSlider sequenceSlider;
    private JLabel sequenceTotalTimeLabel;
    private JButton stopButton;
    private JSpinner tempoSpinner;
    private JCheckBox volumeOverrideCB;
    private JSlider volumeSlider;
    private JLabel volumeSliderLabel;

    public SequencerPanel() {
        this.sequenceProgressUpdateTimer = new Timer(500, this);
        this.sequenceProgressUpdateTimer.setActionCommand(SEQUENCE_PROGRESS);
        this.initComponents();
        this.refreshMidiDevices();
    }

    public void setReceiverSender(MoppyMIDIReceiverSender receiverSender) {
        this.receiverSender = receiverSender;
    }

    public void setMidiSequencer(MoppyMIDISequencer midiSequencer) {
        this.midiSequencer = midiSequencer;
        midiSequencer.setAutoReset(this.autoResetCB.isSelected());
    }

    public void setPostProcessor(GUIControlledPostProcessor postProc) {
        this.postProc = postProc;
    }

    private void refreshMidiDevices() {
        try {
            for (MidiDevice.Info mdi : MidiSystem.getMidiDeviceInfo()) {
                if (MidiSystem.getMidiDevice(mdi).getMaxTransmitters() != 0) {
                    this.midiInDevices.put(mdi.getName(), mdi);
                }
                if (MidiSystem.getMidiDevice(mdi).getMaxReceivers() == 0) continue;
                this.midiOutDevices.put(mdi.getName(), mdi);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SequencerPanel.class.getName()).log(Level.WARNING, "Exception getting list of MIDI devices-- MIDI In/Out will be unavailable", ex);
        }
        this.midiInCB.removeAllItems();
        this.midiOutCB.removeAllItems();
        this.midiInCB.addItem("None");
        this.midiOutCB.addItem("None");
        this.midiInDevices.keySet().forEach(key -> this.midiInCB.addItem((String)key));
        this.midiOutDevices.keySet().forEach(key -> this.midiOutCB.addItem((String)key));
    }

    private void loadSequence(int playlistIndex) {
        block2: {
            try {
                this.midiSequencer.loadSequence(this.playlistFilesModel.get(playlistIndex));
                this.playlistFilesList.setSelectedIndex(playlistIndex);
                this.loadedIndex = playlistIndex;
            }
            catch (IOException | InvalidMidiDataException ex) {
                Logger.getLogger(SequencerPanel.class.getName()).log(Level.WARNING, null, ex);
                if (this.playlistFilesModel.size() <= playlistIndex + 1) break block2;
                this.loadSequence(playlistIndex + 1);
            }
        }
    }

    private void advanceSequence() {
        if (++this.loadedIndex >= this.playlistFilesModel.size()) {
            this.loadSequence(0);
            if (this.repeatCheckbox.isSelected()) {
                this.midiSequencer.play();
            } else {
                this.midiSequencer.stop();
            }
        } else {
            this.loadSequence(this.loadedIndex);
            this.midiSequencer.play();
        }
    }

    private void initComponents() {
        this.sequenceFileChooser = new JFileChooser();
        this.loadFileButton = new JButton();
        this.controlsPane = new JPanel();
        this.sequenceCurrentTimeLabel = new JLabel();
        this.sequenceSlider = new JSlider();
        this.sequenceTotalTimeLabel = new JLabel();
        this.stopButton = new JButton();
        this.playButton = new JButton();
        this.volumeSlider = new JSlider();
        this.volumeSliderLabel = new JLabel();
        this.volumeOverrideCB = new JCheckBox();
        this.midiInLabel = new JLabel();
        this.midiInCB = new JComboBox();
        this.midiOutLabel = new JLabel();
        this.midiOutCB = new JComboBox();
        this.jLabel1 = new JLabel();
        this.tempoSpinner = new JSpinner();
        this.jScrollPane1 = new JScrollPane();
        this.playlistFilesList = new JList();
        this.removeFileButton = new JButton();
        this.autoResetCB = new JCheckBox();
        this.autoResetCB.setSelected(MoppyPreferences.getConfiguration().isAutoReset());
        this.repeatCheckbox = new JCheckBox();
        this.sequenceFileChooser.setCurrentDirectory(new File(MoppyPreferences.getConfiguration().getFileLoadDirectory()));
        this.sequenceFileChooser.setDialogTitle("Select MIDI File");
        this.sequenceFileChooser.setFileFilter(new FileNameExtensionFilter("MIDI Files", "mid"));
        this.setMinimumSize(new Dimension(400, 200));
        this.setName("sequencerPanel");
        this.loadFileButton.setText("Add File");
        this.loadFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencerPanel.this.loadFileButtonActionPerformed(evt);
            }
        });
        this.controlsPane.setMinimumSize(new Dimension(400, 149));
        this.sequenceCurrentTimeLabel.setText("00:00");
        this.sequenceSlider.setMajorTickSpacing(60);
        this.sequenceSlider.setMaximum(120);
        this.sequenceSlider.setMinorTickSpacing(15);
        this.sequenceSlider.setPaintTicks(true);
        this.sequenceSlider.setValue(0);
        this.sequenceSlider.setPreferredSize(new Dimension(200, 32));
        this.sequenceSlider.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                SequencerPanel.this.sequenceSliderMouseDragged(evt);
            }
        });
        this.sequenceSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SequencerPanel.this.sequenceSliderMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SequencerPanel.this.sequenceSliderMouseReleased(evt);
            }
        });
        this.sequenceTotalTimeLabel.setText("00:00");
        this.stopButton.setText("\u23f9");
        this.stopButton.setToolTipText("Stop / Reset instruments");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencerPanel.this.stopButtonActionPerformed(evt);
            }
        });
        this.playButton.setFont(this.playButton.getFont().deriveFont((float)this.playButton.getFont().getSize() + 6.0f));
        this.playButton.setText(BTN_PLAY);
        this.playButton.setToolTipText("Play / Pause sequence playback");
        this.playButton.setMargin(new Insets(2, 14, 5, 14));
        this.playButton.setMaximumSize(new Dimension(49, 23));
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencerPanel.this.playButtonActionPerformed(evt);
            }
        });
        this.volumeSlider.setValue(100);
        this.volumeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SequencerPanel.this.volumeSliderStateChanged(evt);
            }
        });
        this.volumeSliderLabel.setText("100% Volume");
        this.volumeOverrideCB.setText("Overide MIDI Volume");
        this.volumeOverrideCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencerPanel.this.volumeOverrideCBActionPerformed(evt);
            }
        });
        this.midiInLabel.setText("MIDI In:");
        this.midiInLabel.setToolTipText("MIDI device to receive events from");
        this.midiInCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.midiInCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencerPanel.this.midiInCBActionPerformed(evt);
            }
        });
        this.midiOutLabel.setText("MIDI Out:");
        this.midiOutLabel.setToolTipText("MIDI device to send all raw MIDI events to.");
        this.midiOutCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.midiOutCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencerPanel.this.midiOutCBActionPerformed(evt);
            }
        });
        this.jLabel1.setText("BPM");
        this.tempoSpinner.setModel(new SpinnerNumberModel(Float.valueOf(120.0f), Float.valueOf(1.0f), Float.valueOf(990.0f), Float.valueOf(1.0f)));
        this.tempoSpinner.setToolTipText("Use scrollwheel to manually adjust tempo");
        this.tempoSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SequencerPanel.this.tempoSpinnerStateChanged(evt);
            }
        });
        this.tempoSpinner.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SequencerPanel.this.tempoSpinnerMouseWheelMoved(evt);
            }
        });
        GroupLayout controlsPaneLayout = new GroupLayout(this.controlsPane);
        this.controlsPane.setLayout(controlsPaneLayout);
        controlsPaneLayout.setHorizontalGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlsPaneLayout.createSequentialGroup().addContainerGap().addGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlsPaneLayout.createSequentialGroup().addComponent(this.sequenceCurrentTimeLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(controlsPaneLayout.createSequentialGroup().addGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlsPaneLayout.createSequentialGroup().addComponent(this.stopButton, -2, 49, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, controlsPaneLayout.createSequentialGroup().addComponent(this.sequenceSlider, -1, 317, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sequenceTotalTimeLabel)).addGroup(GroupLayout.Alignment.TRAILING, controlsPaneLayout.createSequentialGroup().addComponent(this.playButton, -2, 49, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.volumeSliderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeSlider, -2, 104, -2)))).addGroup(GroupLayout.Alignment.TRAILING, controlsPaneLayout.createSequentialGroup().addGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.midiInLabel).addComponent(this.midiOutLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.midiOutCB, -2, 190, -2).addComponent(this.midiInCB, -2, 190, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, controlsPaneLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, controlsPaneLayout.createSequentialGroup().addComponent(this.tempoSpinner, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1)).addComponent(this.volumeOverrideCB)))).addContainerGap()))));
        controlsPaneLayout.setVerticalGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlsPaneLayout.createSequentialGroup().addGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlsPaneLayout.createSequentialGroup().addComponent(this.sequenceTotalTimeLabel, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.volumeSlider, -2, -1, -2)).addGroup(controlsPaneLayout.createSequentialGroup().addComponent(this.sequenceCurrentTimeLabel, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.stopButton, -2, 26, -2).addComponent(this.playButton, -2, 26, -2))).addGroup(controlsPaneLayout.createSequentialGroup().addComponent(this.sequenceSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeSliderLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeOverrideCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tempoSpinner, -2, -1, -2)).addGap(3, 3, 3).addGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.midiInLabel).addComponent(this.midiInCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.midiOutLabel).addComponent(this.midiOutCB, -2, -1, -2)).addContainerGap(25, Short.MAX_VALUE)));
        this.playlistFilesList.setModel(this.playlistFilesModel);
        this.playlistFilesList.setToolTipText("Add files to the playlist...");
        this.playlistFilesList.setCellRenderer(new PlaylistCellRenderer());
        this.playlistFilesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SequencerPanel.this.playlistFilesListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.playlistFilesList);
        this.removeFileButton.setText("Remove File");
        this.removeFileButton.setEnabled(false);
        this.removeFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencerPanel.this.removeFileButtonActionPerformed(evt);
            }
        });
        this.autoResetCB.setText("Auto Reset");
        this.autoResetCB.setToolTipText("Resets the instruments when a sequence ends (when unchecked, use the Stop button to reset)");
        this.autoResetCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequencerPanel.this.autoResetCBActionPerformed(evt);
            }
        });
        this.repeatCheckbox.setText("Repeat");
        this.repeatCheckbox.setToolTipText("Repeats playlist after the last (or only) song has finished.");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.controlsPane, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.autoResetCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.repeatCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.removeFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadFileButton, -2, 86, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 55, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadFileButton).addComponent(this.removeFileButton).addComponent(this.autoResetCB).addComponent(this.repeatCheckbox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.controlsPane, -2, -1, -2)));
    }

    private void loadFileButtonActionPerformed(ActionEvent evt) {
        if (0 == this.sequenceFileChooser.showOpenDialog(this)) {
            File selectedFile = this.sequenceFileChooser.getSelectedFile();
            this.playlistFilesModel.addElement(selectedFile);
            MoppyPreferences.getConfiguration().setFileLoadDirectory(selectedFile.getParentFile().getAbsolutePath());
            MoppyPreferences.saveConfiguration();
        }
    }

    private void autoResetCBActionPerformed(ActionEvent evt) {
        if (this.midiSequencer != null) {
            this.midiSequencer.setAutoReset(this.autoResetCB.isSelected());
        }
        MoppyPreferences.getConfiguration().setAutoReset(this.autoResetCB.isSelected());
    }

    private void removeFileButtonActionPerformed(ActionEvent evt) {
        this.playlistFilesList.getSelectedValuesList().forEach(f -> this.playlistFilesModel.removeElement(f));
        this.loadedIndex = -1;
        this.removeFileButton.setEnabled(!this.playlistFilesList.isSelectionEmpty());
    }

    private void playlistFilesListMouseClicked(MouseEvent evt) {
        this.removeFileButton.setEnabled(!this.playlistFilesList.isSelectionEmpty() && !this.midiSequencer.isPlaying());
        if (evt.getClickCount() == 2) {
            this.loadSequence(this.playlistFilesList.getSelectedIndex());
            if (this.midiSequencer.isSequenceLoaded()) {
                this.midiSequencer.play();
            }
        }
    }

    private void midiOutCBActionPerformed(ActionEvent evt) {
        if (this.receiverSender == null) {
            return;
        }
        String selectedName = this.midiOutCB.getSelectedItem().toString();
        if (this.midiOutDevices.containsKey(selectedName)) {
            try {
                this.currentMidiOutDevice = MidiSystem.getMidiDevice(this.midiOutDevices.get(selectedName));
                this.currentMidiOutDevice.open();
                this.receiverSender.setMidiThru(MidiSystem.getMidiDevice(this.midiOutDevices.get(selectedName)).getReceiver());
            }
            catch (MidiUnavailableException ex) {
                Logger.getLogger(SequencerPanel.class.getName()).log(Level.SEVERE, null, ex);
                this.midiOutCB.setSelectedIndex(0);
            }
        } else {
            this.receiverSender.setMidiThru(null);
        }
    }

    private void midiInCBActionPerformed(ActionEvent evt) {
        if (this.currentMidiInDevice != null) {
            this.currentMidiInDevice.close();
        }
        if (this.receiverSender == null) {
            return;
        }
        String selectedName = this.midiInCB.getSelectedItem().toString();
        if (this.midiInDevices.containsKey(selectedName)) {
            try {
                this.currentMidiInDevice = MidiSystem.getMidiDevice(this.midiInDevices.get(selectedName));
                this.currentMidiInDevice.open();
                this.currentMidiInDevice.getTransmitter().setReceiver((Receiver)this.receiverSender);
            }
            catch (MidiUnavailableException ex) {
                Logger.getLogger(SequencerPanel.class.getName()).log(Level.SEVERE, null, ex);
                this.midiInCB.setSelectedIndex(0);
            }
        }
    }

    private void volumeOverrideCBActionPerformed(ActionEvent evt) {
        this.postProc.setOverrideVelocity(this.volumeOverrideCB.isSelected());
    }

    private void volumeSliderStateChanged(ChangeEvent evt) {
        this.volumeSliderLabel.setText(String.format("%s%% Volume", this.volumeSlider.getValue()));
        this.postProc.setVelocityMultiplier((double)this.volumeSlider.getValue() / 100.0);
    }

    private void playButtonActionPerformed(ActionEvent evt) {
        if (this.midiSequencer.isPlaying()) {
            this.midiSequencer.pause();
        } else if (!this.playlistFilesModel.isEmpty()) {
            if (!this.midiSequencer.isSequenceLoaded() || this.loadedIndex < 0) {
                this.loadSequence(0);
            }
            if (this.midiSequencer.isSequenceLoaded()) {
                this.midiSequencer.play();
            }
        }
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this.midiSequencer.stop();
    }

    private void sequenceSliderMouseReleased(MouseEvent evt) {
        this.sequenceSliderMouseDragged(evt);
        this.midiSequencer.play();
    }

    private void sequenceSliderMousePressed(MouseEvent evt) {
        this.midiSequencer.pause();
    }

    private void sequenceSliderMouseDragged(MouseEvent evt) {
        this.midiSequencer.setSecondsPosition((long)this.sequenceSlider.getValue());
        Duration length = Duration.ofSeconds(this.midiSequencer.getSecondsPosition());
        this.sequenceCurrentTimeLabel.setText(String.format(TIME_CODE_FORMAT, length.toMinutes(), length.getSeconds() % 60L));
    }

    private void tempoSpinnerMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getScrollType() == 0) {
            float newValue = Math.max(1.0f, ((Float)this.tempoSpinner.getValue()).floatValue() - (float)evt.getUnitsToScroll());
            if (evt.getUnitsToScroll() > 0 || this.tempoSpinner.getModel().getNextValue() != null) {
                this.midiSequencer.setTempo(newValue);
            }
        }
    }

    private void tempoSpinnerStateChanged(ChangeEvent evt) {
        this.midiSequencer.setTempo(((Float)this.tempoSpinner.getValue()).floatValue());
    }

    public void receiveUpdate(StatusUpdate update) {
        switch (update.getType()) {
            case SEQUENCE_LOAD: {
                Duration length = Duration.ofSeconds(this.midiSequencer.getSecondsLength());
                this.sequenceSlider.setMaximum((int)length.getSeconds());
                this.sequenceTotalTimeLabel.setText(String.format(TIME_CODE_FORMAT, length.toMinutes(), length.getSeconds() % 60L));
                break;
            }
            case SEQUENCE_START: {
                this.playButton.setText(BTN_PAUSE);
                this.sequenceProgressUpdateTimer.start();
                this.removeFileButton.setEnabled(false);
                break;
            }
            case SEQUENCE_END: {
                this.advanceSequence();
                break;
            }
            case SEQUENCE_STOPPED: {
                this.sequenceSlider.setValue(0);
                this.sequenceCurrentTimeLabel.setText(String.format(TIME_CODE_FORMAT, 0, 0));
            }
            case SEQUENCE_PAUSE: {
                this.playButton.setText(BTN_PLAY);
                this.sequenceProgressUpdateTimer.stop();
                break;
            }
            case SEQUENCE_TEMPO_CHANGE: {
                update.getData().ifPresent(newTempo -> this.tempoSpinner.setValue(Float.valueOf(((Float)newTempo).floatValue())));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (SEQUENCE_PROGRESS.equals(e.getActionCommand())) {
            Duration length = Duration.ofSeconds(this.midiSequencer.getSecondsPosition());
            this.sequenceSlider.setValue((int)length.getSeconds());
            this.sequenceCurrentTimeLabel.setText(String.format(TIME_CODE_FORMAT, length.toMinutes(), length.getSeconds() % 60L));
        }
    }

    private class PlaylistCellRenderer
    extends DefaultListCellRenderer {
        private PlaylistCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setText(((File)value).getName());
            return this;
        }
    }
}

