/*
 * Decompiled with CFR 0.152.
 */
package com.moppy.control.gui.netpanel;

import com.moppy.control.NetworkManager;
import com.moppy.control.gui.netpanel.BridgePanel;
import com.moppy.control.gui.netpanel.DevicePanel;
import com.moppy.core.comms.bridge.NetworkBridge;
import com.moppy.core.device.DeviceDescriptor;
import com.moppy.core.status.StatusConsumer;
import com.moppy.core.status.StatusUpdate;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class NetworkPanel
extends JPanel
implements StatusConsumer {
    private NetworkManager netManager;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel netBridgesPanel;
    private JPanel netDevicesPanel;

    public NetworkPanel() {
        this.initComponents();
    }

    public void setNetworkManager(NetworkManager netManager) {
        this.netManager = netManager;
        this.updateBridgesList();
    }

    private void updateBridgesList() {
        this.netBridgesPanel.removeAll();
        this.netManager.getAvailableNetworkBridges().entrySet().forEach(ab -> this.netBridgesPanel.add(new BridgePanel(this.netManager, (String)ab.getKey(), (NetworkBridge)ab.getValue())));
        this.netBridgesPanel.revalidate();
        this.netBridgesPanel.repaint();
    }

    private void updateDevicesList() {
        this.netDevicesPanel.removeAll();
        this.netManager.getRecentlySeenDevices().forEach(device -> this.netDevicesPanel.add(new DevicePanel((DeviceDescriptor)device)));
        this.netDevicesPanel.revalidate();
        this.netDevicesPanel.repaint();
    }

    public void receiveUpdate(StatusUpdate update) {
        switch (update.getType()) {
            case NET_STATUS_CHANGED: {
                this.updateBridgesList();
                break;
            }
            case NET_DEVICES_CHANGED: {
                this.updateDevicesList();
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.netBridgesPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.netDevicesPanel = new JPanel();
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.netBridgesPanel.setLayout(new BoxLayout(this.netBridgesPanel, 1));
        this.jScrollPane1.setViewportView(this.netBridgesPanel);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont((float)this.jLabel1.getFont().getSize() + 2.0f));
        this.jLabel1.setText("Network Bridges");
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.netDevicesPanel.setLayout(new BoxLayout(this.netDevicesPanel, 1));
        this.jScrollPane2.setViewportView(this.netDevicesPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 211, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 350, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jScrollPane1, -1, 327, Short.MAX_VALUE)).addContainerGap()));
    }
}

