/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.ErrorStackTraceLimitNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.RealmNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSRealm;

public abstract class ErrorStackTraceLimitNode
extends JavaScriptBaseNode {
    @Node.Child
    private RealmNode realmNode;
    @Node.Child
    private PropertyGetNode getStackTraceLimit;
    @Node.Child
    private JSToIntegerAsIntNode toInteger;

    protected ErrorStackTraceLimitNode(JSContext context) {
        this.realmNode = RealmNode.create(context);
        this.getStackTraceLimit = PropertyGetNode.create("stackTraceLimit", false, context);
        this.toInteger = JSToIntegerAsIntNode.create();
    }

    public static ErrorStackTraceLimitNode create(JSContext context) {
        return ErrorStackTraceLimitNodeGen.create(context);
    }

    @Specialization
    public int doInt(VirtualFrame frame) {
        JSRealm realm = this.realmNode.execute(frame);
        DynamicObject errorConstructor = realm.getErrorConstructor(JSErrorType.Error);
        return Math.max(0, this.toInteger.executeInt(this.getStackTraceLimit.getValue(errorConstructor)));
    }

    public abstract int executeInt(VirtualFrame var1);
}

