/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.lazy.layout.LazyLayoutBeyondBoundsState;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.ui.layout.Remeasurement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/compose/foundation/pager/PagerBeyondBoundsState;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutBeyondBoundsState;", "state", "Landroidx/compose/foundation/pager/PagerState;", "beyondBoundsPageCount", "", "(Landroidx/compose/foundation/pager/PagerState;I)V", "firstPlacedIndex", "getFirstPlacedIndex", "()I", "hasVisibleItems", "", "getHasVisibleItems", "()Z", "itemCount", "getItemCount", "lastPlacedIndex", "getLastPlacedIndex", "remeasure", "", "foundation"})
public final class PagerBeyondBoundsState
implements LazyLayoutBeyondBoundsState {
    @NotNull
    private final PagerState state;
    private final int beyondBoundsPageCount;

    public PagerBeyondBoundsState(@NotNull PagerState state, int beyondBoundsPageCount) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.beyondBoundsPageCount = beyondBoundsPageCount;
    }

    @Override
    public void remeasure() {
        block0: {
            Remeasurement remeasurement = this.state.getRemeasurement$foundation();
            if (remeasurement == null) break block0;
            remeasurement.forceRemeasure();
        }
    }

    @Override
    public int getItemCount() {
        return this.state.getLayoutInfo$foundation().getPagesCount();
    }

    @Override
    public boolean getHasVisibleItems() {
        return !((Collection)this.state.getLayoutInfo$foundation().getVisiblePagesInfo()).isEmpty();
    }

    @Override
    public int getFirstPlacedIndex() {
        return Math.max(0, this.state.getFirstVisiblePage$foundation() - this.beyondBoundsPageCount);
    }

    @Override
    public int getLastPlacedIndex() {
        return Math.min(this.getItemCount() - 1, ((PageInfo)CollectionsKt.last(this.state.getLayoutInfo$foundation().getVisiblePagesInfo())).getIndex() + this.beyondBoundsPageCount);
    }
}

