/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.platform.ViewConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eJ\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/compose/foundation/text/selection/ClicksCounter;", "", "viewConfiguration", "Landroidx/compose/ui/platform/ViewConfiguration;", "clicksSlop", "", "(Landroidx/compose/ui/platform/ViewConfiguration;F)V", "clicks", "", "getClicks", "()I", "setClicks", "(I)V", "prevClick", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "getPrevClick", "()Landroidx/compose/ui/input/pointer/PointerInputChange;", "setPrevClick", "(Landroidx/compose/ui/input/pointer/PointerInputChange;)V", "positionIsTolerable", "", "newClick", "timeIsTolerable", "update", "", "event", "foundation"})
public final class ClicksCounter {
    @NotNull
    private final ViewConfiguration viewConfiguration;
    private final float clicksSlop;
    private int clicks;
    @Nullable
    private PointerInputChange prevClick;

    public ClicksCounter(@NotNull ViewConfiguration viewConfiguration, float clicksSlop) {
        Intrinsics.checkNotNullParameter((Object)viewConfiguration, (String)"viewConfiguration");
        this.viewConfiguration = viewConfiguration;
        this.clicksSlop = clicksSlop;
    }

    public final int getClicks() {
        return this.clicks;
    }

    public final void setClicks(int n) {
        this.clicks = n;
    }

    @Nullable
    public final PointerInputChange getPrevClick() {
        return this.prevClick;
    }

    public final void setPrevClick(@Nullable PointerInputChange pointerInputChange) {
        this.prevClick = pointerInputChange;
    }

    public final void update(@NotNull PointerInputChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PointerInputChange currentPrevEvent = this.prevClick;
        this.clicks = currentPrevEvent != null && this.timeIsTolerable(currentPrevEvent, event) && this.positionIsTolerable(currentPrevEvent, event) ? ++this.clicks : 1;
        this.prevClick = event;
    }

    public final boolean timeIsTolerable(@NotNull PointerInputChange prevClick, @NotNull PointerInputChange newClick) {
        Intrinsics.checkNotNullParameter((Object)prevClick, (String)"prevClick");
        Intrinsics.checkNotNullParameter((Object)newClick, (String)"newClick");
        long diff = newClick.getUptimeMillis() - prevClick.getUptimeMillis();
        return diff < this.viewConfiguration.getDoubleTapTimeoutMillis();
    }

    public final boolean positionIsTolerable(@NotNull PointerInputChange prevClick, @NotNull PointerInputChange newClick) {
        Intrinsics.checkNotNullParameter((Object)prevClick, (String)"prevClick");
        Intrinsics.checkNotNullParameter((Object)newClick, (String)"newClick");
        long diff = Offset.minus-MK-Hz9U((long)newClick.getPosition-F1C5BW0(), (long)prevClick.getPosition-F1C5BW0());
        return Offset.getDistance-impl((long)diff) < this.clicksSlop;
    }
}

