/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSink;
import kotlinx.io.Segment;
import kotlinx.io.SegmentPool;
import kotlinx.io._UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkotlinx/io/OutputStreamSink;", "Lkotlinx/io/RawSink;", "out", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "close", "", "flush", "toString", "", "write", "source", "Lkotlinx/io/Buffer;", "byteCount", "", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nJvmCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCore.kt\nkotlinx/io/OutputStreamSink\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,118:1\n109#2:119\n*S KotlinDebug\n*F\n+ 1 JvmCore.kt\nkotlinx/io/OutputStreamSink\n*L\n47#1:119\n*E\n"})
class OutputStreamSink
implements RawSink {
    @NotNull
    private final OutputStream out;

    public OutputStreamSink(@NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
    }

    @Override
    public void write(@NotNull Buffer source, long byteCount) {
        int toCopy;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        _UtilKt.checkOffsetAndCount(source.getSize(), 0L, byteCount);
        for (long remaining = byteCount; remaining > 0L; remaining -= (long)toCopy) {
            Segment head;
            Intrinsics.checkNotNull((Object)source.head);
            int b$iv = head.limit - head.pos;
            boolean $i$f$minOf = false;
            toCopy = (int)Math.min(remaining, (long)b$iv);
            this.out.write(head.data, head.pos, toCopy);
            head.pos += toCopy;
            source.setSize$kotlinx_io_core(source.getSize() - (long)toCopy);
            if (head.pos != head.limit) continue;
            source.head = head.pop();
            SegmentPool.recycle(head);
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
    }

    @NotNull
    public String toString() {
        return "RawSink(" + this.out + ')';
    }
}

