/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.awt.font;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.FontStyle;
import org.jetbrains.skia.Typeface;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u0000 52\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u000256B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003J\u0011\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0002H\u0096\u0001J\u0011\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0003H\u0096\u0001J\u0010\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0013\u0010,\u001a\u0004\u0018\u00010\u00032\u0006\u0010(\u001a\u00020\u0002H\u0096\u0003J\t\u0010-\u001a\u00020'H\u0096\u0001J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0002H\u0086\u0002J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u0011\u00100\u001a\u00020$2\u0006\u0010/\u001a\u00020\u0002H\u0086\u0002J\u0011\u00100\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u0011\u00101\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u0011\u00102\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u000e\u00103\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003J\u000e\u00104\u001a\u00020$2\u0006\u0010/\u001a\u00020\u0002R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR$\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00130\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0012\u0010\u0019\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00067"}, d2={"Lorg/jetbrains/skiko/awt/font/FontFamily;", "", "Lorg/jetbrains/skia/FontStyle;", "Lorg/jetbrains/skia/Typeface;", "familyName", "", "source", "Lorg/jetbrains/skiko/awt/font/FontFamily$FontFamilySource;", "typefacesByStyle", "", "(Ljava/lang/String;Lorg/jetbrains/skiko/awt/font/FontFamily$FontFamilySource;Ljava/util/Map;)V", "availableStyles", "", "getAvailableStyles", "()Ljava/util/Set;", "availableTypefaces", "", "getAvailableTypefaces", "entries", "", "getEntries", "getFamilyName", "()Ljava/lang/String;", "keys", "getKeys", "size", "", "getSize", "()I", "getSource", "()Lorg/jetbrains/skiko/awt/font/FontFamily$FontFamilySource;", "values", "", "getValues", "()Ljava/util/Collection;", "addTypeface", "", "typeface", "containsKey", "", "key", "containsValue", "value", "ensureTypefaceIsCompatible", "get", "isEmpty", "minus", "style", "minusAssign", "plus", "plusAssign", "removeTypeface", "removeTypefaceByStyle", "Companion", "FontFamilySource", "skiko"})
@SourceDebugExtension(value={"SMAP\nFontFamily.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontFamily.kt\norg/jetbrains/skiko/awt/font/FontFamily\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class FontFamily
implements Map<FontStyle, Typeface>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String familyName;
    @NotNull
    private final FontFamilySource source;
    @NotNull
    private final Map<FontStyle, Typeface> typefacesByStyle;

    public FontFamily(@NotNull String familyName, @NotNull FontFamilySource source, @NotNull Map<FontStyle, Typeface> typefacesByStyle) {
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter(typefacesByStyle, (String)"typefacesByStyle");
        this.familyName = familyName;
        this.source = source;
        this.typefacesByStyle = typefacesByStyle;
        if (!(!StringsKt.isBlank((CharSequence)this.familyName))) {
            boolean bl = false;
            String string = "The font family name must not be blank";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ FontFamily(String string, FontFamilySource fontFamilySource, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = new LinkedHashMap();
        }
        this(string, fontFamilySource, map);
    }

    @NotNull
    public final String getFamilyName() {
        return this.familyName;
    }

    @NotNull
    public final FontFamilySource getSource() {
        return this.source;
    }

    @NotNull
    public Set<Map.Entry<FontStyle, Typeface>> getEntries() {
        return this.typefacesByStyle.entrySet();
    }

    @NotNull
    public Set<FontStyle> getKeys() {
        return this.typefacesByStyle.keySet();
    }

    public int getSize() {
        return this.typefacesByStyle.size();
    }

    @NotNull
    public Collection<Typeface> getValues() {
        return this.typefacesByStyle.values();
    }

    public boolean containsKey(@NotNull FontStyle key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.typefacesByStyle.containsKey(key);
    }

    public boolean containsValue(@NotNull Typeface value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.typefacesByStyle.containsValue(value);
    }

    @Nullable
    public Typeface get(@NotNull FontStyle key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.typefacesByStyle.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.typefacesByStyle.isEmpty();
    }

    @NotNull
    public final Set<FontStyle> getAvailableStyles() {
        return this.typefacesByStyle.keySet();
    }

    @NotNull
    public final Set<Typeface> getAvailableTypefaces() {
        return CollectionsKt.toSet((Iterable)this.typefacesByStyle.values());
    }

    @NotNull
    public final FontFamily plus(@NotNull Typeface typeface) {
        FontFamily fontFamily;
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        FontFamily $this$plus_u24lambda_u241 = fontFamily = new FontFamily(this.familyName, this.source, MapsKt.toMutableMap(this.typefacesByStyle));
        boolean bl = false;
        $this$plus_u24lambda_u241.addTypeface(typeface);
        return fontFamily;
    }

    public final void plusAssign(@NotNull Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        this.addTypeface(typeface);
    }

    public final void addTypeface(@NotNull Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        this.ensureTypefaceIsCompatible(typeface);
        Map<FontStyle, Typeface> map = this.typefacesByStyle;
        Pair pair = TuplesKt.to((Object)typeface.getFontStyle(), (Object)typeface);
        map.put((FontStyle)pair.getFirst(), (Typeface)pair.getSecond());
    }

    public final void minusAssign(@NotNull Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        this.removeTypeface(typeface);
    }

    @NotNull
    public final FontFamily minus(@NotNull Typeface typeface) {
        FontFamily fontFamily;
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        FontFamily $this$minus_u24lambda_u242 = fontFamily = new FontFamily(this.familyName, this.source, MapsKt.toMutableMap(this.typefacesByStyle));
        boolean bl = false;
        $this$minus_u24lambda_u242.removeTypeface(typeface);
        return fontFamily;
    }

    public final void minusAssign(@NotNull FontStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.removeTypefaceByStyle(style);
    }

    @NotNull
    public final FontFamily minus(@NotNull FontStyle style) {
        FontFamily fontFamily;
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        FontFamily $this$minus_u24lambda_u243 = fontFamily = new FontFamily(this.familyName, this.source, MapsKt.toMutableMap(this.typefacesByStyle));
        boolean bl = false;
        $this$minus_u24lambda_u243.removeTypefaceByStyle(style);
        return fontFamily;
    }

    public final void removeTypeface(@NotNull Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        if (this.typefacesByStyle.isEmpty()) {
            return;
        }
        FontStyle style = typeface.getFontStyle();
        this.ensureTypefaceIsCompatible(typeface);
        this.typefacesByStyle.remove(style);
    }

    private final void ensureTypefaceIsCompatible(Typeface typeface) {
        String candidateName = typeface.getFamilyName();
        if (!StringsKt.equals((String)this.familyName, (String)candidateName, (boolean)true)) {
            boolean bl = false;
            String string = "The provided typeface " + typeface + " is not compatible with this font family, '" + this.familyName + '\'';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void removeTypefaceByStyle(@NotNull FontStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.typefacesByStyle.remove(style);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Typeface compute(FontStyle p0, BiFunction<? super FontStyle, ? super Typeface, ? extends Typeface> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Typeface computeIfAbsent(FontStyle p0, Function<? super FontStyle, ? extends Typeface> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Typeface computeIfPresent(FontStyle p0, BiFunction<? super FontStyle, ? super Typeface, ? extends Typeface> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Typeface merge(FontStyle p0, Typeface p1, BiFunction<? super Typeface, ? super Typeface, ? extends Typeface> p2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Typeface put(FontStyle key, Typeface value) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void putAll(Map<? extends FontStyle, ? extends Typeface> from) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Typeface putIfAbsent(FontStyle p0, Typeface p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Typeface remove(Object key) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean replace(FontStyle p0, Typeface p1, Typeface p2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Typeface replace(FontStyle p0, Typeface p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(BiFunction<? super FontStyle, ? super Typeface, ? extends Typeface> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\u0004J/\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/skiko/awt/font/FontFamily$Companion;", "", "()V", "closestStyle", "Lorg/jetbrains/skia/FontStyle;", "iterable", "", "style", "fromTypefaces", "Lorg/jetbrains/skiko/awt/font/FontFamily;", "familyName", "", "source", "Lorg/jetbrains/skiko/awt/font/FontFamily$FontFamilySource;", "typefaces", "", "Lorg/jetbrains/skia/Typeface;", "(Ljava/lang/String;Lorg/jetbrains/skiko/awt/font/FontFamily$FontFamilySource;[Lorg/jetbrains/skia/Typeface;)Lorg/jetbrains/skiko/awt/font/FontFamily;", "skiko"})
    @SourceDebugExtension(value={"SMAP\nFontFamily.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontFamily.kt\norg/jetbrains/skiko/awt/font/FontFamily$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1002#2,2:160\n1002#2,2:163\n1002#2,2:165\n1#3:162\n*S KotlinDebug\n*F\n+ 1 FontFamily.kt\norg/jetbrains/skiko/awt/font/FontFamily$Companion\n*L\n143#1:160,2\n147#1:163,2\n151#1:165,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontFamily fromTypefaces(@NotNull String familyName, @NotNull FontFamilySource source, Typeface ... typefaces) {
            Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)typefaces, (String)"typefaces");
            if (typefaces.length == 0) {
                return new FontFamily(familyName, source, null, 4, null);
            }
            HashMap map = new HashMap(typefaces.length);
            for (Typeface typeface : typefaces) {
                if (!StringsKt.equals((String)typeface.getFamilyName(), (String)familyName, (boolean)true)) {
                    boolean $i$a$-require-FontFamily$Companion$fromTypefaces$32 = false;
                    String $i$a$-require-FontFamily$Companion$fromTypefaces$32 = "Not all provided typefaces are compatible with the family name (expected: '" + familyName + "', found: " + typeface + ')';
                    throw new IllegalArgumentException($i$a$-require-FontFamily$Companion$fromTypefaces$32.toString());
                }
                if (!(!map.keySet().contains(typeface.getFontStyle()))) {
                    boolean bl = false;
                    String string = "Trying to add a typeface for style " + typeface.getFontStyle() + ", but it already exists.";
                    throw new IllegalArgumentException(string.toString());
                }
                ((Map)map).put(typeface.getFontStyle(), typeface);
            }
            return new FontFamily(familyName, source, map);
        }

        @Nullable
        public final FontStyle closestStyle(@NotNull Iterable<FontStyle> iterable, @NotNull FontStyle style) {
            FontStyle fontStyle;
            Object v4;
            List keys;
            block11: {
                FontStyle fontStyle2;
                Object v2;
                Object object;
                Object object22;
                block10: {
                    FontStyle fontStyle3;
                    Object v0;
                    block9: {
                        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
                        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                        List $this$sortBy$iv = keys = CollectionsKt.toMutableList(iterable);
                        boolean $i$f$sortBy = false;
                        if ($this$sortBy$iv.size() > 1) {
                            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                                public final int compare(T a, T b) {
                                    FontStyle it = (FontStyle)a;
                                    boolean bl = false;
                                    Comparable comparable = Integer.valueOf(it.getWeight());
                                    it = (FontStyle)b;
                                    Comparable comparable2 = comparable;
                                    bl = false;
                                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getWeight()));
                                }
                            });
                        }
                        Iterable iterable2 = keys;
                        for (Object object22 : iterable2) {
                            FontStyle it = (FontStyle)object22;
                            boolean bl = false;
                            if (!(it.getWeight() >= style.getWeight())) continue;
                            v0 = object22;
                            break block9;
                        }
                        v0 = null;
                    }
                    if ((fontStyle3 = (FontStyle)v0) == null) {
                        fontStyle3 = (FontStyle)CollectionsKt.lastOrNull((List)keys);
                    }
                    FontStyle closeByWight = fontStyle3;
                    CollectionsKt.retainAll((List)keys, (Function1)((Function1)new Function1<FontStyle, Boolean>(closeByWight){
                        final /* synthetic */ FontStyle $closeByWight;
                        {
                            this.$closeByWight = $closeByWight;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull FontStyle it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            FontStyle fontStyle = this.$closeByWight;
                            return fontStyle != null ? it.getWeight() == fontStyle.getWeight() : false;
                        }
                    }));
                    List $this$sortBy$iv = keys;
                    boolean $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() > 1) {
                        CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                FontStyle it = (FontStyle)a;
                                boolean bl = false;
                                Comparable comparable = Integer.valueOf(it.getWidth());
                                it = (FontStyle)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getWidth()));
                            }
                        });
                    }
                    Iterable iterable3 = keys;
                    object22 = iterable3.iterator();
                    while (object22.hasNext()) {
                        object = object22.next();
                        FontStyle it = (FontStyle)object;
                        boolean bl = false;
                        if (!(it.getWidth() >= style.getWidth())) continue;
                        v2 = object;
                        break block10;
                    }
                    v2 = null;
                }
                if ((fontStyle2 = (FontStyle)v2) == null) {
                    fontStyle2 = (FontStyle)CollectionsKt.lastOrNull((List)keys);
                }
                FontStyle closeByWidth = fontStyle2;
                CollectionsKt.retainAll((List)keys, (Function1)((Function1)new Function1<FontStyle, Boolean>(closeByWidth){
                    final /* synthetic */ FontStyle $closeByWidth;
                    {
                        this.$closeByWidth = $closeByWidth;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull FontStyle it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        FontStyle fontStyle = this.$closeByWidth;
                        return fontStyle != null ? it.getWidth() == fontStyle.getWidth() : false;
                    }
                }));
                List $this$sortBy$iv = keys;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            FontStyle it = (FontStyle)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getSlant());
                            it = (FontStyle)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSlant())));
                        }
                    });
                }
                object22 = keys;
                object = object22.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    FontStyle it = (FontStyle)e;
                    boolean bl = false;
                    if (!(it.getSlant().compareTo((Enum)style.getSlant()) >= 0)) continue;
                    v4 = e;
                    break block11;
                }
                v4 = null;
            }
            if ((fontStyle = (FontStyle)v4) == null) {
                fontStyle = (FontStyle)CollectionsKt.lastOrNull((List)keys);
            }
            FontStyle closeBySlant = fontStyle;
            CollectionsKt.retainAll((List)keys, (Function1)((Function1)new Function1<FontStyle, Boolean>(closeBySlant){
                final /* synthetic */ FontStyle $closeBySlant;
                {
                    this.$closeBySlant = $closeBySlant;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull FontStyle it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    FontStyle fontStyle = this.$closeBySlant;
                    return it.getSlant() == (fontStyle != null ? fontStyle.getSlant() : null);
                }
            }));
            return (FontStyle)CollectionsKt.firstOrNull((List)keys);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/skiko/awt/font/FontFamily$FontFamilySource;", "", "(Ljava/lang/String;I)V", "System", "JvmEmbedded", "Custom", "skiko"})
    public static final class FontFamilySource
    extends Enum<FontFamilySource> {
        public static final /* enum */ FontFamilySource System = new FontFamilySource();
        public static final /* enum */ FontFamilySource JvmEmbedded = new FontFamilySource();
        public static final /* enum */ FontFamilySource Custom = new FontFamilySource();
        private static final /* synthetic */ FontFamilySource[] $VALUES;

        public static FontFamilySource[] values() {
            return (FontFamilySource[])$VALUES.clone();
        }

        public static FontFamilySource valueOf(String value) {
            return Enum.valueOf(FontFamilySource.class, value);
        }

        static {
            $VALUES = fontFamilySourceArray = new FontFamilySource[]{FontFamilySource.System, FontFamilySource.JvmEmbedded, FontFamilySource.Custom};
        }
    }
}

