/*
 * Decompiled with CFR 0.152.
 */
package audio;

import androidx.compose.runtime.internal.StabilityInferred;
import io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io.Utf8Kt;
import org.jetbrains.annotations.NotNull;
import util.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J,\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J\f\u0010\u0015\u001a\u00020\u0012*\u00020\rH\u0002\u00a8\u0006\u0016"}, d2={"Laudio/WavReader;", "", "()V", "read", "", "", "Laudio/WavData;", "file", "Lio/File;", "(Lio/File;)[[F", "readFloatingSample", "", "source", "Lkotlinx/io/Source;", "bitsPerSample", "", "onRead", "Lkotlin/Function1;", "", "", "readPcmSample", "read3BytesLe", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWavReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WavReader.kt\naudio/WavReader\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,174:1\n37#2,2:175\n*S KotlinDebug\n*F\n+ 1 WavReader.kt\naudio/WavReader\n*L\n127#1:175,2\n*E\n"})
public final class WavReader {
    public static final int $stable;

    @NotNull
    public final float[][] read(@NotNull File file) {
        List list;
        int restChunk1IdSize;
        short audioFormat;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Source source = file.source();
        String chunkId = Utf8Kt.readString((Source)source, (long)4L);
        int chunkSize = SourcesKt.readIntLe((Source)source);
        String format = Utf8Kt.readString((Source)source, (long)4L);
        if (!Intrinsics.areEqual((Object)chunkId, (Object)"RIFF")) {
            boolean $i$a$-require-WavReader$read$52 = false;
            String $i$a$-require-WavReader$read$52 = "Invalid WAV file: chunkId: " + chunkId;
            throw new IllegalArgumentException($i$a$-require-WavReader$read$52.toString());
        }
        if (!Intrinsics.areEqual((Object)format, (Object)"WAVE")) {
            boolean $i$a$-require-WavReader$read$62 = false;
            String $i$a$-require-WavReader$read$62 = "Invalid WAV file: format: " + format;
            throw new IllegalArgumentException($i$a$-require-WavReader$read$62.toString());
        }
        String subchunk1Id = Utf8Kt.readString((Source)source, (long)4L);
        while (!Intrinsics.areEqual((Object)subchunk1Id, (Object)"fmt ")) {
            source.skip((long)SourcesKt.readIntLe((Source)source));
            subchunk1Id = Utf8Kt.readString((Source)source, (long)4L);
        }
        int subchunk1Size = SourcesKt.readIntLe((Source)source);
        int readSize = 0;
        short resolvedAudioFormat = audioFormat = SourcesKt.readShortLe((Source)source);
        readSize += 2;
        int numChannels = SourcesKt.readShortLe((Source)source);
        readSize += 2;
        int sampleRate = SourcesKt.readIntLe((Source)source);
        readSize += 4;
        int byteRate = SourcesKt.readIntLe((Source)source);
        readSize += 4;
        short blockAlign = SourcesKt.readShortLe((Source)source);
        readSize += 2;
        short bitsPerSample = SourcesKt.readShortLe((Source)source);
        readSize += 2;
        if (audioFormat == -2) {
            short cbSize = SourcesKt.readShortLe((Source)source);
            switch (cbSize) {
                case 0: {
                    readSize += 2;
                    break;
                }
                case 22: {
                    readSize += 2;
                    short validBitsPerSample = SourcesKt.readShortLe((Source)source);
                    readSize += 2;
                    int channelMask = SourcesKt.readIntLe((Source)source);
                    readSize += 4;
                    resolvedAudioFormat = SourcesKt.readShortLe((Source)source);
                    source.skip(14L);
                    readSize += 16;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported cbSize: " + cbSize);
                }
            }
        }
        if ((restChunk1IdSize = subchunk1Size - readSize) > 0) {
            source.skip((long)restChunk1IdSize);
        }
        int expectedByteRate = sampleRate * numChannels * bitsPerSample / 8;
        int expectedBlockAlign = numChannels * bitsPerSample / 8;
        if (expectedByteRate != byteRate) {
            Log.INSTANCE.w("Unexpected byte rate: " + byteRate + ", expected: " + expectedByteRate);
        }
        if (expectedBlockAlign != blockAlign) {
            Log.INSTANCE.w("Unexpected block align: " + blockAlign + ", expected: " + expectedBlockAlign);
        }
        Object[] objectArray = new Integer[]{44100, 48000, 96000};
        List supportedSampleRate = CollectionsKt.listOf((Object[])objectArray);
        if (!supportedSampleRate.contains(sampleRate)) {
            boolean $i$a$-require-WavReader$read$72 = false;
            String $i$a$-require-WavReader$read$72 = "Unsupported sample rate: " + sampleRate;
            throw new IllegalArgumentException($i$a$-require-WavReader$read$72.toString());
        }
        short $i$a$-require-WavReader$read$72 = resolvedAudioFormat;
        if ($i$a$-require-WavReader$read$72 == 1) {
            Object[] objectArray2 = new Integer[]{8, 16, 24, 32};
            list = CollectionsKt.listOf((Object[])objectArray2);
        } else if ($i$a$-require-WavReader$read$72 == 3) {
            list = CollectionsKt.listOf((Object)32);
        } else {
            throw new IllegalArgumentException("Unsupported resolved audio format: " + resolvedAudioFormat);
        }
        List supportedBitDepths = list;
        if (!supportedBitDepths.contains(bitsPerSample)) {
            boolean $i$a$-require-WavReader$read$82 = false;
            String $i$a$-require-WavReader$read$82 = "Unsupported bit depth: " + bitsPerSample;
            throw new IllegalArgumentException($i$a$-require-WavReader$read$82.toString());
        }
        String subchunk2Id = Utf8Kt.readString((Source)source, (long)4L);
        while (!Intrinsics.areEqual((Object)subchunk2Id, (Object)"data")) {
            source.skip((long)SourcesKt.readIntLe((Source)source));
            subchunk2Id = Utf8Kt.readString((Source)source, (long)4L);
        }
        int subchunk2Size = SourcesKt.readIntLe((Source)source);
        List data = new ArrayList();
        Ref.IntRef read2 = new Ref.IntRef();
        float[] channelBuffer = new float[numChannels];
        Function1 onRead2 = (Function1)new Function1<Integer, Unit>(read2){
            final /* synthetic */ Ref.IntRef $read;
            {
                this.$read = $read;
                super(1);
            }

            public final void invoke(int byteCount) {
                this.$read.element += byteCount;
            }
        };
        while (read2.element < subchunk2Size) {
            int n = numChannels;
            for (int i = 0; i < n; ++i) {
                float value;
                float f;
                short s = resolvedAudioFormat;
                if (s == 1) {
                    f = this.readPcmSample(source, bitsPerSample, (Function1<? super Integer, Unit>)onRead2);
                } else if (s == 3) {
                    f = this.readFloatingSample(source, bitsPerSample, (Function1<? super Integer, Unit>)onRead2);
                } else {
                    throw new IllegalArgumentException("Unsupported audio format: " + audioFormat);
                }
                channelBuffer[i] = value = f;
            }
            data.add(ArraysKt.toFloatArray((Float[])ArraysKt.toTypedArray((float[])channelBuffer)));
        }
        source.close();
        Collection $this$toTypedArray$iv = data;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (float[][])thisCollection$iv.toArray((T[])new float[0][]);
    }

    private final float readPcmSample(Source source, short bitsPerSample, Function1<? super Integer, Unit> onRead2) {
        return switch (bitsPerSample) {
            case 8 -> {
                onRead2.invoke((Object)1);
                yield (float)((SourcesKt.readUByte((Source)source) & 0xFF) - 128) / 128.0f;
            }
            case 16 -> {
                onRead2.invoke((Object)2);
                yield (float)SourcesKt.readShortLe((Source)source) / (float)Short.MAX_VALUE;
            }
            case 24 -> {
                onRead2.invoke((Object)3);
                yield (float)this.read3BytesLe(source) / 8388607.0f;
            }
            case 32 -> {
                onRead2.invoke((Object)4);
                yield (float)SourcesKt.readIntLe((Source)source) / (float)Integer.MAX_VALUE;
            }
            default -> throw new IllegalArgumentException("Unsupported bit depth: " + bitsPerSample);
        };
    }

    private final float readFloatingSample(Source source, short bitsPerSample, Function1<? super Integer, Unit> onRead2) {
        if (bitsPerSample != 32) {
            throw new IllegalArgumentException("Unsupported bit depth: " + bitsPerSample);
        }
        onRead2.invoke((Object)4);
        return SourcesKt.readFloatLe((Source)source);
    }

    private final int read3BytesLe(Source $this$read3BytesLe) {
        byte byte1 = $this$read3BytesLe.readByte();
        byte byte2 = $this$read3BytesLe.readByte();
        byte byte3 = $this$read3BytesLe.readByte();
        return byte1 | byte2 << 8 | byte3 << 16;
    }
}

