/*
 * Decompiled with CFR 0.152.
 */
package io;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import io.ExportDataRequest;
import io.File;
import java.awt.Desktop;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui.common.AlertDialogController;
import ui.common.FileDialogResult;
import ui.common.OpenFileDialogRequest;
import ui.common.ToastController;
import ui.model.AppContext;
import util.JavaFileKt;
import util.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J>\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0004\u0012\u00020\u00130\u001c2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001dR/\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lio/FileInteractor;", "", "context", "Lui/model/AppContext;", "toastController", "Lui/common/ToastController;", "alertDialogController", "Lui/common/AlertDialogController;", "(Lui/model/AppContext;Lui/common/ToastController;Lui/common/AlertDialogController;)V", "<set-?>", "Lui/common/FileDialogResult;", "fileDialogRequest", "getFileDialogRequest", "()Lui/common/FileDialogResult;", "setFileDialogRequest", "(Lui/common/FileDialogResult;)V", "fileDialogRequest$delegate", "Landroidx/compose/runtime/MutableState;", "exportData", "", "request", "Lio/ExportDataRequest;", "pickFile", "title", "", "allowedExtensions", "", "onFinish", "Lkotlin/Function1;", "Lio/File;", "initialDirectory", "requestOpenFolder", "folder", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFileInteractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileInteractor.kt\nio/FileInteractor\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,62:1\n81#2:63\n107#2,2:64\n*S KotlinDebug\n*F\n+ 1 FileInteractor.kt\nio/FileInteractor\n*L\n30#1:63\n30#1:64,2\n*E\n"})
public final class FileInteractor {
    @NotNull
    private final MutableState fileDialogRequest$delegate;
    public static final int $stable;

    public FileInteractor(@NotNull AppContext context, @NotNull ToastController toastController, @NotNull AlertDialogController alertDialogController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)toastController, (String)"toastController");
        Intrinsics.checkNotNullParameter((Object)alertDialogController, (String)"alertDialogController");
        this.fileDialogRequest$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
    }

    public final void requestOpenFolder(@NotNull File folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        if (folder.isDirectory()) {
            Desktop.getDesktop().open(JavaFileKt.toJavaFile(folder));
        } else {
            Log.INSTANCE.e("FileInteractor.requestOpenFolder: " + folder.getAbsolutePath() + " is not a directory");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FileDialogResult getFileDialogRequest() {
        void $this$getValue$iv;
        State state = (State)this.fileDialogRequest$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (FileDialogResult)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setFileDialogRequest(FileDialogResult fileDialogResult) {
        void $this$setValue$iv;
        MutableState mutableState = this.fileDialogRequest$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)fileDialogResult);
    }

    public final void pickFile(@NotNull String title, @NotNull List<String> allowedExtensions, @NotNull Function1<? super File, Unit> onFinish, @Nullable File initialDirectory) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(allowedExtensions, (String)"allowedExtensions");
        Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
        File file = initialDirectory;
        String string = file != null ? file.getAbsolutePath() : null;
        boolean bl = Intrinsics.areEqual((Object)CollectionsKt.singleOrNull(allowedExtensions), (Object)"");
        this.setFileDialogRequest(new OpenFileDialogRequest(title, string, null, allowedExtensions, bl, (Function2)new Function2<String, String, Unit>(this, onFinish){
            final /* synthetic */ FileInteractor this$0;
            final /* synthetic */ Function1<File, Unit> $onFinish;
            {
                this.this$0 = $receiver;
                this.$onFinish = $onFinish;
                super(2);
            }

            public final void invoke(@Nullable String parent, @Nullable String name) {
                if (parent == null || name == null) {
                    FileInteractor.access$setFileDialogRequest(this.this$0, null);
                    this.$onFinish.invoke(null);
                    return;
                }
                java.io.File file = new java.io.File(parent, name);
                FileInteractor.access$setFileDialogRequest(this.this$0, null);
                this.$onFinish.invoke((Object)JavaFileKt.toFile(file));
            }
        }, 4, null));
    }

    public static /* synthetic */ void pickFile$default(FileInteractor fileInteractor, String string, List list, Function1 function1, File file, int n, Object object) {
        if ((n & 8) != 0) {
            file = null;
        }
        fileInteractor.pickFile(string, list, (Function1<? super File, Unit>)function1, file);
    }

    public final void exportData(@NotNull ExportDataRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
    }

    public static final /* synthetic */ void access$setFileDialogRequest(FileInteractor $this, FileDialogResult fileDialogResult) {
        $this.setFileDialogRequest(fileDialogResult);
    }
}

