/*
 * Decompiled with CFR 0.152.
 */
package repository;

import androidx.compose.runtime.internal.StabilityInferred;
import io.File;
import io.Paths;
import io.PathsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import model.GuideAudio;
import model.GuideAudioItem;
import model.GuideAudioKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import repository.ItemUsedTimeRepository;
import repository.ItemUsedTimeRepositoryImpl;
import util.DateTime;
import util.JsonKt;
import util.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0007\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u001b\u0012\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005J\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000fJ\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000fH\u0096\u0001J3\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u001e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001f\u0010 J\u0006\u0010!\u001a\u00020\u0012J\t\u0010\"\u001a\u00020\u0012H\u0096\u0001J\u0019\u0010#\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0018H\u0096\u0001J\u0011\u0010%\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000fH\u0096\u0001R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006'"}, d2={"Lrepository/GuideAudioRepository;", "Lrepository/ItemUsedTimeRepository;", "Lmodel/GuideAudioItem;", "_items", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "(Lkotlinx/coroutines/flow/MutableStateFlow;)V", "folder", "Lio/File;", "items", "Lkotlinx/coroutines/flow/StateFlow;", "getItems", "()Lkotlinx/coroutines/flow/StateFlow;", "map", "", "", "Lmodel/GuideAudio;", "delete", "", "names", "fetch", "get", "name", "getUsedTime", "", "import", "Lkotlin/Result;", "audioFile", "rawConfigFile", "findConfig", "", "import-0E7RQCE", "(Lio/File;Lio/File;Z)Ljava/lang/Object;", "init", "loadUsedTimes", "saveUsedTime", "time", "updateUsedTime", "Companion", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGuideAudioRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuideAudioRepository.kt\nrepository/GuideAudioRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nutil/JsonKt\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,138:1\n766#2:139\n857#2,2:140\n1549#2:142\n1620#2,3:143\n1549#2:146\n1620#2,3:147\n1855#2,2:155\n819#2:157\n847#2,2:158\n1#3:150\n28#4:151\n21#4:153\n113#5:152\n123#5:154\n*S KotlinDebug\n*F\n+ 1 GuideAudioRepository.kt\nrepository/GuideAudioRepository\n*L\n61#1:139\n61#1:140,2\n62#1:142\n62#1:143,3\n63#1:146\n63#1:147,3\n120#1:155,2\n126#1:157\n126#1:158,2\n92#1:151\n113#1:153\n92#1:152\n113#1:154\n*E\n"})
public final class GuideAudioRepository
implements ItemUsedTimeRepository<GuideAudioItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableStateFlow<List<GuideAudioItem>> _items;
    private final /* synthetic */ ItemUsedTimeRepositoryImpl<GuideAudioItem> $$delegate_0;
    private File folder;
    @NotNull
    private final Map<String, GuideAudio> map;
    @NotNull
    private final StateFlow<List<GuideAudioItem>> items;
    public static final int $stable = 8;
    @NotNull
    private static final String GUIDE_AUDIO_CONFIG_FILE_NAME_SUFFIX = "config.json";
    @NotNull
    public static final String GUIDE_AUDIO_RAW_CONFIG_FILE_EXTENSION = "txt";
    @NotNull
    public static final String GUIDE_AUDIO_FILE_EXTENSION = "wav";

    public GuideAudioRepository(final @NotNull MutableStateFlow<List<GuideAudioItem>> _items) {
        Intrinsics.checkNotNullParameter(_items, (String)"_items");
        this._items = _items;
        this.$$delegate_0 = new ItemUsedTimeRepositoryImpl(PathsKt.getGuideAudioRecordFile(Paths.INSTANCE), (Function1)new Function1<Function1<? super List<? extends GuideAudioItem>, ? extends List<? extends GuideAudioItem>>, Unit>(){

            public final void invoke(@NotNull Function1<? super List<GuideAudioItem>, ? extends List<GuideAudioItem>> update) {
                Intrinsics.checkNotNullParameter(update, (String)"update");
                _items.setValue(update.invoke(_items.getValue()));
            }
        });
        this.map = new LinkedHashMap();
        this.items = (StateFlow)this._items;
        this.init();
    }

    public /* synthetic */ GuideAudioRepository(MutableStateFlow mutableStateFlow, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            mutableStateFlow = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        }
        this((MutableStateFlow<List<GuideAudioItem>>)mutableStateFlow);
    }

    @Override
    public long getUsedTime(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.$$delegate_0.getUsedTime(name);
    }

    @Override
    public void loadUsedTimes() {
        this.$$delegate_0.loadUsedTimes();
    }

    @Override
    public void saveUsedTime(@NotNull String name, long time) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.$$delegate_0.saveUsedTime(name, time);
    }

    @Override
    public void updateUsedTime(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.$$delegate_0.updateUsedTime(name);
    }

    @NotNull
    public final StateFlow<List<GuideAudioItem>> getItems() {
        return this.items;
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        void it;
        File file;
        File file2 = file = PathsKt.getGuideAudioDirectory(Paths.INSTANCE);
        GuideAudioRepository guideAudioRepository = this;
        boolean bl = false;
        if (!it.exists()) {
            it.mkdirs();
        }
        guideAudioRepository.folder = file;
        this.map.clear();
        this._items.setValue((Object)CollectionsKt.emptyList());
        this.loadUsedTimes();
    }

    public final void fetch() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        File file = this.folder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
            file = null;
        }
        Iterable $this$filter$iv = file.listFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)((File)it).getName(), (String)GUIDE_AUDIO_CONFIG_FILE_NAME_SUFFIX, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.removeSuffix((String)((File)it).getName(), (CharSequence)".config.json"));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new GuideAudioItem((String)it, this.getUsedTime((String)it)));
        }
        List items2 = (List)destination$iv$iv;
        this._items.setValue((Object)items2);
    }

    @NotNull
    public final Object import-0E7RQCE(@NotNull File audioFile, @Nullable File rawConfigFile, boolean findConfig) {
        File file;
        Intrinsics.checkNotNullParameter((Object)audioFile, (String)"audioFile");
        if (!audioFile.isFile() || !Intrinsics.areEqual((Object)audioFile.getExtension(), (Object)GUIDE_AUDIO_FILE_EXTENSION)) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Could not find a valid audio file at " + audioFile.getAbsolutePath())));
        }
        if (rawConfigFile == null && findConfig) {
            String configFileName = audioFile.getNameWithoutExtension() + ".txt";
            File file2 = audioFile.getParentFile();
            if (file2 != null && (file2 = file2.resolve(configFileName)) != null) {
                File file3;
                File it = file3 = file2;
                boolean bl = false;
                file = it.exists() ? file3 : null;
            } else {
                file = null;
            }
        } else {
            file = rawConfigFile;
        }
        File resolvedRawConfigFile = file;
        Object object = GuideAudioKt.createGuideAudioConfig(audioFile, resolvedRawConfigFile);
        if (Result.isSuccess-impl((Object)object)) {
            GuideAudio it = (GuideAudio)object;
            boolean bl = false;
            File file4 = this.folder;
            if (file4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                file4 = null;
            }
            File importedWav = file4.resolve(it.getName() + ".wav");
            audioFile.copyTo(importedWav, true);
            audioFile.setLastModified(DateTime.INSTANCE.getNow());
            File file5 = this.folder;
            if (file5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                file5 = null;
            }
            File importedConfigFile = file5.resolve(it.getName() + ".config.json");
            GuideAudio $this$stringifyJson$iv = it;
            boolean $i$f$stringifyJson = false;
            StringFormat $this$encodeToString$iv$iv = (StringFormat)JsonKt.getJson();
            boolean $i$f$encodeToString = false;
            $this$encodeToString$iv$iv.getSerializersModule();
            importedConfigFile.writeText($this$encodeToString$iv$iv.encodeToString((SerializationStrategy)GuideAudio.Companion.serializer(), (Object)$this$stringifyJson$iv));
            Log.INSTANCE.i("GuideAudioRepository.import: saved to " + importedWav.getAbsolutePath());
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable t = throwable;
            boolean bl = false;
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t));
        }
        GuideAudio newGuideAudio = (GuideAudio)object;
        GuideAudioItem newItem = new GuideAudioItem(newGuideAudio.getName(), DateTime.INSTANCE.getNow());
        List items2 = CollectionsKt.toMutableList((Collection)((Collection)this._items.getValue()));
        CollectionsKt.removeAll((List)items2, (Function1)((Function1)new Function1<GuideAudioItem, Boolean>(newItem){
            final /* synthetic */ GuideAudioItem $newItem;
            {
                this.$newItem = $newItem;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull GuideAudioItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$newItem.getName());
            }
        }));
        items2.add(newItem);
        this._items.setValue((Object)items2);
        this.map.put(newGuideAudio.getName(), newGuideAudio);
        this.saveUsedTime(newGuideAudio.getName(), newItem.getLastUsed());
        return Result.constructor-impl((Object)Unit.INSTANCE);
    }

    @NotNull
    public final GuideAudio get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        GuideAudio guideAudio = this.map.get(name);
        if (guideAudio == null) {
            File file = this.folder;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                file = null;
            }
            String $this$parseJson$iv = File.readText$default(file.resolve(name + ".config.json"), null, 1, null);
            boolean $i$f$parseJson = false;
            StringFormat $this$decodeFromString$iv$iv = (StringFormat)JsonKt.getJson();
            boolean $i$f$decodeFromString = false;
            $this$decodeFromString$iv$iv.getSerializersModule();
            Object object = $this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)GuideAudio.Companion.serializer(), $this$parseJson$iv);
            GuideAudio it = (GuideAudio)object;
            boolean bl = false;
            this.map.put(name, it);
            guideAudio = (GuideAudio)object;
        }
        return guideAudio;
    }

    /*
     * WARNING - void declaration
     */
    public final void delete(@NotNull List<String> names) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Iterable $this$forEach$iv = names;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            File file = this.folder;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                file = null;
            }
            File file2 = file.resolve(name + ".config.json");
            File file3 = this.folder;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folder");
                file3 = null;
            }
            File audioFile = file3.resolve(name + ".wav");
            file2.delete();
            audioFile.delete();
        }
        $this$forEach$iv = (Iterable)this._items.getValue();
        MutableStateFlow<List<GuideAudioItem>> mutableStateFlow = this._items;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            GuideAudioItem it = (GuideAudioItem)element$iv$iv;
            boolean bl = false;
            if (names.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mutableStateFlow.setValue((Object)((List)destination$iv$iv));
    }

    public GuideAudioRepository() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lrepository/GuideAudioRepository$Companion;", "", "()V", "GUIDE_AUDIO_CONFIG_FILE_NAME_SUFFIX", "", "GUIDE_AUDIO_FILE_EXTENSION", "GUIDE_AUDIO_RAW_CONFIG_FILE_EXTENSION", "shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

