/*
 * Decompiled with CFR 0.152.
 */
package repository;

import androidx.compose.runtime.internal.StabilityInferred;
import io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import repository.ItemEncodingRepository;
import util.Encoding;
import util.JsonKt;
import util.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lrepository/ItemEncodingRepositoryImpl;", "Lrepository/ItemEncodingRepository;", "categoryMapFileMap", "", "", "Lio/File;", "(Ljava/util/Map;)V", "getItemEncoding", "Lutil/Encoding;", "category", "name", "getMap", "", "file", "putItemEncoding", "", "encoding", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nItemEncodingRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemEncodingRepository.kt\nrepository/ItemEncodingRepositoryImpl\n+ 2 Json.kt\nutil/JsonKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,65:1\n28#2:66\n21#2:68\n113#3:67\n123#3:69\n*S KotlinDebug\n*F\n+ 1 ItemEncodingRepository.kt\nrepository/ItemEncodingRepositoryImpl\n*L\n41#1:66\n59#1:68\n41#1:67\n59#1:69\n*E\n"})
public final class ItemEncodingRepositoryImpl
implements ItemEncodingRepository {
    @NotNull
    private final Map<String, File> categoryMapFileMap;
    public static final int $stable = 8;

    public ItemEncodingRepositoryImpl(@NotNull Map<String, File> categoryMapFileMap) {
        Intrinsics.checkNotNullParameter(categoryMapFileMap, (String)"categoryMapFileMap");
        this.categoryMapFileMap = categoryMapFileMap;
    }

    @Override
    public void putItemEncoding(@NotNull String category, @NotNull String name, @Nullable Encoding encoding) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File file = this.categoryMapFileMap.get(category);
        if (file == null) {
            Log.INSTANCE.e("Unknown category in ItemEncodingRepository: " + category);
            return;
        }
        Map<String, Encoding> map2 = this.getMap(file);
        if (encoding == null) {
            map2.remove(name);
        } else {
            map2.put(name, encoding);
        }
        Map<String, Encoding> $this$stringifyJson$iv = map2;
        boolean $i$f$stringifyJson = false;
        StringFormat $this$encodeToString$iv$iv = (StringFormat)JsonKt.getJson();
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv$iv.getSerializersModule();
        file.writeText($this$encodeToString$iv$iv.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, Encoding.Companion.serializer()), $this$stringifyJson$iv));
    }

    @Override
    @Nullable
    public Encoding getItemEncoding(@NotNull String category, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File file = this.categoryMapFileMap.get(category);
        if (file == null) {
            Log.INSTANCE.e("Unknown category in ItemEncodingRepository: " + category);
            return null;
        }
        Map<String, Encoding> map2 = this.getMap(file);
        return map2.get(name);
    }

    private final Map<String, Encoding> getMap(File file) {
        Map map2;
        if (file.exists()) {
            String $this$parseJson$iv = File.readText$default(file, null, 1, null);
            boolean $i$f$parseJson = false;
            StringFormat $this$decodeFromString$iv$iv = (StringFormat)JsonKt.getJson();
            boolean $i$f$decodeFromString = false;
            $this$decodeFromString$iv$iv.getSerializersModule();
            map2 = (Map)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, Encoding.Companion.serializer()), $this$parseJson$iv);
        } else {
            map2 = new LinkedHashMap();
        }
        return map2;
    }
}

