/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import androidx.compose.runtime.internal.StabilityInferred;
import exception.FatalException;
import exception.LocalizedException;
import io.FileInteractor;
import io.Paths;
import io.PathsKt;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ui.common.AlertDialogController;
import ui.common.AlertDialogKt;
import ui.model.AppContext;
import ui.string.Strings;
import ui.string.StringsKt;
import util.Clipboard;
import util.Log;
import util.PlatformKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lui/common/ErrorNotifier;", "", "alertDialogController", "Lui/common/AlertDialogController;", "context", "Lui/model/AppContext;", "fileInteractor", "Lio/FileInteractor;", "onFatalError", "Lkotlin/Function0;", "", "(Lui/common/AlertDialogController;Lui/model/AppContext;Lio/FileInteractor;Lkotlin/jvm/functions/Function0;)V", "notify", "t", "", "shared"})
@StabilityInferred(parameters=0)
public final class ErrorNotifier {
    @NotNull
    private final AlertDialogController alertDialogController;
    @NotNull
    private final AppContext context;
    @NotNull
    private final FileInteractor fileInteractor;
    @NotNull
    private final Function0<Unit> onFatalError;
    public static final int $stable = 8;

    public ErrorNotifier(@NotNull AlertDialogController alertDialogController, @NotNull AppContext context, @NotNull FileInteractor fileInteractor, @NotNull Function0<Unit> onFatalError) {
        Intrinsics.checkNotNullParameter((Object)alertDialogController, (String)"alertDialogController");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileInteractor, (String)"fileInteractor");
        Intrinsics.checkNotNullParameter(onFatalError, (String)"onFatalError");
        this.alertDialogController = alertDialogController;
        this.context = context;
        this.fileInteractor = fileInteractor;
        this.onFatalError = onFatalError;
    }

    public final void notify(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Log.INSTANCE.e(t);
        if (t instanceof LocalizedException) {
            String string = t.getMessage();
            if (string == null) {
                string = t.toString();
            }
            AlertDialogKt.requestConfirmError$default(this.alertDialogController, string, null, (Function0)new Function0<Unit>(t, this){
                final /* synthetic */ Throwable $t;
                final /* synthetic */ ErrorNotifier this$0;
                {
                    this.$t = $t;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    if (this.$t instanceof FatalException) {
                        ErrorNotifier.access$getOnFatalError$p(this.this$0).invoke();
                    }
                }
            }, 2, null);
            return;
        }
        if (PlatformKt.isDesktop()) {
            AlertDialogKt.requestConfirmCancellable$default(this.alertDialogController, null, StringsKt.stringStatic(Strings.AlertUnexpectedErrorOpenLog, new Object[0]), StringsKt.stringStatic(Strings.AlertUnexpectedErrorOpenLogButton, new Object[0]), null, (Function0)new Function0<Unit>(this){
                final /* synthetic */ ErrorNotifier this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ErrorNotifier.access$getFileInteractor$p(this.this$0).requestOpenFolder(PathsKt.getLogsDirectory(Paths.INSTANCE));
                }
            }, null, 41, null);
        } else {
            AlertDialogKt.requestConfirmCancellable$default(this.alertDialogController, null, StringsKt.stringStatic(Strings.AlertUnexpectedErrorCopyLogToClipboard, new Object[0]), StringsKt.stringStatic(Strings.AlertUnexpectedErrorCopyLogToClipboardButton, new Object[0]), null, (Function0)new Function0<Unit>(this, t){
                final /* synthetic */ ErrorNotifier this$0;
                final /* synthetic */ Throwable $t;
                {
                    this.this$0 = $receiver;
                    this.$t = $t;
                    super(0);
                }

                public final void invoke() {
                    Clipboard.INSTANCE.copy(ErrorNotifier.access$getContext$p(this.this$0), ExceptionsKt.stackTraceToString((Throwable)this.$t));
                }
            }, null, 41, null);
        }
    }

    public static final /* synthetic */ Function0 access$getOnFatalError$p(ErrorNotifier $this) {
        return $this.onFatalError;
    }

    public static final /* synthetic */ FileInteractor access$getFileInteractor$p(ErrorNotifier $this) {
        return $this.fileInteractor;
    }

    public static final /* synthetic */ AppContext access$getContext$p(ErrorNotifier $this) {
        return $this.context;
    }
}

