/*
 * Decompiled with CFR 0.152.
 */
package ui.screen;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.StabilityInferred;
import cafe.adriel.voyager.core.screen.Screen;
import cafe.adriel.voyager.navigator.Navigator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import model.AppRecord;
import model.Reclist;
import model.ReclistItem;
import model.Session;
import model.SortingMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import repository.AppRecordRepository;
import repository.ReclistRepository;
import repository.SessionRepository;
import ui.common.AlertDialogController;
import ui.common.AlertDialogKt;
import ui.common.ItemListScreenModel;
import ui.screen.SessionScreen;
import ui.string.Strings;
import ui.string.StringsKt;
import util.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\r\u0010\u001c\u001a\u00020\u0018H\u0017\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0016\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lui/screen/CreateSessionReclistScreenModel;", "Lui/common/ItemListScreenModel;", "Lmodel/ReclistItem;", "sessionRepository", "Lrepository/SessionRepository;", "appRecordRepository", "Lrepository/AppRecordRepository;", "reclistRepository", "Lrepository/ReclistRepository;", "navigator", "Lcafe/adriel/voyager/navigator/Navigator;", "alertDialogController", "Lui/common/AlertDialogController;", "(Lrepository/SessionRepository;Lrepository/AppRecordRepository;Lrepository/ReclistRepository;Lcafe/adriel/voyager/navigator/Navigator;Lui/common/AlertDialogController;)V", "finished", "", "upstream", "Lkotlinx/coroutines/flow/Flow;", "", "getUpstream", "()Lkotlinx/coroutines/flow/Flow;", "fetch", "", "getDeleteAlertMessage", "", "count", "", "getDeleteAlertTitle", "getItemsEmptyPlaceholder", "(Landroidx/compose/runtime/Composer;I)Ljava/lang/String;", "onClick", "item", "onDelete", "items", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCreateSessionReclistScreenModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateSessionReclistScreenModel.kt\nui/screen/CreateSessionReclistScreenModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1549#2:98\n1620#2,3:99\n1#3:102\n*S KotlinDebug\n*F\n+ 1 CreateSessionReclistScreenModel.kt\nui/screen/CreateSessionReclistScreenModel\n*L\n55#1:98\n55#1:99,3\n*E\n"})
public final class CreateSessionReclistScreenModel
extends ItemListScreenModel<ReclistItem> {
    @NotNull
    private final SessionRepository sessionRepository;
    @NotNull
    private final AppRecordRepository appRecordRepository;
    @NotNull
    private final ReclistRepository reclistRepository;
    @NotNull
    private final Navigator navigator;
    @NotNull
    private final AlertDialogController alertDialogController;
    private boolean finished;
    public static final int $stable = 8;

    public CreateSessionReclistScreenModel(@NotNull SessionRepository sessionRepository, final @NotNull AppRecordRepository appRecordRepository, @NotNull ReclistRepository reclistRepository, @NotNull Navigator navigator, @NotNull AlertDialogController alertDialogController) {
        Intrinsics.checkNotNullParameter((Object)sessionRepository, (String)"sessionRepository");
        Intrinsics.checkNotNullParameter((Object)appRecordRepository, (String)"appRecordRepository");
        Intrinsics.checkNotNullParameter((Object)reclistRepository, (String)"reclistRepository");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        Intrinsics.checkNotNullParameter((Object)alertDialogController, (String)"alertDialogController");
        List list = CollectionsKt.toList((Iterable)((Iterable)SortingMethod.getEntries()));
        SortingMethod sortingMethod = appRecordRepository.getValue().getReclistSortingMethod();
        if (sortingMethod == null) {
            sortingMethod = SortingMethod.NameAsc;
        }
        super(alertDialogController, list, sortingMethod, (Function1<? super SortingMethod, Unit>)((Function1)new Function1<SortingMethod, Unit>(){

            public final void invoke(final @NotNull SortingMethod it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                appRecordRepository.update((Function1<? super AppRecord, AppRecord>)((Function1)new Function1<AppRecord, AppRecord>(){

                    @NotNull
                    public final AppRecord invoke(@NotNull AppRecord $this$update) {
                        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                        return AppRecord.copy$default($this$update, 0, null, false, null, null, it, 31, null);
                    }
                }));
            }
        }));
        this.sessionRepository = sessionRepository;
        this.appRecordRepository = appRecordRepository;
        this.reclistRepository = reclistRepository;
        this.navigator = navigator;
        this.alertDialogController = alertDialogController;
        this.load();
    }

    @Override
    @NotNull
    public String getDeleteAlertTitle() {
        return StringsKt.stringStatic(Strings.CreateSessionReclistScreenDeleteItemsTitle, new Object[0]);
    }

    @Override
    @NotNull
    public String getDeleteAlertMessage(int count) {
        Object[] objectArray = new Object[]{count};
        return StringsKt.stringStatic(Strings.CreateSessionReclistScreenDeleteItemsMessage, objectArray);
    }

    @Override
    @Composable
    @NotNull
    public String getItemsEmptyPlaceholder(@Nullable Composer $composer, int $changed) {
        $composer.startReplaceableGroup(-1858861317);
        ComposerKt.sourceInformation((Composer)$composer, (String)"C(getItemsEmptyPlaceholder)");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1858861317, (int)$changed, (int)-1, (String)"ui.screen.CreateSessionReclistScreenModel.getItemsEmptyPlaceholder (CreateSessionReclistScreenModel.kt:47)");
        }
        String string = StringsKt.string(Strings.CreateSessionReclistScreenEmpty, new Object[0], $composer, 70);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceableGroup();
        return string;
    }

    @Override
    public void fetch() {
        this.reclistRepository.fetch();
    }

    @Override
    @NotNull
    public Flow<List<ReclistItem>> getUpstream() {
        return (Flow)this.reclistRepository.getItems();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onDelete(@NotNull List<ReclistItem> items2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Iterable iterable = items2;
        ReclistRepository reclistRepository = this.reclistRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReclistItem reclistItem = (ReclistItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        reclistRepository.delete((List)destination$iv$iv);
    }

    @Override
    public void onClick(@NotNull ReclistItem item) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (this.finished) {
            return;
        }
        this.finished = true;
        Object object2 = this.reclistRepository.get-IoAF18A(item.getName());
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            object = throwable;
            Throwable it = object;
            boolean bl = false;
            CreateSessionReclistScreenModel.onClick$onFailure(this, it);
        }
        Reclist reclist = (Reclist)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (reclist == null) {
            return;
        }
        Reclist reclist2 = reclist;
        object = this.sessionRepository.create-IoAF18A(reclist2);
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 != null) {
            Throwable throwable3;
            Throwable it = throwable3 = throwable2;
            boolean bl = false;
            CreateSessionReclistScreenModel.onClick$onFailure(this, it);
        }
        Session session = (Session)(Result.isFailure-impl((Object)object) ? null : object);
        if (session == null) {
            return;
        }
        Session session2 = session;
        this.reclistRepository.updateUsedTime(item.getName());
        this.navigator.replace((Screen)new SessionScreen(session2));
    }

    private static final void onClick$onFailure(CreateSessionReclistScreenModel this$0, Throwable t) {
        Log.INSTANCE.e(t);
        AlertDialogKt.requestConfirm$default(this$0.alertDialogController, null, StringsKt.stringStatic(Strings.CreateSessionReclistScreenFailure, new Object[0]), null, null, 13, null);
        this$0.finished = false;
    }
}

