/*
 * Decompiled with CFR 0.152.
 */
package ui.screen;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.StabilityInferred;
import cafe.adriel.voyager.core.screen.Screen;
import cafe.adriel.voyager.navigator.Navigator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import model.AppRecord;
import model.Session;
import model.SessionItem;
import model.SortingMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import repository.AppRecordRepository;
import repository.SessionRepository;
import ui.common.AlertDialogController;
import ui.common.AlertDialogKt;
import ui.common.ItemListScreenModel;
import ui.screen.SessionScreen;
import ui.string.Strings;
import ui.string.StringsKt;
import util.Log;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\r\u0010\u0018\u001a\u00020\u0014H\u0017\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0016\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lui/screen/MainScreenModel;", "Lui/common/ItemListScreenModel;", "Lmodel/SessionItem;", "sessionRepository", "Lrepository/SessionRepository;", "appRecordRepository", "Lrepository/AppRecordRepository;", "navigator", "Lcafe/adriel/voyager/navigator/Navigator;", "alertDialogController", "Lui/common/AlertDialogController;", "(Lrepository/SessionRepository;Lrepository/AppRecordRepository;Lcafe/adriel/voyager/navigator/Navigator;Lui/common/AlertDialogController;)V", "upstream", "Lkotlinx/coroutines/flow/Flow;", "", "getUpstream", "()Lkotlinx/coroutines/flow/Flow;", "fetch", "", "getDeleteAlertMessage", "", "count", "", "getDeleteAlertTitle", "getItemsEmptyPlaceholder", "(Landroidx/compose/runtime/Composer;I)Ljava/lang/String;", "onClick", "item", "onDelete", "items", "shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMainScreenModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainScreenModel.kt\nui/screen/MainScreenModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1549#2:74\n1620#2,3:75\n*S KotlinDebug\n*F\n+ 1 MainScreenModel.kt\nui/screen/MainScreenModel\n*L\n59#1:74\n59#1:75,3\n*E\n"})
public final class MainScreenModel
extends ItemListScreenModel<SessionItem> {
    @NotNull
    private final SessionRepository sessionRepository;
    @NotNull
    private final AppRecordRepository appRecordRepository;
    @NotNull
    private final Navigator navigator;
    @NotNull
    private final AlertDialogController alertDialogController;
    public static final int $stable = 8;

    public MainScreenModel(@NotNull SessionRepository sessionRepository, final @NotNull AppRecordRepository appRecordRepository, @NotNull Navigator navigator, @NotNull AlertDialogController alertDialogController) {
        Intrinsics.checkNotNullParameter((Object)sessionRepository, (String)"sessionRepository");
        Intrinsics.checkNotNullParameter((Object)appRecordRepository, (String)"appRecordRepository");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        Intrinsics.checkNotNullParameter((Object)alertDialogController, (String)"alertDialogController");
        List list = CollectionsKt.toList((Iterable)((Iterable)SortingMethod.getEntries()));
        SortingMethod sortingMethod = appRecordRepository.getValue().getSessionSortingMethod();
        if (sortingMethod == null) {
            sortingMethod = SortingMethod.UsedDesc;
        }
        super(alertDialogController, list, sortingMethod, (Function1<? super SortingMethod, Unit>)((Function1)new Function1<SortingMethod, Unit>(){

            public final void invoke(final @NotNull SortingMethod it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                appRecordRepository.update((Function1<? super AppRecord, AppRecord>)((Function1)new Function1<AppRecord, AppRecord>(){

                    @NotNull
                    public final AppRecord invoke(@NotNull AppRecord $this$update) {
                        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                        return AppRecord.copy$default($this$update, 0, null, false, it, null, null, 55, null);
                    }
                }));
            }
        }));
        this.sessionRepository = sessionRepository;
        this.appRecordRepository = appRecordRepository;
        this.navigator = navigator;
        this.alertDialogController = alertDialogController;
        this.load();
    }

    @Override
    @NotNull
    public String getDeleteAlertTitle() {
        return StringsKt.stringStatic(Strings.MainScreenDeleteItemsTitle, new Object[0]);
    }

    @Override
    @NotNull
    public String getDeleteAlertMessage(int count) {
        Object[] objectArray = new Object[]{count};
        return StringsKt.stringStatic(Strings.MainScreenDeleteItemsMessage, objectArray);
    }

    @Override
    @Composable
    @NotNull
    public String getItemsEmptyPlaceholder(@Nullable Composer $composer, int $changed) {
        $composer.startReplaceableGroup(-2016649509);
        ComposerKt.sourceInformation((Composer)$composer, (String)"C(getItemsEmptyPlaceholder)");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-2016649509, (int)$changed, (int)-1, (String)"ui.screen.MainScreenModel.getItemsEmptyPlaceholder (MainScreenModel.kt:41)");
        }
        String string = StringsKt.string(Strings.MainScreenEmpty, new Object[0], $composer, 70);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceableGroup();
        return string;
    }

    @Override
    public void fetch() {
        this.sessionRepository.fetch();
    }

    @Override
    @NotNull
    public Flow<List<SessionItem>> getUpstream() {
        return this.sessionRepository.getItems();
    }

    @Override
    public void onClick(@NotNull SessionItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Object object = this.sessionRepository.get-IoAF18A(item.getName());
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            Log.INSTANCE.e(it);
            AlertDialogKt.requestConfirmError$default(this.alertDialogController, it.getMessage(), null, null, 6, null);
            return;
        }
        Session session = (Session)object;
        this.navigator.push((Screen)new SessionScreen(session));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onDelete(@NotNull List<SessionItem> items2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Iterable iterable = items2;
        SessionRepository sessionRepository = this.sessionRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SessionItem sessionItem = (SessionItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        sessionRepository.delete((List)destination$iv$iv);
    }
}

