## 3.4 CentOS

CentOS (及其替代品 Rocky Linux、AlmaLinux) 是企业级服务器常用的操作系统。本节介绍在这些系统上安装 Docker 的步骤。

>警告：切勿在没有配置 Docker YUM 源的情况下直接使用 yum 命令安装 Docker。

### 3.4.1 准备工作

安装前请确认系统版本和内核版本满足 Docker 的运行要求。

#### 系统要求

> ⚠️ **重要提示**：CentOS 8 已于 2021 年 12 月 31 日停止维护，CentOS 7 已于 2024 年 6 月 30 日结束支持。建议新项目使用 **Rocky Linux** 或 **AlmaLinux** 作为替代。

Docker 支持 64 位版本 CentOS Stream 9、Rocky Linux 8/9、AlmaLinux 8/9，并且要求内核版本不低于 3.10。

对于 Rocky Linux、AlmaLinux 或 CentOS Stream，推荐使用 `dnf` 包管理器。

#### 卸载旧版本

旧版本的 Docker 称为 `docker` 或者 `docker-engine`，使用以下命令卸载旧版本：

```bash
$ sudo yum remove docker \
                  docker-client \
                  docker-client-latest \
                  docker-common \
                  docker-latest \
                  docker-latest-logrotate \
                  docker-logrotate \
                  docker-selinux \
                  docker-engine-selinux \
                  docker-engine \
                  docker-ce-cli \
                  containerd.io
```

### 3.4.2 使用 yum 安装

使用 yum/dnf 安装是管理 Docker 生命周期的标准方式。

执行以下命令安装依赖包：

```bash
$ sudo dnf install -y dnf-utils
```

鉴于国内网络问题，强烈建议使用国内源，官方源请在注释中查看。

执行下面的命令添加 `yum` 软件源：

```bash
$ sudo dnf config-manager \
    --add-repo \
    https://mirrors.aliyun.com/docker-ce/linux/centos/docker-ce.repo

$ sudo sed -i 's/download.docker.com/mirrors.aliyun.com\/docker-ce/g' /etc/yum.repos.d/docker-ce.repo

## 官方源

## $ sudo dnf config-manager \

##     --add-repo \

##     https://download.docker.com/linux/centos/docker-ce.repo

```

如果需要测试版本的 Docker 请执行以下命令：

```bash
$ sudo dnf config-manager --set-enabled docker-ce-test
```

#### 安装 Docker

更新 `dnf` 软件源缓存，并安装 `docker-ce`。

```bash
$ sudo dnf install docker-ce docker-ce-cli containerd.io
```

### 3.4.3 CentOS8 额外设置

CentOS 8/Stream 默认使用 `nftables`。Docker 在新版本中已提供 `nftables` 实验支持，但在一些环境下仍可能遇到兼容性问题。若你遇到容器网络异常，可以先切换回 `iptables` 后端：

更改 `/etc/firewalld/firewalld.conf`

```bash
## FirewallBackend=nftables

FirewallBackend=iptables
```

或者执行如下命令：

```bash
$ firewall-cmd --permanent --zone=trusted --add-interface=docker0

$ firewall-cmd --reload
```

### 3.4.4 使用脚本自动安装

在测试或开发环境中 Docker 官方为了简化安装流程，提供了一套便捷的安装脚本，CentOS 系统上可以使用这套脚本安装，另外可以通过 `--mirror` 选项使用国内源进行安装：

> 若你想安装测试版的 Docker，请从 test.docker.com 获取脚本

```bash
## $ curl -fsSL test.docker.com -o get-docker.sh

$ curl -fsSL get.docker.com -o get-docker.sh
$ sudo sh get-docker.sh --mirror Aliyun
## $ sudo sh get-docker.sh --mirror AzureChinaCloud

```

执行这个命令后，脚本就会自动的将一切准备工作做好，并且把 Docker 的稳定 (stable) 版本安装在系统中。

### 3.4.5 启动 Docker

```bash
$ sudo systemctl enable docker
$ sudo systemctl start docker
```

### 3.4.6 建立 docker 用户组

默认情况下，`docker` 命令会使用 [Unix socket](https://en.wikipedia.org/wiki/Unix_domain_socket) 与 Docker 引擎通讯。而只有 `root` 用户和 `docker` 组的用户才可以访问 Docker 引擎的 Unix socket。出于安全考虑，一般 Linux 系统上不会直接使用 `root` 用户。因此，更好地做法是将需要使用 `docker` 的用户加入 `docker` 用户组。

建立 `docker` 组：

```bash
$ sudo groupadd docker
```

将当前用户加入 `docker` 组：

```bash
$ sudo usermod -aG docker $USER
```

退出当前终端并重新登录，进行如下测试。

### 3.4.7 测试 Docker 是否安装正确

```bash
$ docker run --rm hello-world

Unable to find image 'hello-world:latest' locally
latest: Pulling from library/hello-world
b8dfde127a29: Pull complete
Digest: sha256:308866a43596e83578c7dfa15e27a73011bdd402185a84c5cd7f32a88b501a24
Status: Downloaded newer image for hello-world:latest

Hello from Docker!
This message shows that your installation appears to be working correctly.

To generate this message, Docker took the following steps:
 1. The Docker client contacted the Docker daemon.
 2. The Docker daemon pulled the "hello-world" image from the Docker Hub.
    (amd64)
 3. The Docker daemon created a new container from that image which runs the
    executable that produces the output you are currently reading.
 4. The Docker daemon streamed that output to the Docker client, which sent it
    to your terminal.

To try something more ambitious, you can run an Ubuntu container with:
 $ docker run -it ubuntu bash

Share images, automate workflows, and more with a free Docker ID:
 https://hub.docker.com/

For more examples and ideas, visit:
 https://docs.docker.com/get-started/
```

若能正常输出以上信息，则说明安装成功。

### 3.4.8 镜像加速

如果在使用过程中发现拉取 Docker 镜像十分缓慢，可以配置 Docker [国内镜像加速](3.9_mirror.md)。

### 3.4.9 添加内核参数

如果在 CentOS 使用 Docker 看到下面的这些警告信息：

```bash
WARNING: bridge-nf-call-iptables is disabled
WARNING: bridge-nf-call-ip6tables is disabled
```

请添加内核配置参数以启用这些功能。

```bash
$ sudo tee -a /etc/sysctl.conf <<-EOF
net.bridge.bridge-nf-call-ip6tables = 1
net.bridge.bridge-nf-call-iptables = 1
EOF
```

然后重新加载 `sysctl.conf` 即可

```bash
$ sudo sysctl -p
```

### 3.4.10 参考文档

* [Docker 官方 CentOS 安装文档](https://docs.docker.com/engine/install/centos/)。
* https://firewalld.org/2018/07/nftables-backend
* https://github.com/moby/libnetwork/issues/2496
