## 6.1 Docker Hub

### 6.1.1 什么是 Docker Hub

Docker Hub 是 Docker 的中央镜像仓库，通过它您可以轻松地分享和获取 Docker 镜像。


[Docker Hub](https://hub.docker.com/) 是 Docker 官方维护的公共镜像仓库，也是全球最大的容器镜像库。

它提供了：

- **官方镜像**：由 Docker 官方和软件厂商 (如 Nginx，MySQL，Node.js) 维护的高质量镜像。
- **个人/组织仓库**：用户可以上传自己的镜像。
- **自动构建**：与 GitHub/Bitbucket 集成 (需付费)。
- **Webhooks**：镜像更新时触发回调。

---

### 6.1.2 核心功能

#### 1. 搜索镜像

我们可以通过 `docker search` 命令来查找官方仓库中的镜像，并利用 `docker pull` 命令来将它下载到本地。


除了网页搜索，也可以使用命令行：

```bash
$ docker search centos
NAME      DESCRIPTION                      STARS     OFFICIAL
centos    The official build of CentOS.    7000+     [OK]
```

> **技巧**：始终优先使用 `OFFICIAL` 标记为 `[OK]` 的镜像，安全性更有保障。

#### 2. 拉取镜像

```bash
$ docker pull nginx:alpine
```

#### 3. 推送镜像

需要先登录：

```bash
$ docker login
## 输入用户名和密码

...
```

打标签并推送：

```bash
## 1. 标记镜像

$ docker tag myapp:v1 username/myapp:v1

## 2. 推送

$ docker push username/myapp:v1
```

---

### 6.1.3 限制与配额

#### 镜像拉取限制

自 2020 年 11 月起，Docker Hub 对匿名和免费用户实施了拉取速率限制：

| 用户类型 | 限制 |
|---------|------|
| **匿名用户** (未登录) | 每 6 小时 100 次请求 |
| **免费账户** (已登录) | 每 6 小时 200 次请求 |
| **Pro/Team 账户** | 无限制 |

> **提示**：如果在 CI/CD 环境中遇到 `toomanyrequests` 错误，建议：
> 1. 在 CI 中配置 `docker login`
> 2. 使用国内镜像加速器
> 3. 搭建私有仓库代理

---

### 6.1.4 安全最佳实践

#### 1. 启用 2FA (双因素认证)

为了保护您的 Docker Hub 账号安全，我们建议采取以下措施。


在 Account Settings -> Security 中启用 2FA，保护账号安全。启用后，CLI 登录需要使用 **Access Token** 而非密码。

#### 2. 使用 Access Token

不要在脚本或 CI/CD 中直接使用登录密码。

1. 在 Docker Hub -> Account Settings -> Security -> Access Tokens 创建 Token。
2. 使用 Token 作为密码登录：

```bash
$ docker login -u username -p dckr_pat_xxxxxxx
```

#### 3. 关注镜像漏洞

Docker Hub 会对官方镜像和付费用户的镜像进行安全扫描。在镜像标签页可以看到漏洞扫描结果。

---

### 6.1.5 Webhooks

当镜像被推送时，可以自动触发 HTTP 回调 (例如通知 CI 系统部署)。

**配置方法**：
仓库页面 -> Webhooks -> Create Webhook。

---

### 6.1.6 自动构建

> ⚠️ 目前仅限付费用户 (Pro/Team) 使用。

链接 GitHub/Bitbucket 仓库后，当代码有提交或打标签时，Docker Hub 会自动运行构建。这保证了镜像总是与代码同步，且由可信的官方环境构建。

---
