## 10.2 使用 buildx 构建镜像

### 10.2.1 使用

Buildx 的使用非常直观，绝大多数情况下可以替代 `docker build` 命令。

你可以直接使用 `docker buildx build` 命令构建镜像。

```bash
$ docker buildx build .
[+] Building 8.4s (23/32)
 => ...
```

Buildx 使用 [BuildKit 引擎](10.1_buildkit.md)进行构建，支持许多新的功能，具体参考 [Buildkit](10.1_buildkit.md) 一节。

#### 使用 `bake`

`docker buildx bake` 是一个高级构建命令，支持从 HCL、JSON 或 Compose 文件中定义构建目标，实现复杂的流水线构建。

```bash
## 从 Compose 文件构建所有服务

$ docker buildx bake

## 仅构建指定目标

$ docker buildx bake web
```

#### 生成 SBOM

Buildx 支持在构建时直接生成 SBOM (Software Bill of Materials)，这对于软件供应链安全至关重要。

```bash
$ docker buildx build --sbom=true -t myimage .
```

该命令会在构建结果中包含 SPDX 或 CycloneDX 格式的 SBOM 数据。

### 10.2.2 官方文档

* https://docs.docker.com/engine/reference/commandline/buildx/
