## DzzOffice的下载及技术支持

1. 官方网站：   http://www.dzzoffice.com
2. github地址：https://github.com/zyx0814/dzzoffice
3. 码云地址：   https://gitee.com/zyx0814/dzzoffice

## V2.4.1 主要更新内容
> **发布于: 2025.12.30**
### 一、新增功能 (Added)
- 【网盘】新增文件夹和文件单独权限设置功能，优先遵循自身权限，未设置时自动继承上级目录权限；新增分享文件重命名功能
- 【网盘】支持设置同名文件处理方式（覆盖/重命名）及文档显示模式；支持文件并发上传，提升多文件上传效率
- 【网盘】群组管理支持按群组名搜索，支持显示群组已使用空间和总空间大小情况
- 【网盘】新增文件元数据悬浮提示，便捷查看文件核心信息
- 【组件】评论附件与编辑器附件支持保存到网盘，拓展附件存储渠道
- 【应用管理】应用市场-本地应用管理支持显示未安装的管理员应用，便于统筹管理
- 【界面自定义】注册页支持"隐藏"或"选填"邮箱字段，登录页支持隐藏找回密码按钮，适配不同场景需求
- 【系统工具】计划任务页添加触发方式提示，提升操作指引性
- 【分享页】新增用户举报功能，支持用户反馈违规分享内容，管理员可在后台进行处理

### 二、优化改进 (Improved)
- 【网盘】大幅提升整体性能，优化权限处理逻辑，减少冗余查询
- 【网盘】优化文件夹详情页加载速度，异步获取文件夹大小及文件数，减少等待时间
- 【网盘】优化移动端体验；修复点击网络挂载时滚动条跳动问题；优化分享文件/删除文件缩略图展示
- 【网盘】移除历史版本列表独立展示，归入“版本”选项卡统一管理，简化界面布局
- 【UI】优化安装页、首页、通知中心、用户中心、登录模板4及系统设置侧边栏UI，提升视觉一致性
- 【系统】优化用户登录后的页面跳转逻辑；优化安装程序代码及数据库检测逻辑，解决初始化提示问题
- 【系统】优化头像展示逻辑：UID为空/0时默认显示游客头像；优化头像生成性能（减少`user`/`user_setting`表重复查询），提升加载速度；优化数据表格交互体验
- 【系统】优化fetch_all_ext方法，避免appid重复查询；优化模板解析器，修复部分场景报错问题
- 【系统】优化lang()函数缓存机制，减少重复解析开销，提升系统整体性能
- 【组件】Layui组件更新至V2.13.2，提升组件稳定性与兼容性
- 【组件】精简文件位置选择组件功能并修复已知问题
- 【环境适配】安装程序适配环境变量，自动初始化数据库信息，检测到Redis则启用内存优化；完成PHP8兼容性处理
- 【系统】调整系统报错时的默认展示规则，默认仅显示错误本身，防范安全问题
- 【系统】优化删除用户逻辑，清理更多关联用户数据，减少冗余数据残留
- 【机构用户】优化机构用户验证表单的提示信息，提升错误指引清晰度与准确性
- 【文件管理】【系统日志】【评论】支持 URL 地址变化适配

### 三、Bug修复 (Fixed)
#### 3.1 核心功能模块
- 【网盘】修复上传非文件夹时触发左侧栏文件夹层级更新、拖拽上传文件夹重复创建问题
- 【网盘】修复文件排序纯数字异常、排序切换两次请求、前端文件/文件夹名称数字排序异常问题
- 【网盘】修复搜索文件后按修改时间排序报错及多个搜索场景误触问题
- 【网盘】修复删除文件夹未更新子文件夹状态、获取文件夹大小属性值异常问题
- 【网盘】**修复新建文件夹无限递归无响应**、新建文件触发两次加载缩略图问题
- 【网盘】修复Redis缓存场景下网盘功能设置失效、文件不显示问题
- 【网盘】修复文件夹删除/复制权限判断错误、前端重命名功能权限判断错误问题
- 【网盘】修复查看机构部门信息时权限判断错误提示、链接类型文件权限显示不正确问题
- 【网盘】修复文件夹能创建历史版本导致的系列问题；修复部分情况下不显示上传更新文件版本及历史版本信息错误问题
- 【网盘】修复分享文件无法保存、下载文件夹内容及分享框中不能删除分享文件问题
- 【网盘】修复部分缩略图显示异常、网盘异常情况下无提示问题
- 【网盘】修复按文件类型查看文件时，排序方式无法保存的问题
- 【网盘】修正取消分享时的错误提示文案，提升提示准确性
- 【网盘】修复网络挂载不能正常显示文件列表和提示无权限问题
- **【系统】修复普通成员能进入后台及系统管理员权限异常问题**
- 【系统】修复应用启用/关闭后未实时显示/隐藏的缓存问题；修复应用卸载bug、在线更新应用页数链接错误及跨域兼容性问题
- 【系统】修复配置文件`config_default`配置合并丢失问题；修复伪静态已知问题
- 【系统】修复wopi接口系列问题及相关安全隐患
- 【系统】修复后台访问操作记录部分参数缺失的问题，完善日志数据完整性
- 【系统】修复登录日志重复记录的问题，确保日志数据唯一性

#### 3.2 机构与用户管理
- 【机构用户】修复导入已存在的用户数据时，会删除用户所在群组的问题
- 【机构用户】解决导出用户数据时，不支持选择真实姓名、生肖、星座字段的问题
- 【机构用户】修复机构用户中部门无法变更为机构（2 级部门不能转为 1 级部门）的问题
- 【机构用户】修复添加机构部门管理员时权限判断错误问题（已修正为判断上级权限）
- 【机构用户】修复普通管理员可修改系统管理员信息的权限越权问题

#### 3.3 组件与表单
- 【组件】修复文件选择框打开时默认路径未选中的交互问题
- 【组件】修复设置仅选择我所在机构部门时，不能选择子级的问题
- 【表单】修复部分表单不支持填充内容问题；修复登录注册表单自动填充异常问题
- 【系统设置】修复不能新建权限包的问题

#### 3.4 分享管理
- 【分享】修复分享文件不存在时状态被错误恢复的问题；修复分享管理页若干显示异常问题

#### 3.5 其他修复
- 【通用】解决一些已知问题，提升系统整体稳定性

### 四、安全加固 (Security)
- **【网盘】修复网盘文件无下载权限仍可下载漏洞，`index.php?mod=io&op=download`接口新增权限校验**
- 【权限管控】调整网盘回收站权限：系统管理员仅能通过文件管理查看非管理文件，强化数据隔离
- 【权限管控】分享管理应用、文件管理应用调整为仅管理员可用，防止越权操作风险
- 【访问控制】多处添加游客权限拦截逻辑，限制非授权访问
- 【漏洞修复】修复其他已知安全漏洞及潜在风险点

### 五、架构调整 (Refactored)
- 【环境要求】调整运行环境要求为`MySQL5.7+`和PHP7.4+`，提升系统稳定性与兼容性
- 【代码清理】删除V1版本残留代码、重复代码、多余代码及弃用文件
- 【模块移除】移除solr相关代码；移除tp模式相关废弃文件和C::tp_t()调用
- 【数据库】删除弃用数据库表：`folder_default`、`folder_event`、`folder_flag`、`folder_perm`、`folder_sub`、`thame`、`user_thame`、`attach`、`iconview`
- 【代码重构】重构dfsockopen函数底层代码，优化网络请求连接稳定性、超时处理机制与异常捕获逻辑，修复部分网络环境下请求失败的问题，同时简化函数调用流程，提升代码可维护性
- 【代码重构】为通用数据表操作基类添加注释，提升代码可维护性
- 【代码重构】简化`avatar_block`和`avatar_group`函数逻辑，消除重复代码，提升头像相关功能执行效率
- 【管理页】修改管理员系统信息显示内容，优化管理端信息展示

### 六、升级注意事项
1.  版本适配：从V2.01及以上版本升级至V2.4.1的用户，**必须执行升级程序**（在线升级可通过「系统工具」→「在线升级」自动完成；离线升级需覆盖源码后访问 `您的域名/install/update.php` 执行升级）。
2.  缓存清理：无论采用在线升级还是离线升级方式，升级完成后，需登录管理后台前往「系统工具」中清理系统缓存（含数据缓存、模板缓存、内存缓存），确保新功能正常生效、页面显示无误。
3.  数据备份：升级前建议对网站根目录文件及数据库进行完整备份，避免因自定义修改覆盖或异常情况导致数据风险。
4.  环境检查：请确认服务器环境满足MySQL5.7+、PHP7.4+及以上要求，否则可能导致升级失败或系统异常。

## V2.4.0 主要更新内容
> **发布于: 2025.11.5**
### 网盘
#### 1. 问题修复
- **回收站：** 修复回收站文件永久删除时间显示错误问题；修复不能按删除时间排序的问题。
- **权限漏洞：** 修复网盘权限漏洞，调整网盘分享、回收站、类型、搜索功能系统管理员也只能查看权限范围内的内容，如需查看所有内容需前往文件管理。
- **安全漏洞：** 修复网盘描述说明表单 XSS 漏洞。
- **网络挂载：** 增强本地磁盘挂载的安全性，避免非授权用户通过挂载功能访问敏感目录，同时减少跨用户路径冲突问题。

#### 2. 功能增强
- **权限管理：** 调整网盘编辑标签需要编辑权限才能使用；网络挂载功能支持设置人员使用范围。
- **文件操作：** 最近使用和搜索页支持对文件进行复制、移动、下载、重命名、删除等功能。

#### 3. 体验与 UI 优化
- **信息展示：** 修改文件信息显示。
- **性能优化：** 优化网盘响应性能，优化界面交互、搜索展示及前端性能。
- **细节优化：** 修改网盘评论动态显示逻辑。

### 机构用户管理
- **用户添加：** 调整添加用户时默认不向用户发送邮件。

### 系统
#### 1. 问题修复
- **安全与权限：**
    - 修复恶意代码执行漏洞、SQL 注入漏洞等高危漏洞。
    - 修复云存储（非服务器磁盘）文件在作为附件或非网盘应用调用时的权限判断错误，避免无权限提示。
- **其他修复：**
    - 修复模板文件部分情况下会报错问题。
    - 修改 GD 库环境检测逻辑。
    - 修改在线升级插件时会重置插件配置和钩子不能正常的问题。
    - 修改消息提示会覆盖页面内容问题。
    - 其他已知问题修复。

#### 2. 功能增强
- **用户组配置：** 支持设置是否允许修改用户名等。
- **数据库支持：** 新增 PDO 数据库扩展支持，提升数据库操作的安全性和兼容性；新增对 InnoDB 存储引擎 的支持，提升事务处理能力与数据安全性。

#### 3. 优化改进
- **界面：** 优化 UI；关于页显示名称调整；修改样式；光年模板添加点击波纹效果；优化文件管理和分享管理的图标显示。
- **代码：** 删除多余的文件，防止安全问题；修改内存优化描述。
- **语言：** 新增英文语言包。

### 注意事项
1. **离线升级**：从V2.01及以上版本的用户升级到V2.4.0需要执行升级程序。本次更新包含关键问题修复，建议所有用户尽快升级，以获得更好的使用体验。
2. **PHP版本**：仅支持php7.0+的PHP版本使用，请确保你的服务器环境符合要求。
3. **清理缓存**：无论是在线升级还是离线升级，都需要在升级后前往系统工具中清理系统缓存，以保证系统正常运行。
4. **数据库兼容性调整**：2.4.0 之前版本采用 MyISAM 引擎与 UTF8 编码，之后版本全面升级为 InnoDB 引擎与 UTF8MB4 编码。开发者请注意调整数据库配置，以确保兼容性与性能优化。

## V2.3.8 主要更新内容
> **发布于: 2025.9.28**
### 网盘
#### 1. 问题修复
- **权限问题：** 修复「我的网盘」权限异常问题（含无法查看他人分享上传文件、其他用户越权查看私人文件、自身无法查看全部数据、目录信息被他人查看）。
- **分享页面：** 解决 Excel 文件名称为空、文件夹上传及报错问题。
- **文件夹上传：** 修复部分场景下上传文件夹后需刷新才能打开的问题（优化后上传完成可直接进入）。
- **文件动态：** 修复网址文件动态路径信息错误问题。

#### 2. 功能增强
- **权限管理：** 支持机构 / 部门管理员在网盘中直接设置权限。
- **文件操作：** 支持为文件 / 文件夹添加描述说明；新增「使用浏览器打开」文件方式；回收站支持右侧信息栏显示。
- **网址文件：** 新建网址时支持自定义名称。
- **分享功能：** 分享文件到期时间支持精确到时分。
- **文件动态：** 完善文件动态信息（创建 / 编辑分享时显示文件位置）。

#### 3. 体验与 UI 优化
- **界面展示：** 文件列表支持显示收藏、分享状态；右侧信息栏分类呈现「属性、权限、历史版本、评论、动态」。
- **信息展示：** 右侧信息栏支持显示机构 / 部门 / 群组的文件数量与大小。
- **细节优化：** 优化界面交互、搜索展示及前端性能；历史版本文件位置改为仅限管理员查看。

### 机构用户管理
- **界面重构：** 全新布局设计，左侧栏以树型结构展示部门层级，主体部分以列表形式展示用户信息，便于快速查找管理。
- **导入优化：** 机构和部门管理员可对机构用户应用进行「覆盖导入」操作。

### 系统
#### 1. 问题修复
- **安全与权限：**
    - 修复个人用户可查看其他用户登录记录的问题。
    - 修复普通用户访问后台时不显示「无权限」提示、反而弹出登录框的问题。
    - 修复文件与目录选择框在部分情况下会误判无权限的问题。
- **系统组件：**
    - 修复机构部门选择时不能选择无机构选项的问题。
    - 文件与目录选择框适配小屏环境，优化重复加载问题。
    - jstree 组件更新至 V3.0.2 版本，解决触摸设备选择问题。
- **其他修复：**
    - 修复注册页不能正常显示验证码验证失败信息的问题。
    - 修复重置密码时，新密码与旧密码相同时不能正常返回提示信息的问题。
    - 修复日志跳转错误链接问题。
    - 修复数据库使用MariaDB安装时报错问题。
    - 其他已知问题修复。

#### 2. 功能增强
- **用户组配置：** 开放用户组权限配置，支持自定义用户组的文件夹等权限。
- **系统设置：** 新增「通知设置」模块。
- **应用市场：** 在线应用市场实现跨域兼容与排序功能。
- **通知增强：** 支持通过 $notevars 直接传入通知内容（标题、正文、链接等）。
- **注册管控：** 支持设置同一 IP 注册间隔，支持对新注册用户发送欢迎信息。
- **系统日志：** 新增用户登出记录功能。

#### 3. 优化改进
- **界面：** 优化 layui 表格 UI 显示效果；数据库恢复页面添加工具下载链接。
- **代码：** 移除弃用代码，删除残留代码。
- **语言：** 新增英文语言包。

### 注意事项
1. **离线升级**：从V2.01及以上版本的用户升级到V2.3.8需要执行升级程序。本次更新包含关键问题修复，建议所有用户尽快升级，以获得更好的使用体验。
2. **PHP版本**：仅支持php7.0+的PHP版本使用，请确保你的服务器环境符合要求。
3. **清理缓存**：无论是在线升级还是离线升级，都需要在升级后前往系统工具中清理系统缓存，以保证系统正常运行。

## V2.3.7 主要更新内容
> **发布于: 2025.8.21**

### 新增功能
1. 网盘新增设置默认打开文件方式，用户可以自行设置默认打开方式的应用。
2. 系统工具新增内存优化模块，支持显示配置情况、清理内容缓存，可查看 PHP 扩展环境支持情况及 Config 设置是否开启。
3. 系统设置新增通知设置模块，支持设置通知刷新时间间隔、通知消息重复接收与计数。

### 问题修复
1. 修复应用中心页面加载频繁更新记录问题。
2. 修复空文件上传后实际不存在导致的打开与下载失败，还会造成数据库记录重复问题。
3. 修复存储型XSS漏洞，增强输入过滤机制。
4. 修复正在等待上传的文件不能进行取消上传问题。
5. 修复使用容器安装时，端口获取不正确问题。
6. 修复部分场景下上传文件夹后需刷新才能打开的问题，现在上传完成即可直接进入文件夹，操作更顺畅。
7. 其他已知bug修复，安全问题修复。

### 优化改进
1. 改进系统日志、分享管理、文件管理、评论应用的数据表格搜索框、渲染及搜索逻辑。
2. 处理部分场景创建目录时参数缺失情况。
3. 处理缓存数据不能实时携带sid和preview参数的情况。
4. 优化站点关闭时已登录用户页面显示。
5. 调整验证码机制：前端限制4次尝试，后端单次校验并自动删除验证码防止重复使用。
6. 优化网盘回收站逻辑（当彻底删除设置为0天时直接删除，不进入回收站）。
7. 网盘空搜索行为优化：移除空条件限制，现在空搜索将返回所有权限内文件。
8. 网盘搜索逻辑优化：修复当文件位置选择机构部门时可能会显示无权限个人文件的问题，修复不能搜索本级文件的问题，优化重置时标记、位置选中交互逻辑。
9. 完善网盘资源事件动态数据：补充文件位置和文件链接，确保动态信息完整。
10. 网盘UI优化与交互优化。
11. 网盘右侧信息栏支持查看机构/部门/群组包含文件数量与大小属性。
12. 将邮箱地址长度校验从 32 位调整为 40 位，与数据库字段长度保持一致，解决因长度限制导致的合法邮箱无法创建用户问题。

### 注意事项
1. **离线升级**：从V2.01及以上版本的用户升级到V2.3.7需要执行升级程序。本次更新包含关键问题修复，建议所有用户尽快升级，以获得更好的使用体验。
2. **PHP版本**：仅支持php7.0+的PHP版本使用，请确保你的服务器环境符合要求。
3. **清理缓存**：无论是在线升级还是离线升级，都需要在升级后前往系统工具中清理系统缓存，以保证系统正常运行。

## V2.3.6 主要更新内容
> **发布于: 2025.7.27**

### 新增功能
1. **新增 `resources_meta` 元数据表**：
    - 开发者可基于此扩展文件关联数据，无需自行维护独立表。
    - 记录会随网盘文件删除自动清理。
    - 适用场景：插件开发、文件关联元数据存储。
2. 分享页新增「文件位置」查看功能，支持分享者和管理员查看。
3. 网盘编辑分享框支持显示分享统计，如访问次数。
4. 网盘右侧信息栏和分享页支持分页信息显示。
5. 机构部门/群组的介绍内容支持在网盘应用场景中展示。

### 问题修复
1. 修复云存储文件通过 `getStream` 接口预览时出现的**空白/加载失败**问题，优化传输逻辑。（影响版本：v2.3.3、v2.3.4、v2.3.5）
2. 修复网盘编辑文件标签时输入框高度为0的UI问题。
3. 修复 `IO` 接口文件重命名失败的返回信息不明确问题。
4. 修复 `dgmdate()` 函数周级时间显示与 `title` 属性不一致问题。
5. 修复用户中心语言设置缺失问题。
6. 修改 `$_G['siteurl']` 生成方式，解决内网穿透场景下的URL错误。
7. 其他已知bug修复，安全问题修复。

### 优化改进
1. 管理后台、首页、分享页面UI优化。
2. 完善加密函数注释说明，提升代码可维护性。

### 注意事项
1. **离线升级**：从V2.01及以上版本的用户升级到V2.3.6需要执行升级程序。本次更新包含关键问题修复，建议所有用户尽快升级，以获得更好的使用体验。
2. **PHP版本**：仅支持php7.0+的PHP版本使用，请确保你的服务器环境符合要求。
3. **清理缓存**：无论是在线升级还是离线升级，都需要在升级后前往系统工具中清理系统缓存，以保证系统正常运行。

## V2.3.5 主要更新内容
> **发布于: 2025.6.25**

### 一、网盘应用升级与优化
#### （一）新增功能
- 网盘操作菜单新增“文件副本创建”功能选项。
- 新增网盘群组选择成员权限控制逻辑：默认情况下，所有用户仅能选择所在部门成员或可管理的部门成员；管理员可通过设置切换为 “选择全站所有成员”。
- 网盘目录权限设置和分享权限设置中新增评论选项（默认关闭），同时网盘的评论功能跟随评论权限生效。
#### （二）功能修复
- 修复网盘回收站模块数据加载异常问题。
- 修复网盘收藏功能无法滚动加载数据的问题。
- 修正网盘文件类型修改后界面元素错位的显示异常。
- 解决网盘复制/剪切文件粘贴后仍显示粘贴按钮的问题。
- 修复网络挂载存储空间文件粘贴功能失效问题。
- 修复复制文件类型为链接时，复制后的文件无法跳转到链接的问题。
- 解决网盘多选文件时类型未翻译的问题。
- 修复网盘批量上传文件夹时，因并发创建导致的目录冗余问题。
- 修改网盘查看机构部门与我的网盘属性时不显示大小问题。

#### （三）交互与体验优化
- 优化网盘UI与交互体验。
- 重构网盘最近使用记录的排序算法，采用访问时间与编辑时间综合排序机制。
- 优化移动端网盘右键菜单的触控交互设计。
- 优化分享页面UI。
- 分享页右键菜单移动端交互优化。
- 网盘合并 layui.use 调用，减少模块重复初始化，优化性能。
- 优化网盘 json.php响应速度，移除冗余代码，减少执行开销。

### 二、机构用户功能改进
- 支持机构部门管理员使用批量导入与导出用户功能。
- 修复新建用户时，点击“随机密码”无反应的问题。
- 解决机构用户、应用市场、系统设置、文件管理中选择机构部门时无法选择下级的问题。
- 一些已知问题修复。
- 修复端侧边栏滚动功能异常问题。
- 修改编辑用户时不能删除最后一个部门问题。

### 三、系统界面与交互优化
- 修复提示消息框right-bottom位置的关闭动画错误。
- 设置提示消息框默认类型。
- 修正因style拼写错误导致提示消息框下次弹出位置偏移的问题。
- 重写光年模板的提示消息框功能。
- 优化通知中心通知列表UI。
- 修改默认首页UI。
- 在线应用市场应用列表适配移动端。
- 调整应用权限逻辑：需登录才能访问的应用直接跳转至登录页面。
- 新增登录模板4（与官方演示站一致），支持直接选择用户登录。
- 管理页支持查看在线用户列表。
- 管理员界面简化PHP扩展信息展示。
- 管理员环境信息检查更名为“服务器信息”，并添加更多信息显示。
- 解决部分场景下在线会话表用户名字段为空的问题。
- 删除用户中心加载多余组件问题。
- 在用户中心页面新增手机号码展示模块。
- 将登录页面账号输入框的提示文案统一规范为"邮箱/用户名/手机号码"。

### 四、系统功能修复与增强
- 修复系统日志模块导航激活状态判断错误。
- 增强AJAX错误处理机制。
- 修复站点在部分环境下端口显示不正确的bug。
- 修复SMTP邮件发送问题并增强错误处理。
- 修正取回密码邮箱信息中取回密码链接错误的问题。
- 优化密码找回流程：仅保留邮箱验证，提升找回效率。
- 新增计划任务独立触发机制，支持通过命令行或系统定时任务触发。
- 修复用户资料页面空间使用情况数据获取不正确的问题。
- 限制未登录用户查看用户资料。
- 修复允许上传的文件后缀设置为多个时，网盘应用无法上传文件的问题。
- 邮箱绑定与修改功能对PHP8运行环境的兼容性适配。
- 优化站点内链接生成短链接的机制，取消域名IP的固定绑定以支持域名/IP地址的动态更新。
- 修复部分插件重命名文件时报错问题。
- 修复模板调用路径问题，确保新代码生效。
- 修改部分场景的机构部门框能选择群组问题。
- 修复一些已知问题。

### 注意事项
- 离线升级：从2.3.2、2.3.3、2.3.4升级到2.3.5的用户无需执行升级程序，覆盖后在系统工具中清理缓存即可。
- PHP版本：仅支持php7.0+的PHP版本使用。
- 清理缓存：无论是在线升级还是离线升级都需要在升级后前往系统工具中清理系统缓存。

## V2.3.4 主要更新内容
> **发布于: 2025.5.28**
### **网盘应用相关**
1. **添加网络挂载**
- 将 dzz1.0 中“我的云”功能迁移至 dzz2.0，实现云存储与云存储、云存储与云应用间通信，方便文件在云存储间灵活迁移，支持第三方应用编辑和管理云存储文件，成员可接入私有网盘、云笔记等统一管理，提升办公效率。
2. **版本管理**  
   - 新增文件历史版本查看、删除、版本描述功能
   - 修复历史版本数据加载不全问题
3. **标签管理**：修复文件类型标签无法删除问题
4. **交互优化**：上传失败时显示明确错误提示
5. **UI适配**：全面适配光年模板样式

### **分享系统改进**
1. **界面适配**  
   - 支持明暗主题色切换  
   - 优化移动端多选操作体验
2. **权限修复**  
   - 修复禁用预览时无法访问文件夹问题  
   - 解决无权限PDF文件被意外打开问题

### **核心功能优化**
1. **性能提升**  
   - 优化POST数据处理效率  
   - 提升数据表格加载速度
2. **安全增强**  
   - 密码设置增加非法字符拦截  
   - 强制要求PHP7.0+运行环境  
   - 移除MAGIC_QUOTES_GPC依赖
3. **管理功能**  
   - 文件管理支持数据打印/导出  
   - 后台展示PHP扩展信息  
   - 修复默认首页设置失效问题
   - 支持显示已关闭与未安装应用，未安装应用还支持一键安装，方便离线安装的用户。

4. **统一文件系统接口**
- 现在的文件操作接口统一整合为`IO`类通用方法，强制要求所有文件系统操作通过`IO`类调用（示例：`IO::getStream($path)`）。开发者需检查并替换所有旧文件操作接口为`IO`类方法，删除非保留的旧接口调用。
- 保留的特殊接口：`io_dzz::uploadToattachment`、`io_dzz::UploadSave`、`io_dzz::linktoimage`、`io_dzz::linktovideo`、`io_dzz::linktourl`。

### **用户体验改进**
1. **界面交互**  
   - Layui文件选择框自适应尺寸  
   - 通知消息定位修复(right-bottom)  
   - 动态刷新登录验证码
   - 其他已知问题优化
2. **数据显示**  
   - 普通成员文件管理视图优化  
   - 修正系统报错时间显示格式

### **系统维护与修复**
1. **代码清理**  
   - 移除mysql_connect等残留代码  
   - 清理分享页面冗余逻辑  
   - 修复dimplode函数类型错误
2. **安装部署**  
   - 补充网盘计划任务配置  
   - 优化系统升级流程速度
3. **问题修复**  
   - 修复机构部门/用户选择异常  
   - 解决PDF预览图案缺失问题  
   - 修复未传mod参数报错  
   - 站点关闭时消息提醒失效修复
   - 其他已知问题修复
   - 修复云存储不能添加 FTP 的问题

### **组件更新**
- Layui框架升级至v2.11.1  
- UEditor升级v4.4.0（支持DeepSeek/OpenAI）

### 注意事项
- 接口迁移要求：开发者请注意旧版文件操作接口（非 io_dzz 保留方法）需全面迁移至 IO 类，否则可能导致功能异常。
- 离线升级：从2.3.2、2.3.3升级到2.3.4的用户无需执行升级程序，覆盖后在系统工具中清理缓存即可。
- PHP版本：仅支持php7.0+的PHP版本使用。

## V2.3.3 主要更新内容
> **发布于: 2025.4.16**
### **修复**
1. **已知问题修复**
   - 修复了一些已知问题，提升系统稳定性。
   - 修复了网盘移动端上传文件受损无法打开的问题。
   - 修复上传分块大小会变成 0 导致上传文件失败或受损的问题。
   - 修复光年模板加载页面时抖动问题。
   - 修复网盘应用移动端在部分浏览器中不支持加载更多文件的问题。
   - 修复部分情况下无法正常更新用户状态信息的问题。
   - 修复网盘应用移动端部分情况下目录权限不正确的问题。
   - 修复在网盘应用回收站无法恢复机构部门删除的文件的问题。
   - 修复默认模板下普通用户使用文件管理和分享管理可以查看所有数据的问题。
   - 修复网盘应用在 Linux 环境下部分语言不能翻译的问题。
   - 修复数据表格点击重置按钮后不按类型加载数据的问题，并添加了刷新按钮。
2. **PHP8 兼容性修复**
   - 解决了 PHP8 环境下的多个致命问题，包括加密解密、验证码显示、新建网址、权限控制、文件缩略图生成及网盘应用功能等。
### **新增功能**
1. **前端框架升级**
   - 主程序前端框架升级至 Bootstrap4。
2. **网盘应用分享功能增强**
   - 分享文件权限新增上传功能，支持选择未登录用户进行文件上传。
   - 分享文件界面支持选择打开方式，支持新建文件夹与上传文件。
   - 群组管理新增群组空间大小修改功能。
3. **安全与登录管理**
   - 支持设置尝试登录次数及次数用完后的禁用时间。
   - 支持设置用户在线时间更新时长。
4. **大文件读取优化**
   - `index.php&mod=io&op=getStream` 接口改为使用 `fread` 分段读取，支持分块请求与普通请求，优化大文件读取性能。
### **优化**
1. **体验优化**
   - 优化了部分已知的模板 UI 问题，提升用户体验。
   - 优化光年模板的通知消息 UI 效果。
   - 升级 `1avui` 至 `v2.9.23` 版本。
   - 优化了直接访问 `admin.php` 时的跳转逻辑，现在用户可以直接跳转到管理页。
   - 优化编辑器中插入的图片类宽高不能自定义的问题。
   - 优化了网盘右键子菜单低概率不能选择的问题。
2. **框架冲突解决**
   - 打开文件与选择位置支持 `lyear`，解决 Bootstrap 与其他框架同时存在时的冲突问题。
3. **PDF 表单支持**
   - 网盘支持新建 PDF 表单，以支持使用 OnlyOffice 的表单功能。
### 注意事项
- 离线升级：从2.3.2升级到2.3.3的用户无需执行升级程序，覆盖后在系统工具中清理缓存即可。
- PHP版本：仅支持php7.0+的PHP版本使用。
- 插件升级：升级至2.3.3版本后需要前往应用市场更新已安装的插件以确保插件能正常使用。

## V2.3.2 主要更新内容
> **发布于: 2025.1.16**
### 网盘功能优化
- SQL语法错误修复：解决了SQL语法报错的问题，提升了系统的稳定性。
- 语言翻译完善：修复了取消收藏功能中语言未翻译的问题，提升了用户体验。
- 分享权限设置：新增分享文件时设置分享权限的功能，包括禁用下载、仅登录使用、可编辑以及禁用预览权限，还支持未登录用户编辑保存分享文件。
### 应用管理功能增强
- 离线升级支持：在应用管理界面增加了本地升级按钮，支持离线升级，简化了操作流程。
- 版本限制检测：导入应用时新增版本限制检测功能，确保应用与系统兼容。
- 用户体验提升：将分享管理、文件管理、机构用户应用由管理员应用转变为成员应用，提升了用户体验。
### 系统优化与安全性提升
- 提示页面改进：提示页面增加返回首页选项，解决了重复跳转问题。
- 默认首页设置：网盘应用在首次安装时自动设置为默认首页，方便用户快速访问。
- 默认内置应用：网盘、pdf阅读器、图片预览、DPlayer等应用被设置为默认内置应用，随系统安装，无需单独安装。
- 评论管理页面：新增评论管理页面，便于管理员或成员管理评论内容。
- 短连接管理：在分享管理的类别选项中增加了短连接，管理员可以方便地查看和管理所有的短连接。
- layui数据表格：系统日志、文件管理、评论管理、分享管理采用layui数据表格重构页面，使界面更加友好、便捷。
- 站点关闭处理：优化站点关闭时已登录用户的跳转逻辑，避免重复登录提示。
- 新增前端UI：前端UI模板新增光年模板5，系统及部分应用市场应用已适配。用户可在系统设置中切换模板，未适配的应用不受影响。
- 浏览器消息提醒：加入了调用浏览器消息提醒接口函数（dzzNotification），提高了用户交互的及时性。
- 应用权限检测：插件中加入appperm函数文件，开发者可以调用该文件实现应用权限检测，提升了管理的灵活性。
- 升级提醒：新增升级提醒开关功能，用户可自由选择系统或插件升级提醒，或全部不提醒。
- 移除插件：移除应用库插件，简化系统结构。
- 编辑器更新：UEditorPlus编辑器更新到4.2.0，并支持插入iframe框架内容。
- 安全与稳定性：修复了其他已知bug和安全问题，提升系统的稳定性和安全性。
### 注意事项
- 离线升级：本次离线升级的用户需执行升级程序，以确保系统的正常运行。
- PHP版本：仅支持php7.0~php8.0之间的PHP版本使用。

## V2.3.0 主要更新内容
> **发布于: 2024.10.28**
### **一、功能优化**

1. 优化站点关闭时登录页不能显示站点logo的问题，提升用户体验。
2. 系统工具新增系统概览功能，方便管理员快速了解系统整体状态。
3. 系统工具增加文件权限检查功能，确保文件安全。
4. 系统日志增加记录设备信息和用户UID功能，增强日志记录的详细性。
5. 优化系统日志搜索UI，提高搜索效率。
6. 个人中心增加最近在线时间、添加时间、邮箱、登录记录信息显示，丰富用户个人信息。
7. 个人中心添加个人名片页面入口，方便用户展示个人名片。
8. 文件管理增加更多信息查看，包括直链地址、文件引用数、是否在回收站信息等，提升文件管理便捷性。
9. 通知中心增加来源地址，并优化UI，提升通知信息的可读性。
10. 编辑器升级为UEditorPlus，提升编辑功能和使用体验。

### **二、问题修复**

1. 修复关闭验证码的情况下注册用户提示验证码错误的问题，确保注册流程顺畅。
2. 修复访问用户资料管理时左侧栏没有显示当前位置的问题，提升用户导航体验。
3. 修复当用户资料字段设置在注册页显示时不生效的问题，确保用户资料字段正确显示。
4. 修复分享页面文件缺失的问题，保障文件分享功能的正常使用。
5. 修复绑定邮箱翻译错误的问题，确保翻译准确性。
6. 修复文件历史版本达到版本个数控制后不能进行再保存的问题。
7. 其他已知bug修复，安全问题修复。


### **三、系统适配与升级**

1. IP地址适配IPV6环境，提升系统的网络兼容性。
2. 适配PHP7.4，确保系统能够在最新的PHP环境下稳定运行。

### **四、新增功能**

1. 评论组件增加IP、设备信息记录，增强评论管理的安全性。
2. 支持使用系统手机号登录，提升用户登录的便捷性。
3. 机构用户用户信息处添加注册时间、注册IP、添加时间，方便管理员管理用户信息。
4. 增加系统出现错误时通知管理员的功能，确保系统问题能够及时得到处理。

## DzzOffice在线更新方法

1. 进入您原来的系统，关闭您的站点。进行数据备份；
2. 备份文件（如果有程序文件或风格文件的改动）；
3. 进入 管理 -> 系统工具 -> 在线更新，按提示完成更新；
4. 系统工具 -> 更新系统缓存；
5. 系统设置 -> 打开站点。

## DzzOffice 离线更新方法

1. 进入您原来的系统，关闭您的站点。进行数据备份；
2. 备份文件（如果有程序文件或风格文件的改动）；
3. 下载并解压缩最新版的程序包；
4. 程序包解压缩后，并且将文件上传到网站根目录覆盖；
5. 访问 http://您的域名/install/update.php。
6. 按照程序提示，直至所有升级完毕。删除install/update.php 程序，以免被恶意利用。
7. 进入管理员桌面，更新缓存。
8. 系统设置 -> 打开站点。