<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */

if (!defined('IN_DZZ')) {
    exit('Access Denied');
}

$lang =
    [
    'database_export_custom_invalid' => 'You need to select at least one data table for backup',
    'database_export_file_invalid' => 'Data files cannot be saved to the server. Please check the directory properties',
    'admin_navtitle' => 'Administration Center',
    'more_options' => 'More Options',
    'add_storage_location' => 'Add Storage Location',
    'storage_location' => 'Storage Location',
    'space_management' => 'Space Management',
    'app_management' => 'Application Management',
    'type_management' => 'Category Management',
    'photograph_class' => 'Image Category',
    'version_information' => 'Version Information, e.g.',
    'none_write_add_theme' => 'No theme has been added yet',
    'illegal' => 'Illegal',
    'data_set' => 'Data Settings',
    'user_name' => 'User Username',
    'user_name_email' => 'Username or Email',
    'avatar' => 'Avatar',
    'data_item_list' => 'Data Item List',
    'data_edit' => 'Data Item Edit',
    'identifier' => 'Identifier',
    'data_show' => 'Display on Data Page',
    'add_data' => 'Add Data Item',
    'identifier_use' => 'This identifier is already in use. Please change it',
    'data_name' => 'Data Item Name',
    'choosable_data' => 'Selectable Data Items',
    'data_del_success' => 'Data item deleted successfully!',
    'data_name_empty' => 'Data item name cannot be empty',
    'form_type' => 'Form Type',
    'HtmlInputText' => 'Single-line Text Box',
    'HtmlTextArea' => 'Multi-line Text Box',
    'radio' => 'Radio Button',
    'checkBox' => 'Check Box',
    'combobox' => 'Drop-down Menu',
    'more_choose_list' => 'Multi-select List Box',
    'option_values' => 'Optional Values',
    'beijing' => 'Beijing',
    'shanghai' => 'Shanghai',
    'regular_verification' => 'Regular Expression Verification',
    'submit_hou' => 'After Submission',
    'data_page' => 'Data Page',
    'department_visible' => 'Visible to This Department',
    'institution_visible' => 'Visible to This Institution',
    'business_card' => 'In Business Card',
    'business_card_show' => 'Display in Business Card',
    'registration_page' => 'In Registration Page',
    'registration_page_display' => 'Display in Registration Page',
    'allow_search' => 'Allow Search',
    'no_allow_search' => 'Disallow Search',
    'result_ranking' => 'Result Sorting',
    'pass_subtract' => 'Descending',
    'pass_add' => 'Ascending',
    'fuzzy_search' => 'Indicates support for fuzzy search',
    'authentication_code' => 'Authentication Code',
    'contact_administrator' => 'Real-name authentication is not enabled yet. Please contact the administrator',
    'contact_administrator1' => 'You do not have permission for real-name authentication. Please contact the administrator',
    'contact_administrator2' => 'You do not have authentication permission. Please contact the administrator',
    'contact_administrator3' => 'You do not have permission to review data. Please contact the administrator',
    'organization_user_manage' => 'Institution and User Management',
    'enterprise_binding' => 'Enterprise Account Binding',
    'enterprise_little_helper' => 'Enterprise Assistant',
    'enterprise_little_helper_set' => 'Enterprise Assistant Settings',
    'data_synchronization' => 'Data Synchronization',
    'time_set' => 'Time Settings',
    'register_visit' => 'Registration and Access',
    'verification_code_set' => 'Verification Code Settings',
    'sector_set' => 'Department Settings',
    'upload_set' => 'Upload Settings',
    'upload_download_set' => 'Upload/Download Settings',
    'expression' => 'Emoticon',
    'expression_code' => 'Emoticon Code',
    'expression_describing' => 'Emoticon Description',
    'expression_manage' => 'Emoticon Management',
    'words_management' => 'Sensitive Word Management',
    'words_set' => 'Sensitive Word Settings',
    'login_page_set' => 'Login Page Settings',
    'weinxin_company' => 'WeChat Work Account',
    'expression_set' => 'Emoticon Settings',
    'expression_class' => 'Emoticon Category',
    'terrace_name' => 'Platform Name',
    'terrace_name_state' => 'Platform Name, which will be displayed in the browser window title, etc.',
    'user_default_join_department' => 'Default Department for User Joining',
    'thumbnail_size' => 'Thumbnail Size',
    'large_size' => 'Small Image Size',
    'chinese_size' => 'Medium Image Size',
    'max_size' => 'Large Image Size',
    'thumbnail_generation' => 'Thumbnail Generation Mode',
    'active_mode' => 'Active Mode',
    'passive_mode' => 'Passive Mode',
    'file_sharing' => 'File Sharing',

    'innerShare_tips' => 'Disable internal sharing. The internal sharing link will no longer appear in the sharing properties page',
    'platform_copyright' => 'Platform Copyright',
    'platform_beian' => 'Filing Information',
    'platform_beian_tip' => 'Platform filing number, which will be displayed on the login page',
    'platform_keywords' => 'Platform Keywords',
    'platform_seo_keywords' => 'Platform SEO Keywords',
    'Platform_described' => 'Platform Description',
    'Platform_seo_described' => 'Platform SEO Description',
    'statistical_code' => 'Statistical Code',
    'support_html_code' => 'Supports HTML code',
    'no_join_agency_department' => 'Do Not Join Any Institution or Department',
    'department_range' => 'Department Range Settings',
    'all_agencies' => 'All Institution Departments',
    'agency_department' => 'Departments of This Institution',
    'no_section' => 'Cannot @ Department',
    'default_space' => 'Default Space',
    'update' => 'Update',
    'update_success' => 'Updated successfully',
    'detailedness' => 'Details',
    'batch_code_set_expression' => 'Batch Set Emoticon Codes',
    'natural_order' => 'Natural Order',
    'time_or_date' => 'Time and Date',
    'register_immediately' => 'Register Now',
    'verification_unsuccessful' => 'Verification failed',
    'email_send_test' => 'Email Sending Test',
    'update_top_department_name' => 'Update Top-level Department to Site Name',
    'scon_code_send_mobile' => 'Scan the QR code to send to mobile phone',
    'img_background' => 'Image Background',
    'web_background' => 'Web Background',
    'wallpaper' => 'Wallpaper',
    'add_wallpaper' => 'Add Wallpaper',
    'wallpaper_name' => 'Wallpaper Name',
    'wallpaper_site' => 'Wallpaper URL',
    'uploading_wallpaper' => 'Uploading Wallpaper',
    'choosing_wallpaper_categories' => 'Select Wallpaper Category',
    'classification_no_wallpaper' => 'No wallpaper in this category',
    'have_no_wallpaper' => 'No wallpaper added yet',
    'upload_thumbnail' => 'Upload Thumbnail',
    'please_upload_thumbnail' => 'Please upload a thumbnail',
    'optional_name_wallpaper' => 'Optional, name of the wallpaper',
    'color_value_error' => 'Incorrect color value setting',
    'theme_installation_successful' => 'Theme installed successfully',
    'theme_directory_no_configuration_file' => 'No theme configuration file in the theme directory:',
    'subject_catalog' => 'Theme Directory',
    'common_window' => 'Normal Window',
    'file_window' => 'Folder Window',
    'ico_style' => 'Icon Style',
    'right_click_menu_style' => 'Right-click Menu Style',
    'only_upload_img_file' => 'Only image files can be uploaded',
    'must_fill_address_wallpaper' => 'Wallpaper URL must be filled in',
    'add_new_type' => 'Add New Category',
    'data_import_error' => 'Data import error',
    'network' => 'Network',
    'outer_network' => 'External Network',
    'within_network' => 'Internal Network',
    'plug_in' => 'Plugin',
    'extend' => 'Extension',
    'extension' => 'File Extension',
    'text_class' => 'Text Category',
    'application_been' => 'Application already exists!',
    'to_obtain' => 'Re-obtain',
    'type_save_success' => 'Category saved successfully!',
    'already_update' => 'Already updated',
    'submit_tips' => 'Press the Enter key to submit your modifications at any time',
    'starting_migration' => 'Starting migration',
    'migration_completed' => 'Migration completed',
    'routing_name' => 'Route Name',
    'routing_management' => 'Route Management',
    'edit_routing' => 'Edit Route',
    'add_routing' => 'Add Route',
    'used_surplus' => 'Used / Remaining',
    'migration_tool' => 'Migration Tool',
    'tips' => 'Tips',
    'use_default' => '- Use Default -',
    'already_existed' => 'Already Exists',
    'all_audit' => 'All Audits',
    'developer_list' => 'Developer List',
    'developer_name' => 'Developer Name',
    'developer_introduce' => 'Developer Introduction',
    'developer_edit_success' => 'Developer information edited successfully',
    'developer_add_success' => 'Developer information added successfully',
    'developer_del_success' => 'Developer deleted successfully',
    'developers_management' => 'Developer Management',
    'sure_want_delete' => 'Are you sure you want to delete this item?',
    'sure_want_delete_app' => 'Are you sure you want to delete this application (this operation cannot be undone)?',
    'sure_want_delete_theme' => 'Are you sure you want to delete this theme?',
    'installation_package' => 'Installation Package',
    'add_installation_package' => 'Add Installation Package',
    'allow_show' => 'Allow Display',
    'from_desktop_choose' => 'Select from Desktop',
    // 'config' => 'Settings',
    'admin' => 'Admin',
    'Install_and_uninstall' => 'Installation and Uninstallation',
    'uninstall' => 'Uninstall',
    'uninstalled' => 'Not Installed',
    'renewable' => 'Updatable',
    'img_list' => 'Icon List',
    'application_name' => 'Application Name',
    'application_list' => 'Application List',
    'application_site' => 'Application URL',
    'application_ico' => 'Application Icon',
    'application_label' => 'Application Tag',
    'application_introduce' => 'Application Introduction',
    'application_introduce_img' => 'Application Introduction Image',
    'application_name_sky' => 'Application name cannot be empty',
    'application_site_sky' => 'Application URL cannot be empty',
    'application_site_exist' => 'Application URL already exists',
    'application_nonentity' => 'Application does not exist',
    'application_import_successful' => 'Application imported successfully',
    'application_close_successful' => 'Application closed successfully',
    'application_start_successful' => 'Application enabled successfully',
    'application_install_successful' => 'Application installed successfully',
    'application_uninstall_successful' => 'Application uninstalled successfully!',
    'application_upgrade_successful' => 'Application upgraded successfully!',
    'application_import_version_invalid' => 'This plugin is applicable to Dzz! {cur_version}, which is inconsistent with the current version V{set_version}.<br />If you need to force the installation of this plugin, please select "Ignore Version Restriction" when importing the application',
    'application_upgrade_version_invalid' => 'This plugin is applicable to Dzz! {cur_version}, which is inconsistent with the current version V{set_version}.<br />If you need to force the upgrade of this plugin, please click <a href="{url}">Force Upgrade</a>',

    'add_new' => 'Add New',
    'select' => 'Please Select',
    'option' => 'Option',
    'coding' => 'Encoding',
    'display_order' => 'Display Order',
    'order' => 'Order',
    'available' => 'Available',
    'action' => 'Action',
    'ignore' => 'Ignore',
    'reason' => 'Reason',
    'selling_price' => 'Selling Price',
    'original_price' => 'Original Price',

    'dateline' => 'Post Date',
    'dateline_7776000' => 'Three Months',
    'dateline_2592000' => 'One Month',
    'dateline_604800' => 'One Week',
    // 'dateline_all' => 'All',
    'thismonth' => 'This Month',
    'thisweek' => 'This Week',
    'today' => 'Today',
    'thread' => 'Thread',
    'subject' => 'Title',
    'nosubject' => 'No Title',
    'mergeto' => 'Merge To',
    'doings' => 'Activity',
    'blogs' => 'Blog',
    'albums' => 'Album',
    'description' => 'Description',
    'copyright' => 'Copyright Information',
    'attachment' => 'Attachment',
    'file' => 'File',
    'dir' => 'Directory',
    'according_usergroup' => 'By User Group',
    'usernum' => 'Number of Users:',
    'admingroup' => 'Admin Group',
    'forum' => 'Forum Section',
    'square' => 'Forum',
    'uid' => 'User ID',

    'current_contents_without_saving' => 'The current content has not been saved. Are you sure you want to leave?',
    'mail' => 'Email Settings',
    // admin/system/database.html
    //	'nav_db' => 'Database',
    'nav_db_export' => 'Backup',
    'nav_db_export_success' => 'Backup successful',
    'nav_db_export_del_success' => 'Backup deleted successfully',
    'nav_db_export_regain_success' => 'Backup restored successfully',
    'nav_db_import' => 'Restore',
    'nav_db_runquery' => 'Upgrade',
    //	'db' => 'Database',
    'db_export' => 'Data Backup',
    'db_backup_directory' => 'Backup Directory',
    'db_method' => 'Method',
    'db_shell' => 'Shell',
    'db_multivol' => 'Multi-volume',
    'db_zip' => 'ZIP',
    'db_volume' => 'Number of Volumes',
    'db_export_tips' => '<li>The data backup function backs up all Dzz! data according to your selection. The exported data files can be imported using the "Data Restore" function or phpMyAdmin.</li><li>All backups do not include template files and attachment files. To back up templates and attachments, simply download the template/ and data/attachment/ directories via FTP, etc. Dzz! does not provide separate backups for them.</li><li>MySQL Dump is much faster than Dzz! multi-volume backup, but it requires the server to support relevant Shell permissions. At the same time, due to MySQL\'s own compatibility issues, the servers used for backup and restoration usually need to have the same or similar version numbers to proceed smoothly. Therefore, MySQL Dump has risks: if one of the servers for backup or restoration disables Shell, or if import fails due to version compatibility issues, you will not be able to use MySQL Dump for backup or restoration from backup data; Dzz! multi-volume backup has no such restrictions.</li><li>The settings in the data backup options are only for special purposes of advanced users. Before you have a comprehensive and detailed understanding of the database, please use the default parameters for backup; otherwise, it will cause serious problems such as backup data errors.</li><li>The hexadecimal method can ensure the integrity of backup data, but the backup file will take up more space.</li><li>Compressing backup files can make your backup files take up less space.</li>',
    'db_export_type' => 'Data Backup Type',
    'all_data_table' => 'All Data Tables',
    'check_all_data_table' => 'Select All - All Data Tables',
    'db_export_dzz' => 'Dzz! Data',
    'db_export_dzz_uc' => 'Dzz! Data',
    'db_export_custom' => 'Custom Backup',
    'db_export_custom_comment' => 'Select the data tables to be backed up according to your needs',
    //	'db_export_custom_select_all' => 'Select All',
    'db_export_method' => 'Data Backup Method',
    'db_export_shell' => 'System MySQL Dump (Shell) Backup',
    'db_export_multivol' => 'Dzz! Multi-volume Backup - File Size Limit (Unit: KB)',
    'db_export_options' => 'Data Backup Options',
    'db_export_options_extended_insert' => 'Use Extended Insert Format',
    'db_export_options_sql_compatible' => 'Table Creation SQL Format',
    'db_export_options_charset' => 'Force Character Set',
    'db_export_usehex' => 'Hexadecimal Format',
    'db_export_usezip' => 'Compress Backup File',
    'db_export_zip' => 'Compressed Backup',
    'db_export_zip_1' => 'Compress Multiple Volumes into One File',
    'db_export_zip_2' => 'Compress Each Volume into a Separate File',
    'db_export_zip_3' => 'No Compression',
    'db_export_filename' => 'Backup File Name',
    'db_export_file' => 'Data Backup Records',
    'db_export_dzz_table' => 'Dzz! Data Tables',

    'db_import' => 'Data Restoration',
    'db_import_confirm' => 'Importing data inconsistent with the current Dzz! version is highly likely to cause unresolved errors. Are you sure you want to continue?',
    'db_import_confirm_sql' => 'Are you sure you want to import this backup?',
    'db_import_confirm_zip' => 'Are you sure you want to unzip this backup?',
    'db_import_tips' => '<li>This function will overwrite all existing data while restoring backup data. Please ensure the program is closed before restoration, and you can re-enable the program only after the entire restoration is completed.</li><li>Before restoring data, please download the <a href="http://down.dzzoffice.com/restore.zip" target="_blank">restore.php</a> file first, then upload the restore.php file to the "data" directory of the program folder. <b>For the security of your site, please delete the restore.php file immediately after successful data restoration.</b></li><li>You can view the details of the site\'s backup files in the Data Backup Records section, delete expired backups, and import the required backups.</li>',
    'do_import_option' => '<ul><li>You can import backups to restore data in the Data Backup Records section of this page, or restore data by executing <a href="{restore_url}" target="_blank">{restore_url}</a> in your browser</li></ul>',
    'db_import_from_server' => 'From Server (Enter File Name or URL)',
    'db_import_from_local' => 'From Local File',
    'db_import_unzip' => 'Unzip',

    'db_runquery' => 'Database Upgrade',
    'db_recover' => 'Database Recovery',
    'db_runquery_tips' => '<li>For security reasons, Dzz! backend prohibits direct execution of SQL statements by default and only allows the use of content in Common SQL. <br />If you want to write custom SQL upgrade statements freely, you need to modify the setting of $_config[admincp][runquery] in config/config.php to 1.</li>',
    'db_runquery_sql' => 'Dzz! Database Upgrade - Please paste the database upgrade statements below',
    'db_config_admincp' => 'The config file does not set permissions for this operation. Please check the relevant admincp and $_config[\'admincp\'][\'runquery\'] settings in the config/config.php file',
    'db_not_allow_config_admincp' => 'The config file is set to disallow this operation. Please check the relevant admincp and $_config[\'admincp\'][\'dbimport\'] settings in the config/config.php file',
    'db_runquery_denied' => 'Sorry, this function has been disabled. If you need to enable it, please modify the relevant configuration in config/config.php',
    'db_runquery_comment' => 'Note: To ensure successful upgrade, do not modify any part of the SQL statements',
    'db_runquery_select' => 'Existing Solutions',
    'db_runquery_simply' => 'Common SQL Upgrade Statements',
    'db_runquery_createcompatible' => 'Convert Table Creation SQL Format and Character Set',

    // 'cplog_database_export' => 'Data Backup',
    // 'cplog_database_import' => 'Data Restoration',
    'cplog_database_importzip' => 'Data Restoration (ZIP)',
    // 'cplog_database_runquery' => 'Database Upgrade',

    'message' => 'Dzz! Notification',
    'message_redirect' => 'If your browser does not redirect automatically, please click here',
    'message_download' => 'If your browser does not start downloading automatically, please click this link',
    'message_return' => 'Click here to return to the previous page',

    'database_export_filename_invalid' => 'You have not entered a backup file name, or the file name contains sensitive extensions',

    'database_export_multivol_redirect' => 'Multi-volume Backup: Data File #{volume} created successfully. The program will continue automatically',
    'database_export_succeed' => 'Data successfully backed up to server <a href="{filename}">{filename}</a>',
    'database_shell_fail' => 'Shell permission is disabled or the server does not support it. Cannot back up or restore data using MySQL Dump',
    'database_export_dest_invalid' => 'Directory does not exist or is inaccessible. Please check the ./data/ directory',
    'database_file_delete_succeed' => 'Specified backup file deleted successfully ',
    'database_file_delete_invalid' => 'You have not selected a backup file to delete',
    'database_run_query_invalid' => 'Upgrade Error. MySQL Message: {sqlerror} ',
    'database_run_query_succeed' => 'Dzz! Data Structure Upgrade Succeeded. Number of Affected Rows: {affected_rows}',
    'dbcheck_permissions_invalid' => 'Your server environment does not allow database verification. Cannot perform this operation',
    'dbcheck_nofound_md5file' => 'Verification file does not exist. Cannot perform this operation',
    'dbcheck_repair_error' => 'Database repair succeeded, but {errorcount} data fields failed to be repaired<br /><br />{error}',
    'dbcheck_repair_completed' => 'Database repair completed successfully ',
    'dbcheck_ok' => 'Your database is complete and error-free',

    'database_export_multivol_succeed' => 'Congratulations! {volume} backup files created successfully. Backup completed entirely.<br /> {filelist}',
    'database_export_zip_succeed' => 'Data successfully backed up and compressed to server <a href="{filename}">{filename}</a>',
    'tools_updatecache_tips' => '<li>When the site undergoes data restoration, upgrade, or malfunctions, you can use this function to regenerate the cache. Updating the cache may increase server load, so please avoid peak user access times.</li>
                    <li>Data Cache: Update all data caches of the site</li>
                    <li>Template Cache: Update Dzz template, style, and other cache files. Use this when modifications to templates or styles do not take effect immediately</li>',
    // admin/system
    'updatecache' => 'Update Cache',
    'database' => 'Database',
    'database_export' => 'Database Export',
    'database_db_switch' => 'Database Switch',
    'patch' => 'Security Center',
    // 'update'=>'Online Upgrade',
    'cron' => 'Scheduled Tasks',
    'log' => 'System Logs',
    'upgrade' => 'Online Upgrade',
    'nav_updatecache_confirm' => 'Confirm Start',
    'nav_updatecache_verify' => 'Start Update',
    'nav_updatecache_completed' => 'Update Result',
    'tools_updatecache_data' => 'Data Cache',
    'tools_updatecache_tpl' => 'Template Cache',
    'tools_updatecache_blockclass' => 'DIY Module Category Cache',
    'tools_updatecache_waiting' => 'Updating cache, please wait......',
    'update_cache_succeed' => 'All caches updated completely',

    // 'nav_misc_cron' => 'Scheduled Tasks',
    // 'misc_cron' => 'Scheduled Tasks',
    'misc_cron_list' => 'Scheduled Task List',
    'misc_cron_tips' => '<li>Scheduled Tasks is a feature provided by Dzz! that allows the system to automatically execute specific tasks at specified times. You can also easily use it to extend site functions when needed.</li><li>Scheduled Tasks are closely related to the system core. Improper settings may cause hidden risks to site functions, and in severe cases, may render the site inoperable. Therefore, please only add or modify task items when you fully understand the characteristics of Scheduled Tasks and clearly know what you are doing and the possible consequences.</li><li>Unlike other functions, this function sets and displays time based entirely on the site system\'s default time difference, and will not change the displayed or set time value based on the time difference setting of a specific user or administrator.</li>',
    // 'misc_cron_permonth' => 'Monthly',
    // 'misc_cron_perweek' => 'Weekly',
    // 'misc_cron_perday' => 'Daily',
    // 'misc_cron_perhour' => 'Hourly',
    // 'misc_cron_minute' => 'Minute(s)',
    // 'misc_cron_hour' => 'Hour(s)',
    //	'misc_cron_day' => 'Day(s)',
    'misc_cron_week_day_0' => 'Sun',
    'misc_cron_week_day_1' => 'Mon',
    'misc_cron_week_day_2' => 'Tue',
    'misc_cron_week_day_3' => 'Wed',
    'misc_cron_week_day_4' => 'Thu',
    'misc_cron_week_day_5' => 'Fri',
    'misc_cron_week_day_6' => 'Sat',
    // admin/system/log.html
    'user_error_log' => 'User Failed Login',
    // admin/system/cron.html
    'misc_cron_last_run' => 'Last Execution Time',
    'misc_cron_next_run' => 'Next Execution Time',
    // 'misc_cron_run' => 'Execute',
    'misc_cron_edit' => 'Edit Scheduled Task',
    'misc_cron_operation' => 'Run Scheduled Task',
    'misc_cron_edit_tips' => '<li>You are editing a built-in system scheduled task. Unless you have a deep understanding of the Dzz! structure, it is strongly recommended not to modify the default settings.</li><li>Please record the original settings before modification. Improper settings may cause unexpected errors on the site.</li>',
    // 'misc_cron_edit_weekday' => 'Weekly',
    'misc_cron_edit_weekday_comment' => 'Set the day of the week to execute this task. Use "*" for no restriction. This setting will override the "Day" setting below',
    // 'misc_cron_edit_day' => 'Monthly',
    'misc_cron_edit_day_comment' => 'Set the day of the month to execute this task. Use "*" for no restriction',
    // 'misc_cron_edit_hour' => 'Hour(s)',
    'misc_cron_edit_hour_comment' => 'Set the hour to execute this task. Use "*" for no restriction',
    // 'misc_cron_edit_minute' => 'Minute(s)',
    'misc_cron_edit_minute_comment' => 'Set the minute(s) to execute this task. Up to 12 minute values can be set. Separate multiple values with half-width commas ",", leave blank for no restriction',
    'misc_cron_edit_filename' => 'Task Script',
    'misc_cron_edit_filename_comment' => 'Set the execution program file name for this task. Do not include the path. System scheduled tasks are located in the core/cron/ directory',
    // admin/allbackup/template/main.html
    'sure_want_restore_backup' => 'Are you sure you want to restore this backup?',
    'sure_want_delete_backup' => 'Are you sure you want to delete this backup?',
    'sure_want_backup_current_version' => 'Are you sure you want to back up the current version?',
    'create_current_version_backup' => 'Create Backup of Current Version',
    // admin/allbackup/index.php
    'attachment_catalogue_copy_success' => 'Attachment Directory Copied Successfully',


    'visitors_visible' => 'Available to Visitors Only',
    'members_available' => 'Available to Members',
    'section_administrators_available' => 'Available to Organization & Department Administrators',
    'system_administrators_available' => 'Available to System Administrators Only',

    //admin/app/template/app.html
    'application_name_suppliers' => 'Search by Application Name, Supplier, or Application Identifier',
    'supplier' => 'Supplier',
    'group_permissions' => 'Group Permissions',
    'department_available' => 'Available Departments',
    //admin/app/template/top.html
    'open_way_manage' => 'Open Method Management',
    'add_app' => 'Add Application',
    'edit_app' => 'Edit Application',
    //admin/app/template/edit.html
    'app_application_site_text' => '<li>Application URL, which can be a relative path (relative to the site root directory) or a web address</li>
                                        <li>The application URL can contain parameters, e.g.: {dzzscript}?mod=document&op=textviewer&icoid={icoid}</li>
                                        <li>Parameters: Wrap parameters in the URL with "{}". "dzzscript" refers to the desktop main program (i.e., index.php), and "adminscript" refers to the backend management main program (i.e., admin.php). Using these parameters when adding an application improves compatibility and portability.</li>
                                        <li>All fields in the dzz_resources table can be used as parameters</li>',
    'notification_interface' => 'Notification Interface',
    'app_notification_interface_text' => '<li>Application notification interface URL, which can be a relative path (relative to the site root directory) or a web address</li>
                                            <li>Leave blank to disable notifications for this application. After setting the URL, the frontend will query this interface regularly and reflect the results on the interface.</li>
                                            <li>Interface return data format example: {sum:10,timeout:0,notice:[]} means: sum: number of new messages; timeout: polling interval. After the frontend queries this data, a reminder of "10" will appear in the upper right corner of the corresponding application.</li>
                                            <li>Parameters: Wrap parameters in the URL with "{}". "dzzscript" refers to the desktop main program (i.e., index.php), and "adminscript" refers to the backend management main program (i.e., admin.php). Using these parameters when adding an application improves compatibility and portability.</li>',
    'application_provider_name' => 'Application Provider Name',
    'department_permissions' => 'Department Permissions',
    'app_set_application_jurisdiction' => 'Set Department Usage Permissions for the Application. Generally used for scenarios where certain special applications are only allowed to be used by members of specific departments',
    'app_number_fields' => 'This is a multi-input field. Confirm input tags by pressing Enter or ","',
    'app_clear_label' => 'Clear and clear labels help users find and add applications easily',
    'app_support_extension' => 'Supported Extensions',
    'app_not_allowed_open' => 'Disallow Multiple Instances',
    'app_not_allowed_open_text' => '<li>Enter the extensions that this application can open</li>
                                        <li>Special extensions: image (images); link (web links); video (online videos)</li>
                                        <li>This is a multi-input field. Confirm input tags by pressing Enter or ","</li>									
                                        <li>For applications that disallow multiple instances, only one window of the application will be opened (e.g., a player with a playlist)</li>',
    'app_internal_frame' => 'Internal Window',
    'app_internal_frame_text' => '<li>Open in an internal window by default. For some applications that are not suitable for internal opening, you can choose to open them in a new window.</li>
                                    <li>When the application URL is in a format like "dzzjs:", it can only be opened internally, and this setting will not take effect.</li>',

    'app_default_installation_location' => 'Default Installation Location. The application will be installed to the corresponding location by default',
    'app_application_library' => 'In Application Library',
    'app_application_library_text' => 'After unchecking "Show in Application Library", users will not be able to add this application. Generally used for system default-installed applications',
    'show_ico' => 'Show Icon',
    'app_show_ico_text' => 'Select "Hide" to prevent this application from being displayed in the Start Menu, Application Center, etc. Generally used for built-in default-installed applications that do not need to be opened by clicking the application icon',
    'app_Window_mask' => 'Window Mask',
    'app_Window_mask_text' => 'If the content in the application window affects other frontend application windows when the application is not in the foreground, you need to enable the window mask. This is usually required for applications containing Flash content',
    //admin/app/template/appdefault.html
    'universal_application' => 'Universal Applications',
    'tourist_application' => 'Visitor Applications',
    'rank_file_application' => 'Regular Member Applications',
    'system_administrator_application' => 'System Administrator Applications',
    'section_administrator_application' => 'Department Administrator Applications',
    'allowed_delete' => 'Deletion Disallowed',
    'force_installed' => 'Force Installation',
    'force_installed_tip' => 'Force users to install and prevent uninstallation',
    'allow_department' => 'Allow Department Usage',
    'allow_department_tip' => 'Click the application name to edit',
    'clear_application_install' => 'Remove from All Users',
    'appdefault_board_message_text' => '<li>Sorting: The larger the value, the later the position</li>
                        <li>You can set the default installation position to add the app to the user\'s Start Menu by default</li>
                        <li>Apps set to "None" for the default position will not be installed by default</li>
                        <li>Institutional/departmental apps only display exclusive apps for the specific institution or department; member apps do not display institutional/departmental exclusive apps</li>
                        <li>General apps are accessible to all users; they are not displayed in guest apps, administrator apps, or member apps</li>
                        <li>Users can only truly uninstall an app by deleting it from the Start Menu</li>
                        <li>For hidden apps (when "Display Icon" is set to "Hidden" in the app edit page), the default position must also be set here to install the app for users by default (even though the app will not be displayed in the corresponding position for users)</li>
                        <li>Clear: Remove this app from all users who have already installed it. For apps that cannot be deleted, the app will be re - added when the user logs in again</li>',

    'cron_not_found' => 'Scheduled task not found',
    'crons_filename_illegal' => 'The task script filename you entered contains illegal characters',
    'crons_filename_invalid' => 'The specified task script file ({cronfile}) does not exist or contains syntax errors',
    'crons_time_invalid' => 'You have not specified the execution time or conditions for the scheduled task',
    'crons_run_invalid' => 'The script file ({cronfile}) for the task you want to run does not exist or contains syntax errors; the task cannot be run',
    'crons_run_succeed' => 'Scheduled task executed successfully ',
    'crons_succeed' => 'Scheduled task updated successfully ',
    'inbuilt' => 'Built - in',
    //admin/app/template/extopen.html
    'extopen_board_message_text' => '<li>Sorting: You can click and drag the app icon to sort</li> 
						<li>Sort values are only valid for the same file extension</li>
						<li>Sorting: You can click the app name to set it as the default opening method</li>
						<li>When setting a default app, only one app can be set as the default for the same file extension</li>
						<li>The set default app is only valid if the user has not set a default. Once the user manually sets a default, the user\'s setting will take precedence</li>',
    //admin/app/template/import.html
    'import_paste_text' => 'Paste Text',
    'import_upload' => 'Upload Data File',
    'import_paste_data' => 'Paste Data Content',
    //admin/app/template/list_available.html
    'list_uninstall_application' => 'Are you sure you want to uninstall this app? All data of the app, including internal app data, will be deleted and cannot be recovered?',
    'list_no_related_application' => 'There are no related apps yet; apps will be displayed here after being disabled',
    //admin/app/template/list_upgrade.html
    'list_update_application' => 'There are no apps available for update',
    //admin/app/template/list_notinstall.html
    'list_notinstall_application' => 'There are no apps available for installation yet. After decompressing the app installation package into the dzz/ directory, you can select and install it here',
    //admin/app/cp.php
    'list_cp_Application_directory_exist' => 'The app directory does not exist. Please place the app files into {app_path}/{identifier} and try again!',
    'list_cp_Application_delete' => 'The app does not exist or has been deleted',
    'list_cp_Application_allocation' => 'There is no app configuration file in the app directory',
    'list_cp_del_Application' => ', please manually delete the app file directory: dzz/',
    'list_cp_Application_tautology' => 'The app configuration file does not exist. Please place the app configuration file into the app directory and try again',
    //admin/app/cloud/index.php
    'cloud_index_api' => 'API file: io_',
    'cloud_index_php' => '.php does not exist!',
    'cloud_index_sign' => 'Marked as',
    'cloud_index_sign1' => 'The API is in use and cannot be deleted. If you are sure that this API is no longer in use, please delete it via FTP',
    'cloud_index_sig2' => '.php and try again',
    // admin/cloud/template/add.html
    'add_cloud' => 'Add Cloud',
    'designator' => 'Designator',
    'cloud_add_designator_text' => '<li>Designator: A unique identifier for this type, unique across the entire site, case - sensitive</li>
							<li>Relevant APIs will be organized and established based on this designator</li>
							<li>For detailed settings and instructions, please refer to the relevant API development documentation</li>',
    'cloud_add_root_directory_text' => '<li>Set the root directory; some cloud drives require setting a root directory. Note: Directory names are case - sensitive</li>
								<li>For example, Baidu Cloud Drive can only access files under apps/Cooperative Website Name/</li>
								<li>Example: /apps/dzzoffice, do not add / at the end</li>
								<li>For detailed settings and instructions, please refer to the relevant API development documentation</li>',
    'cloud_add_API_KEY_text' => '<li>Developer API KEY applied on the API official website</li>
								<li>For example, for Baidu Cloud Drive, you need to apply to activate a cooperative site on http://open.baidu.com. After approval, you can obtain the API Key and Secret Key for the app</li>',
    'cloud_add_Secret_KEY_text' => '<li>Developer Secret Key applied on the API official website</li>
								<li>For example, for Baidu Cloud Drive, you need to apply to activate a cooperative site on http://open.baidu.com. After approval, you can obtain the API Key and Secret Key for the app</li>',
    'cloud_add_data_table_name' => 'Data Table Name',
    'cloud_add_data_table_name_text' => '<li>Data table name, excluding the table prefix. For example, if the database table name is dzz_connect_pan, you should enter connect_pan here</li>',
    // admin/cloud/template/cloud.html
    'cloud_cloud_board_message_text' => '<li>Sorting: The larger the value, the later the position.</li>
						<li>The cloud settings here are basic settings for the entire site and require support from corresponding API files to take effect.</li>
						<li><span class="text-danger">After the cloud is disabled, related addition services (such as the cloud icon not appearing in "Add Cloud", and the related storage locations and routing rules in the enterprise drive becoming invalid) will be suspended, but the files that have been added and the user cloud drives can still be used normally.</span></li>
						<li>It is recommended to be added by developers, and once added, it cannot be deleted (except for those that have never been enabled).</li>',
    // admin/cloud/template/edit.html
    'cloud_edit_designator_text' => '<li>Designator: A unique identifier for this type, unique across the entire site, case - sensitive</li>
							<li>Relevant APIs will be organized and established based on this designator</li>
							<li>For detailed settings and instructions, please refer to the relevant API development documentation</li>',
    'whether_allow_users_add' => 'Whether to Allow Users to Add',
    'using_user' => 'Using Users',
    'cloud_edit_enabled_name' => 'You must enable "$cloud[name]" first before setting this item',
    'cloud_edit_enabled_cloud' => 'Set to "No", this cloud will not appear when users click "Add Cloud" in "My Cloud"',
    // admin/cloud/template/left.html
    'cloud_set' => 'Cloud Settings',
    // admin/cloud/template/movetool.html
    'target_location' => 'Target Storage Location',
    'cloud_movetool_designator_text' => 'Designator: A unique identifier for this type, unique across the entire site, case - sensitive',
    'original_location' => 'Original Storage Location',
    'cloud_movetool_file_type_text' => '<li>Please enter the file extensions, separated by commas (half - width) for multiple extensions</li>
								<li>Leave blank for no restriction</li>',
    'cloud_movetool_file_size_text' => '<li>Leave blank for no restriction on this item</li>
								<li>When both "Greater Than" and "Less Than" are filled in, it is an "and" relationship. If you want only one item to take effect, leave the other blank</li>',
    'cloud_movetool_board_message_text' => '<li>This tool can migrate files between different storage locations.</li>
					<li>This tool can only transfer files in the enterprise drive; files directly in the cloud drive are not within the scope of transfer</li>
					<li>Through filtering conditions, you can migrate only part of the files</li>',
    'cloud_movetool_storage_location' => 'The target storage location cannot be the same as the original storage location',
    'cloud_movetool_home_position' => 'There is no data to be migrated in the original location',
    // admin/cloud/template/movetool_run.html
    'cloud_movetool_board_message_text1' => '<li>Please do not close this page before completion.</li>
						<li>For large files, the progress bar may remain inactive for a long time.</li>',
    'ignore_continue' => 'Ignore and Continue',
    'cloud_movetool_file_neglect' => 'files have been ignored!',
    // admin/cloud/template/router.html
    'priority' => 'Priority',
    'use_storage' => 'Use Storage',
    'routing_rule' => 'Routing Rule',
    'router_routing_failure' => 'Due to the disabling of the cloud "$value[bz]", this route is temporarily invalid',
    'router_board_message_text' => '<li>After the cloud is disabled, the related routes will also become invalid. Before taking effect, this route will be ignored</li>
						<li>Priority: The larger the value, the higher the priority. The system will select the storage in descending order of priority. Once the conditions are met, it will no longer query routes with lower priority.</li>
						<li>When adding routes, note to set a higher priority for routes that need to take effect first and routes with a narrow scope of condition restrictions</li>
						<li>When no routes are added, the system will directly use the default storage location in "Space Management"</li>',
    // admin/cloud/template/space.html
    'space_storage_failure' => 'The cloud "$value[bz]" has been disabled, and this storage location is temporarily invalid',
    'space_del_storage' => 'Are you sure you want to delete this storage?',
    'space_board_message_text' => '<li>After the cloud is disabled, the related storage locations will also become invalid. New files will not use this storage location, but existing files can still be accessed normally</li>
						<li>Sorting: The larger the value, the later the position. The storage with the higher sorting will be used first when no default is set.</li>
						<li>Used: Only represents the size of the storage space currently used by the system (it cannot represent the total usage of the storage location); Remaining: Represents the size of the remaining available space.</li>
						<li>The system first selects the storage location through routing rules; if there is no matching route, the default location here is used</li>
						<li>When the system fails to upload to the selected target storage location, it will use the server disk by default.</li>
						<li>The server disk is the default basic storage and cannot be deleted. Others can only be deleted when the used data is 0.</li>
						<li>Data can be migrated between different storage locations using the migration tool</li>',
    // admin/cloud/edit.php
    'cloud_edit_php' => '.php does not exist!, cannot be set',
    // admin/cloud/movetool.php
    'storage_location_exist' => 'The original storage location does not exist',
    'target_storage_location_exist' => 'The target storage location does not exist',
    'movetool_move_data' => 'There is no data to be moved',
    // admin/dzzmarket/edit.html
    'dzzmarket_edit_carousel' => 'Carousel Images',
    'dzzmarket_edit_application' => 'App Supplier, leave blank to call the developer name',
    'dzzmarket_edit_original_price' => 'The original price will be displayed in the form of',
    'dzzmarket_edit_zero_price' => '; a selling price of 0 means free',
    'dzzmarket_edit_character' => 'Maximum 255 characters, will be displayed on the list page',
    'dzzmarket_edit_zip' => 'Installation package, package multiple files into a single zip package',
    'dzzmarket_edit_pull' => 'Drag and drop the installation package here',
    // admin/dzzmarket/edit_type.html
    'edit_type_application' => 'Select the type of app you want to create',
    'edit_type_dzzoffice' => 'Apps that provide various functions for DzzOffice',
    'edit_type_dzzoffice1' => 'Themes and styles provided for DzzOffice',
    'edit_type_dzzoffice2' => 'Extensions and function enhancements provided for DzzOffice',
    // admin/function/function_admin.php
    'function_admin_error' => 'Data type error, only app data can be imported',
    // admin/icon/main.html
    'main_del_icon' => 'After deleting the icon, the icons that have added this domain name before will display the default icon. Are you sure you want to delete the selected icons?',
    // admin/icon/editicon.html
    'main_dzzoffice' => 'Website domain name: e.g. (dzzoffice.com, cs.dzzoffice.com, etc., usually no need to enter the www prefix)',
    'main_matches_regular' => 'Website Matching Regular Expression',
    'main_matches_regular_text' => 'A unique expression for matching this website, which can be a regular expression such as: /mod=corpus&op=list/i or ordinary characters such as: mod=corpus&op=list, leave blank to only match the domain name',
    'main_matches_priority' => 'Matching Priority',
    'main_matches_priority_text' => 'Matching order under the same domain name, the larger the number, the higher the priority. Set this item when there is overlap in the matching areas',
    'main_extensions' => 'Feature Suffix',
    'main_extensions_text' => 'Set the feature suffix of this website; the corresponding app can be called to open this website through the feature suffix; for example, the feature suffix of the task board can be set to: task',
    // admin/member/main.html
    'member_main_delete' => 'Are you sure you want to delete this user? All data and files of this user will be cleared and cannot be recovered',
    // admin/member/profileset.html
    'profileset_delete' => 'Are you sure you want to delete this profile item? This operation cannot be recovered',
    // admin/member/profileset_edit.html
    'profileset_edit_delete' => 'Maximum number of characters that can be entered or maximum number of items that can be selected; for image type, it limits the size of the uploaded image (unit: KB)',
    'profileset_edit_value' => 'One value per line, for example, enter',
    'profileset_edit_edit' => 'Regular expression for verifying input data, please modify with caution',
    'profileset_edit_hide' => 'If set to hidden, it will not be displayed on the profile page regardless of personal privacy settings',
    // admin/member/verifyset.html
    'verifyset_members_verify_text' => '<li>The system supports real - name authentication by default; other authentications can be customized by users</li>
				<li>After enabling the corresponding authentication, the corresponding authentication column will appear in the user profile management</li>',
    // admin/member/verifyset_edit.html
    'verifyset_verify_synopsis_text' => 'Brief introduction to authentication, will be displayed on the user authentication page, supports UBB',
    'verifyset_choosable_data_text' => 'Note: The profile items checked here will only be displayed on the corresponding authentication page, not in the user\'s basic profile, and will also be valid when this authentication is not enabled.',
    'verifyset_verify_group_text' => 'Set the user groups allowed to participate in the authentication, you can hold CTRL to select multiple, leave blank to allow all to participate in the authentication',
    // admin/setting/assistant.html
    'assistant_app' => 'This is a default app through which you can push messages to the entire company. Such as follow - up success notifications, company files, announcements, etc.',
    // admin/setting/main.html
    'setting_main_section' => 'Select the default department for newly registered users to join; if not selected, they will not join a department by default',
    'setting_main_thumbnail_size' => '<li>System thumbnail size specifications</li>
							<li>Can be adjusted as needed; the system will call thumbnails of the corresponding size according to the settings here</li>',
    'setting_main_file_sharing' => 'Disable sharing: Sharing and download links will no longer appear on the file properties page, except for Dzz Documents, URLs, and online videos',
    'setting_main_html_size' => 'HTML code is supported; the visible area size of the panel is 263*235',
    'setting_main_dzz' => 'Select "Yes" to display the commercial authorized user link in the footer. The link will point to the official Dzz! website, through which users can verify whether the Dzz! they are using has obtained commercial authorization',
    'prompt_leave_platform' => 'Prompt for leaving the platform',
    'setting_main_leave' => 'Toggle for prompting when leaving the platform. If set to "No", no prompt will appear when refreshing the page',
    'close_terrace' => 'Close the platform',
    'setting_main_close_terrace' => 'Temporarily close the platform; other users cannot access it, but this will not affect administrator access',
    'setting_main_cause' => 'Reason for closing the platform',
    'setting_main_board_message' => 'Prompt message displayed when the platform is closed',
    'setting_main_suffix' => 'File extensions prohibited from running',
    'setting_main_suffix_text' => '<li>Set file extensions that are prohibited from running; separate multiple extensions with half-width commas.</li>
                                <li>For security reasons, extensions that can be exploited (such as php, asp, jsp) usually need to be set here to prohibit their execution.</li>
                                <li>The system will take special measures to prevent files with the extensions set here from running, thereby improving system security.</li>',
    'upload_block_size' => 'Upload block size',
    'upload_block_size_text' => '<li>Set the size of each block for chunked upload. When the uploaded file is larger than this value, the upload program will upload it in chunks. 5M is recommended.</li>
                        <li>Too large or too small block sizes will affect upload performance; please adjust this parameter according to server settings</li>
                        <li>The block size must be smaller than the values of post_max_size and upload_max_filesize set in php.ini</li>
                        <li>The block size must be smaller than the value of client_max_body_size set in nginx</li>
                        <li>Do not set it to 0, otherwise the upload function of the entire site will be affected, and files cannot be uploaded or may be damaged</li>',
    'upload_permissions' => 'User upload permission settings',
    'upload_permissions_text' => 'Note: User private clouds (clouds added by users in "My Cloud") are not restricted, so the "default space" set here does not apply to user private clouds.',
    'setting_main_default' => 'Default user space size, in MB. 0 or empty means no restriction; -1 means no space',
    'setting_main_file_size' => 'Maximum allowed file size for upload, in MB. 0 or empty means no restriction',
    'setting_main_file_suffix' => 'Allowed file extensions for upload; separate multiple extensions with half-width commas. Leave empty for no restriction',
    'left_side' => 'Left side',
    'right_side' => 'Right side',
    'top' => 'Top',
    'bottom' => 'Bottom',
    'left_top_corner' => 'Top-left corner',
    'right_top_corner' => 'Top-right corner',
    'right_bottom_corner' => 'Bottom-right corner',
    'left_bottom_corner' => 'Bottom-left corner',
    'between' => 'Center',
    'token_url' => 'Callback URL',
    'main_title_page' => 'Page main title',
    'main_title_page_state' => 'Large title on the left side of the independent login page.',
    'page_subtitle' => 'Page subtitle',
    'page_subtitle_state' => 'Subtitle on the left side of the independent login page.',
    'for_color_set' => 'Can be a color (e.g.: #FFF), an image (ending with .jpeg, .jpg, .png), or a URL.',
    'administrator_email' => 'Administrator email',
    'administrator_email_state' => 'Administrator E-mail, which will be used as the sender address when the system sends emails',
    'mail_way_send' => 'Email sending method',
    'mail_way_send1' => 'Send via PHP function sendmail (recommended method)',
    'mail_way_send2' => 'Send via SOCKET connection to SMTP server (supports ESMTP authentication)',
    'mail_way_send3' => 'Send Email via PHP function SMTP (only valid for Windows hosts, does not support ESMTP authentication)',
    'mail_way_send4' => '<th>Delete</th><th>SMTP Server</th><th>Port</th><th>Authentication</th><th>Sender Email Address</th><th>SMTP Authentication Username</th><th>SMTP Authentication Password</th>',
    'add_SMTP_server' => 'Add new SMTP server',
    'add_SMTP_server_set' => '<th>Delete</th><th>SMTP Server</th><th>Port</th>',
    'email_header_separator' => 'Email header separator',
    'email_header_separator1' => 'Use CRLF as separator (usually for Windows hosts)',
    'email_header_separator2' => 'Use LF as separator (usually for Unix/Linux hosts)',
    'email_header_separator3' => 'Use CR as separator (usually for Mac hosts)',
    'email_header_separator4' => 'Please adjust this parameter according to your mail server settings',
    'recipients_user' => 'Recipient address contains username',
    'shield_email_error' => 'Hide all error prompts during email sending',
    'allow_new_user_registration' => 'Allow new user registration',
    'open_enrollment' => 'Open registration',
    'open_enrollment_text' => 'Set whether to allow guests to register as platform members; you can choose the registration method according to platform needs',
    'register_link_text' => 'Registration link text',
    'register_link_text_text' => 'Set the link text for the platform registration page; the default is "Register Now"',
    'password_min_length' => 'Minimum password length',
    'password_min_length_state' => 'Minimum password length for new user registration; 0 or empty means no restriction',
    'mandatory_password_complexity' => 'Mandatory password complexity',
    'mandatory_password_complexity_state' => 'When registering a new user, the password must contain the selected character types; no restriction if none are selected',
    'new_user_registration_verification' => 'New user registration verification',
    'email_verify' => 'Email verification',
    'human_review' => 'Manual review',
    'new_user_registration_verification_state' => 'Select "None" to allow users to register successfully directly; select "Email Verification" to send a verification email to the user\'s registered email to confirm the validity of the email address, and the user can complete activation by clicking the link in the email',
    'send_welcome_message' => 'Send welcome message',
    'send_welcome_email' => 'Send welcome Email',
    'title_system_sends_welcome_message' => 'Title of the welcome message sent by the system; HTML is not supported, and the length cannot exceed 75 bytes',
    'welcome_message_content' => 'Welcome message content',
    'welcome_message_content_state' => '<li>Content of the welcome message sent by the system. Both the title and content support variable replacement; the following variables can be used:</li><li>{username} : Username</li><li>{time} : Sending time</li>
                                <li>{sitename} : Website name (name displayed in the contact information at the bottom of the page)</li><li>{bbname} : Platform name (name displayed in the browser window title, etc.)</li><li> {adminemail} : Administrator Email</li>',
    'according_site_terms_service' => 'Display website terms of service',
    'registration_website_terms_service' => 'Display website terms of service when new users register',
    'select_according_site_terms_service' => 'Whether to force display of website terms of service',
    'terms_service_content' => 'Terms of service content',
    'details_sites_terms_service' => 'Detailed content of the website terms of service',
    'wide_high_expression_images' => 'Width and height of emoji images',
    'wide_high_expression_images_state' => 'The allowed range is 20-40; if the actual size of the image exceeds the set value, it will be automatically resized for display',
    'expression_list' => 'Number of emoji columns',
    'expression_list_state' => 'Number of columns for displaying emojis; the allowed range is 8-12',
    'expression_line' => 'Number of emoji rows',
    'expression_line_state' => 'Number of rows for displaying emojis',
    'default_date_format' => 'Default date format',
    'default_date_format_state' => 'Use yyyy (or yy) for year, mm for month, and dd for day. For example, yyyy-mm-dd represents 2000-1-1',
    'default_time_format' => 'Default time format',
    'hourly' => 'Hour format',
    'human_time_format' => 'Humanized time format',
    'human_time_format_state' => 'Select "Yes" to display time on the platform in formats such as "n minutes ago", "Yesterday", "n days ago", etc.',
    'default_time_bad' => 'Default time difference',
    'default_time_bad_state' => 'Time difference between local time and GMT. You can also enter the time difference manually for daylight saving time, e.g.: -7.5',
    'setting_mainboard_message_state' => '<li>To use images as verification code text: The images must contain the 24 characters "2346789BCEFGHJKMPQRTVWXY", be transparent GIF images with a transparent background and black foreground (black is the first index color of the image). There is no restriction on image size, but it is recommended that the width does not exceed 1/4 of the verification code width and the height does not exceed the verification code height. After creation, create a new subdirectory under static/image/seccode/gif/ (the directory name can be arbitrary), and upload the 24 created GIF images to this new subdirectory</li>
                        <li>To use images as the verification code background: Upload the created JPG images to the static/image/seccode/background/ directory, and the platform will randomly use the images in this directory as the verification code background</li>
                        <li>To use TTF fonts as verification code text: Upload the downloaded TTF English font files to the static/image/seccode/font/en/ directory, and the platform will randomly use the font files in this directory as the verification code text</li>
                        <li>Before using Chinese image verification codes: Upload TTF Chinese font files containing complete Chinese characters to the static/image/seccode/font/ch/ directory, and the platform will randomly use the font files in this directory as the verification code text</li>
                        <li>The system verification code is located in the core/class/seccode/ directory.</li>',
    'enable_authentication_code' => 'Enable verification code',
    'new_user_register' => 'New user registration',
    'edit_password' => 'Change password',
    'edit_password_state' => 'Verification codes can prevent malicious registration and login; please select the operations for which verification codes need to be enabled. Note: Enabling verification codes will complicate some operations, so it is recommended to enable them only when necessary',
    'verification_code_type' => 'Verification code type',
    'verification_code_type1' => 'English image verification code',
    'verification_code_type2' => 'Chinese image verification code',
    'verification_code_type3' => 'Flash verification code',
    'verification_code_type4' => 'Voice verification code',
    'verification_code_type5' => 'Bitmap verification code',
    'verification_code_type_state' => 'Set the type of verification code. Chinese image verification codes require your host to support the FreeType library. To display Flash verification codes, it is recommended that your host supports the Ming library to improve security',
    'captcha_preview' => 'Verification code preview',
    'captcha_img_width' => 'Verification code image width',
    'captcha_img_width_state' => 'Width of the verification code image; the allowed range is 100-200',
    'captcha_img_height' => 'Verification code image height',
    'captcha_img_height_state' => 'Height of the verification code image; the allowed range is 30-80',
    'images_break_up' => 'Image disruption',
    'images_break_up_state' => 'Disrupt the generated verification code image; enter the disruption level (0 means no disruption)',
    'random_image_background' => 'Random image background',
    'random_image_background_state' => 'Select "Yes" to randomly use JPG images in the static/image/seccode/background/ directory as the verification code background image; select "No" to use a random background color',
    'random_background_graphics' => 'Random background graphics',
    'random_background_graphics_state' => 'Select "Yes" to add random graphics to the verification code background',
    'rabdom_ttf_font' => 'Random TTF font',
    'rabdom_ttf_font_state' => '<li>Select "Yes" to randomly use TTF font files in the static/image/seccode/font/en/ directory to generate verification code text</li>
                                            <li>Select "No" to randomly use GIF images in the static/image/seccode/gif/ directory to generate verification code text</li>
                                            <li>Chinese image verification codes will randomly use TTF font files in the static/image/seccode/font/ch/ directory, so no need to set this item</li>',
    'rabdom_inclination' => 'Random inclination',
    'rabdom_inclination_state' => 'Select "Yes" to add random inclination to the verification code text; this setting only applies to verification codes using TTF fonts',
    'rabdom_tortuosity' => 'Random distortion',
    'rabdom_tortuosity_state' => 'Select "Yes" to add random distortion to the verification code text; this setting only applies to verification codes using TTF fonts',
    'rabdom_color' => 'Random color',
    'rabdom_color_state' => 'Select "Yes" to add random colors to the verification code background graphics and text',
    'rabdom_size' => 'Random size',
    'rabdom_size_state' => 'Select "Yes" to display verification code text in random sizes',
    'text_shadow' => 'Text shadow',
    'text_shadow_state' => 'Select "Yes" to add shadows to the verification code text',
    'gif_animation' => 'GIF animation',
    'gif_animation_state' => 'Select "Yes" to display the verification code as a GIF animation; select "No" to display it as a static image',
    'words_to_replace' => 'Replace sensitive words with',
    'words_to_replace_state' => 'Sensitive words will be replaced with the characters set here',
    'need_words_to_replace' => 'Sensitive words to be replaced',
    'need_words_to_replace_state' => 'Separate multiple words with half-width commas',
    'CorpID' => 'This is a developer credential. You need to log in to the [WeChat Work Platform], go to [Settings] - [Permission Management] - [Management] - [Select the management group to be bound to the DzzOffice platform], scroll to the bottom, and copy the CorpID value',
    'CorpSecret' => 'This is a developer credential. You need to log in to the [WeChat Work Platform], go to [Settings] - [Permission Management] - [Management] - [Select the management group to be bound to the DzzOffice platform], scroll to the bottom, and copy the Secret value',
    'locking_range' => 'Synchronization scope',
    'locking_range_state' => '<li>Only users within the synchronization scope will be synchronized to WeChat</li>
                            <li>Users not within the synchronization scope will be disabled in WeChat if they already exist there</li>
                            <li>If the user limit of the WeChat Work account is sufficient, it is recommended to set the scope to "All"</li>',
    // admin/setting/smiley.html
    'seeting_smiley_search' => 'This operation will automatically search for unused emojis in the static/image/smiley/$value[directory] directory and add them to the emoji category "$value[name]" automatically. Please confirm!',
    'seeting_add_new' => 'No unused emoji categories found. You can create an emoji category directory in the static/image/smiley/ directory via FTP, upload emoji images, and then refresh this page. Emoji category directory names can only contain numbers, 26 English letters, and underscores',
    'seeting_smiley_board_message_state' => '<li>Emoji export includes emoji category information and emoji code information; please download emoji image files via FTP.</li>
                            <li>Do not enable too many emoji categories at the same time, and control the length of emoji category names to avoid the emoji window being unable to fully display all emoji categories.</li>
                            <li>To delete an emoji category, please first delete all emojis under that category.</li>',
    'seeting_smileyedit_prefix' => 'Please enter the emoji prefix and suffix. It is recommended to use symbols such as [( : as the prefix and symbols such as )] : as the suffix',
    'seeting_wxsyn_bound_state' => 'Synchronization here is generally only required for the first binding<br/>The synchronization operation will sync the organizations, departments, and users under the organizations/departments of this site to WeChat Work<br/>Operations in organization and user management will be automatically synced to WeChat, no manual synchronization here is needed<br/>This synchronization will not sync the organizations, departments, and users in WeChat Work to this site<br/>Users not within the synchronization scope will be disabled in WeChat if they already exist there',
    'start_sync_weixin' => 'Start syncing to WeChat Work ↑',
    'start_sync_weixin_down' => 'Start syncing from WeChat Work ↓',
    'are_synchronized' => 'Syncing in progress, please wait...',
    'start_sync_section_weixin' => 'Sync organizations and departments to WeChat Work',
    'start_sync_section_weixin_down' => 'Sync organizations and departments from WeChat Work',
    'synchronization_section_p' => '<p>Sync of organizations and departments completed, now syncing users...</p>',
    'synchronization_weinxin' => 'Sync to WeChat Work',
    'synchronization_weinxin_down' => 'Sync from WeChat Work',
    'synchronization_success' => '<p class="success">Sync completed</p>',
    'synchronization_weinxin_success' => 'Successfully synced to WeChat',
    'synchronization_weinxin_success_down' => 'Successfully synced from WeChat',
    'setting_timezone' => ['' => 'Select public time zone', '-12' => '(GMT -12:00) Eniwetok, Kwajalein', '-11' => '(GMT -11:00) Midway Island, Samoa', '-10' => '(GMT -10:00) Hawaii', '-9' => '(GMT -09:00) Alaska', '-8' => '(GMT -08:00) Pacific Time (US & Canada), Tijuana', '-7' => '(GMT -07:00) Mountain Time (US & Canada), Arizona', '-6' => '(GMT -06:00) Central Time (US & Canada), Mexico City', '-5' => '(GMT -05:00) Eastern Time (US & Canada), Bogota, Lima, Quito', '-4' => '(GMT -04:00) Atlantic Time (Canada), Caracas, La Paz', '-3.5' => '(GMT -03:30) Newfoundland', '-3' => '(GMT -03:00) Brasilia, Buenos Aires, Georgetown, Falkland Islands', '-2' => '(GMT -02:00) Mid-Atlantic, Ascension Island, St. Helena', '-1' => '(GMT -01:00) Azores, Cape Verde Islands [Greenwich Mean Time] Dublin, London, Lisbon, Casablanca', '0' => '(GMT) Casablanca, Dublin, Edinburgh, London, Lisbon, Monrovia', '1' => '(GMT +01:00) Berlin, Brussels, Copenhagen, Madrid, Paris, Rome', '2' => '(GMT +02:00) Helsinki, Kaliningrad, South Africa, Warsaw', '3' => '(GMT +03:00) Baghdad, Riyadh, Moscow, Nairobi', '3.5' => '(GMT +03:30) Tehran', '4' => '(GMT +04:00) Abu Dhabi, Baku, Muscat, Tbilisi', '4.5' => '(GMT +04:30) Kabul', '5' => '(GMT +05:00) Yekaterinburg, Islamabad, Karachi, Tashkent', '5.5' => '(GMT +05:30) Mumbai, Kolkata, Madras, New Delhi', '5.75' => '(GMT +05:45) Kathmandu', '6' => '(GMT +06:00) Almaty, Colombo, Dhaka, Novosibirsk', '6.5' => '(GMT +06:30) Yangon', '7' => '(GMT +07:00) Bangkok, Hanoi, Jakarta', '8' => '(GMT +08:00) Beijing, Hong Kong, Perth, Singapore, Taipei', '9' => '(GMT +09:00) Osaka, Sapporo, Seoul, Tokyo, Yakutsk', '9.5' => '(GMT +09:30) Adelaide, Darwin', '10' => '(GMT +10:00) Canberra, Guam, Melbourne, Sydney, Vladivostok', '11' => '(GMT +11:00) Magadan, New Caledonia, Solomon Islands', '12' => '(GMT +12:00) Auckland, Wellington, Fiji, Marshall Islands'],
    'setting_smiley_expression_del' => 'Error deleting emoji category. You must first delete all emojis under this category',
    'setting_wxsyn_weixin' => '<p class="danger">Failed to obtain organization and department information from WeChat Work, unable to continue synchronization! Please check if the CorpID and CorpSecret of the WeChat Work account are correctly bound</p><p class="info">',
    'setting_wxsyn_organization' => '<span class="danger">Failed to create parent organization, skipping</span>',
    'setting_wxsyn_synchronization1' => 'Not within synchronization scope, disabled',
    'setting_wxsyn_synchronization2' => 'Not within synchronization scope, skipping',
    //	'nav_logs' => 'Operation Logs',
    'nav_logs_illegal' => 'Incorrect Password',
    'nav_logs_ban' => 'User Banned',
    'nav_logs_cp' => 'Backend Access',
    'nav_logs_invite' => 'Invitation to Register',
    'nav_logs_error' => 'System Error',
    'nav_logs_sendmail' => 'Email Sending Failed',
    'nav_logs_member' => 'User Records',
    'nav_logs_system' => 'System Records',
    'nav_logs_extended' => 'Extended Records',
    'logs' => 'Operation Logs',
    'logs_lpp' => 'Display per page',
    'logs_passwd' => 'Password Error Records',
    'logs_passwd_username' => 'Attempted Username',
    'logs_passwd_password' => 'Attempted Password',
    'logs_passwd_security' => 'Security Question',
    'logs_cp' => 'System Management Records',
    'logs_error' => 'System Error Records',
    'logs_noexpire' => 'Permanent Validity',
    'logs_invite_status_1' => 'Usable',
    'logs_invite_status_2' => 'Used',
    'logs_invite_status_3' => 'Sent',
    'logs_tips_illegal' => '<li>To display IP addresses in password error records, you need to enable the IP viewing function in the management group.</li>',
    'logs_tips_ban' => '<li>To display user ban records, you need to enable the user banning function in the management group.</li>',
    'logs_select_operation' => 'Please select type',
    'logs_viewtype' => 'View Mode',
    'logs_credit_relatedid' => 'Associated ID',
    'logs_task_id' => 'Task ID',
    'logs_member_id' => 'User ID',
    'logs_usergroup_id' => 'User Group ID',
    'logs_report_id' => 'Report ID',
    'logs_click2view' => 'Click to View',
    'logs_archive' => 'Archive',
    'logs_lock' => 'Lock',
    'logs_unlock' => 'Unlock',
    'logs_select_ridtype' => 'Please select associated ID type',

    'setting_mail_check' => 'Test',
    'setting_mail_check_test_from' => 'Test Sender',
    'setting_mail_check_test_to' => 'Test Recipient',
    'setting_mail_check_test_to_comment' => 'To test an email address containing a username, use the format "username &lt;user@domain.com&gt;". Separate multiple email addresses with commas',
    'setting_mail_check_submit' => 'Test Email Sending Settings',
    // admin/system
    'upgrade_latest_version' => 'You are currently using the latest version, no upgrade needed',
    'nav_founder_upgrade' => 'Online Upgrade',
    'founder_upgrade_updatelist' => 'Get Pending Update File List',
    'founder_upgrade_download' => 'Download Updates',
    'founder_upgrade_compare' => 'Local File Comparison',
    'founder_upgrade_upgrading' => 'Upgrading in Progress',
    'founder_upgrade_complete' => 'Upgrade Completed',
    'founder_upgrade_store_directory' => '<b>File Storage Directory:</b> ',
    'founder_upgrade_diff_show' => 'Comparison result with local files. The status <span style="color:red;">Difference</span> indicates that the local file has been modified<br />Note: If your source files were uploaded to the server via <span style="color:red;">non-binary</span> mode, the comparison result may be inaccurate',
    'founder_upgrade_diff' => 'Difference',
    'founder_upgrade_new' => 'Newly Added',
    'founder_upgrade_download_file' => 'All upgrade files have been downloaded and stored in the server directory: ',
    'founder_upgrade_backup_file' => 'Continuing the upgrade will back up existing old files to the directory: ',
    'founder_upgrade_backup_file2' => ', and overwrite them with new files',
    'founder_upgrade_force' => 'Force Upgrade',
    'founder_upgrade_regular' => 'Normal Upgrade',
    'founder_upgrade_set_ftp' => 'Set FTP Account',
    'founder_upgrade_reset' => 'Retry',
    'founder_upgrade_reupload' => 'Re-upload',
    'founder_upgrade_reset_ftp' => 'Reset FTP Account',
    'founder_upgrade_recopy' => 'Re-copy',

    'new' => 'New',
    'founder_upgrade_require_config' => 'Requires configuration to meet',
    'founder_upgrade_backup_remind' => 'Please back up the program and database before automatic upgrade. Confirm to start the upgrade?',
    'founder_upgrade_automatically' => 'Automatic Upgrade',
    'founder_upgrade_manually' => 'Manual Download',
    'founder_upgrade_select_version' => 'A new version is detected for upgrade. You can choose automatic upgrade or download the installation package for manual upgrade.',
    'founder_upgrade_continue' => 'Continue Upgrade',
    'founder_upgrade_recheck' => 'Re-check',
    'founder_upgrade_dbupdate' => 'Upgrade Database',
    'upgrade_right_now' => 'A new version of the DzzOffice program has been released. Please upgrade in time<span>Online Upgrade</span>',

    'upgrade_checking' => 'Checking for new upgrade versions...',

    'upgrade_continue' => '<p>Your last upgrade reached <b>{steplang}</b>, please continue to complete the upgrade<p><p><input type="button" class="btn btn-success" onclick="window.location.href=\'{stepurl}\'" value="Continue Upgrade" />&nbsp;&nbsp;&nbsp;&nbsp;<input type="button" class="btn btn-default" onclick="window.location.href=\'{recheckurl}\'" value="Re-check" /></p>',
    'accounts_supreme_authority' => 'This account must have the following permissions: Read files, Write files, Delete files, Create directories, Inherit subdirectories',
    'upgrade_continue_db' => '<p>Your last upgrade reached <b>{steplang}</b>, please continue to complete the upgrade<p><p><input type="button" class="btn btn-success" onclick="createIframe(\'{stepurl}\')" value="Continue Upgrade">&nbsp;&nbsp;&nbsp;&nbsp;<input type="button" class="btn btn-default" onclick="window.location.href=\'{recheckurl}\'" value="Re-check" /></p>',

    'upgrade_close_site' => 'Before upgrading, please close the site first and back up files and data',
    'upgrade_none' => 'No upgrade information available {upgradeurl}',
    'upgrade_download_upgradelist_error' => 'Failed to get pending update file list. Retry? {upgradeurl}',
    'upgrade_download_complete_to_compare' => 'Pending update files downloaded. Will start local file comparison {upgradeurl}',
    'upgrade_redownload' => 'There was a problem downloading file {file}. Please check your server network and whether the data directory has write permission. Click Confirm after verification {upgradeurl}',
    'upgrade_downloading_file' => 'Downloading update file {file} from official server <br>Completed: {percent} {upgradeurl}',
    'upgrade_cannot_access_file' => 'It is found that your directories and files have no modification permission. Please fill in the FTP account, or modify the file permission to readable and writable and try again',
    'upgrade_backuping' => 'Backing up original files... {upgradeurl}',
    'upgrade_backup_error' => 'Error backing up original files {upgradeurl}',
    'upgrade_backup_complete' => 'Backup completed, starting upgrade... {upgradeurl}',
    'upgrade_ftp_upload_error' => 'Error uploading file {file} via FTP. Please modify file permissions and re-upload, or re-set the FTP account {upgradeurl}',
    'upgrade_copy_error' => 'Error copying file {file}. Please check if the original file exists, re-copy it, or upload the copied file via FTP {upgradeurl}',
    'upgrade_file_successful' => 'File upgrade completed, will enter database upgrade {upgradeurl}',
    'upgrade_successful' => 'Congratulations, upgrade successful! <br />Your current version is: [DzzOffice{version}] <br /><br />For security reasons, upgrade files have been saved to the {save_update_dir} directory, <br />Backup files have been saved to the {save_back_dir} directory {upgradeurl}',

    'filecheck_nofound_md5file' => 'Verification file does not exist, cannot perform this operation {upgradeurl}',
    'upgrade_param_error' => 'Incorrect request parameters',
    'failed_create_folder' => 'Failed to create folder',
    'table_b' => 'Table-<b>',
    'not_exist_please_check' => 'Does not exist, please check!',
    'backup_table_imp' => 'Backing up table <span class="imp">',
    'roll' => 'Volume',
    'backing_sheet' => 'Backing Up Table',
    'data_backup_complete' => 'Data backup completed, backup file',
    'backing_roll' => 'Backup Volume',
    'imp_backup_successful' => 'Congratulations! <span class="imp">Backup Successful</span>',
    'in_backup' => 'Backing up',
    'read_database_structure1' => 'Successfully read database structure!',
    'read_database_structure2' => 'Failed to read database structure!',
    'backup_failed' => 'Backup failed!',
    'mainframe' => 'Host',
    'creation_date' => 'Creation Date',
    'table_structure' => 'Table Structure',
    'archived_data_table' => 'Archive Table Data',
    'open_sql_file' => 'Failed to open SQL file!',
    'input_sql_file' => 'Failed to write to SQL file. Please check if the file is writable',
    'close_sql_file' => 'Failed to close SQL file!',
    'sql_file_nonentity' => 'SQL file does not exist! Please check',
    'please_not_refresh_data' => 'Do not refresh or close the browser to prevent program abortion. Accidental operation may damage the database structure!',
    'import_backup_data' => 'Importing backup data, please wait!',
    'import_sql' => 'Importing SQL',
    'data_import_success' => 'Database import successful!',
    'data_import_failure' => 'Database import failed!',
    'import_volume_classification' => 'Importing volume',
    'import_volume_classification1' => 'Import Volume',
    'import_volume_classification2' => 'Failed! The database structure may be damaged! Please try importing from Volume 1',
    'volume_classification_success' => 'All backups of this volume have been imported successfully! <br />',
    'support_upload_pictures_extensions' => 'Sorry, uploading images with this file extension is not supported',
    'upload_await' => 'Uploading, please wait',
    'new_permissions' => 'Create New Permission',
    'add_folder_permission_group' => 'Add file/folder permission groups',
    'choose_permission' => 'Permission Selection',
    'set_default_permission_group' => 'Set as Default Permission Group',
    'system_default' => 'System Default',
    'system_config' => 'System Configuration',
    'user_config' => 'User Configuration',
    'default_permission' => 'Default Permission',
    'inheritperm' => 'Inherit Parent Permission',
    'set_default' => 'Set as Default',
    'permission_group_open_succeeded' => 'Permission group enabled successfully',
    'permission_group_delete_succeeded' => 'Permission group deleted successfully',
    'permission_group_close_succeeded' => 'Permission group disabled successfully',
    'set_default_permission_succeeded' => 'Default permission set successfully',
    'delete_permission_group_sure' => 'Are you sure you want to delete this permission group? Deletion is irreversible',
    'jurisdiction' => 'Permission',
    'edit_usergroup_permissions' => 'Edit User Group Permissions',
    'add_usergroup_permissions' => 'Add User Group Permissions',

    'file_multiple_version_features' => 'File Multi-Version Settings',
    'allow_number_uploaded_versions' => 'Maximum Number of Versions',
    'allow_number_uploaded_versions_tip' => 'Controls the number of file versions. The default value is 0, which means no limit on the number of versions',

    'setSystemSpace' => 'System Space Settings',
    'setSystemSpace_tip' => 'Set the system space size. If left blank or set to 0, the space is unlimited; set to -1 means no storage space',

    'space_organization_set' => 'Organization Storage Space Settings',
    'space_organization_set_tip' => 'Set the default storage space size for organizations. If left blank or set to 0, it shares all system space; set to -1 means no storage space',
    'space_group_set' => 'Group Storage Space Settings',
    'space_group_set_tip' => 'Set the default storage space size for groups. If left blank or set to 0, it shares all system space; set to -1 means no storage space'
    ];
